/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies.scoring;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringStrategy;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringSupport;
import org.onebusaway.gtfs_merge.util.CacheByEntity;

public class TripStopsInCommonDuplicateScoringStrategy
implements DuplicateScoringStrategy<Trip> {
    private CacheByEntity<Trip, SortedSet<StopLocation>> _cache = new CacheByEntity<Trip, SortedSet<StopLocation>>(getStops);
    private static final Comparator<StopLocation> stopComparator = Comparator.comparingInt(Object::hashCode);
    private static CacheByEntity.CacheGetter<Trip, SortedSet<StopLocation>> getStops = (dao, trip) -> {
        TreeSet<StopLocation> stops = new TreeSet<StopLocation>(stopComparator);
        for (StopTime stopTime : dao.getStopTimesForTrip(trip)) {
            stops.add(stopTime.getStop());
        }
        return stops;
    };

    @Override
    public double score(GtfsMergeContext context, Trip source, Trip target) {
        SortedSet<StopLocation> sourceStops = this.getStopsForTrip(context.getSource(), source);
        SortedSet<StopLocation> targetStops = this.getStopsForTrip((GtfsRelationalDao)context.getTarget(), target);
        return DuplicateScoringSupport.scoreElementOverlap(sourceStops, targetStops);
    }

    private SortedSet<StopLocation> getStopsForTrip(GtfsRelationalDao dao, Trip trip) {
        return this._cache.getItemForEntity(dao, trip);
    }
}

