/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AbstractIdentifiableSingleEntityMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.MergeSupport;
import org.onebusaway.gtfs_merge.strategies.scoring.StopDistanceDuplicateScoringStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopMergeStrategy
extends AbstractIdentifiableSingleEntityMergeStrategy<Stop> {
    private static Logger _log = LoggerFactory.getLogger(StopMergeStrategy.class);

    public StopMergeStrategy() {
        super(Stop.class);
        this._duplicateScoringStrategy.addPropertyMatch("name");
        this._duplicateScoringStrategy.addStrategy(new StopDistanceDuplicateScoringStrategy());
    }

    @Override
    protected void replaceDuplicateEntry(GtfsMergeContext context, Stop oldStop, Stop newStop) {
        GtfsRelationalDao source = context.getSource();
        for (StopTime stopTime : source.getStopTimesForStop(oldStop)) {
            stopTime.setStop((StopLocation)newStop);
        }
        MergeSupport.bulkReplaceValueInProperties(source.getAllTransfers(), oldStop, newStop, "fromStop", "toStop");
        MergeSupport.bulkReplaceValueInProperties(source.getAllPathways(), oldStop, newStop, "fromStop", "toStop");
    }

    @Override
    protected void save(GtfsMergeContext context, IdentityBean<?> entity) {
        GtfsRelationalDao source = context.getSource();
        GtfsMutableRelationalDao target = context.getTarget();
        Stop stop = (Stop)entity;
        super.save(context, entity);
    }
}

