/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AbstractIdentifiableSingleEntityMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.MergeSupport;
import org.onebusaway.gtfs_merge.strategies.scoring.RouteStopsInCommonDuplicateScoringStrategy;

public class RouteMergeStrategy
extends AbstractIdentifiableSingleEntityMergeStrategy<Route> {
    public RouteMergeStrategy() {
        super(Route.class);
        this._duplicateScoringStrategy.addPropertyMatch("agency");
        this._duplicateScoringStrategy.addPropertyMatch("shortName");
        this._duplicateScoringStrategy.addPropertyMatch("longName");
        this._duplicateScoringStrategy.addStrategy(new RouteStopsInCommonDuplicateScoringStrategy());
    }

    @Override
    protected void replaceDuplicateEntry(GtfsMergeContext context, Route oldRoute, Route newRoute) {
        GtfsRelationalDao source = context.getSource();
        for (Trip trip : source.getTripsForRoute(oldRoute)) {
            trip.setRoute(newRoute);
        }
        MergeSupport.bulkReplaceValueInProperties(source.getAllFareRules(), oldRoute, newRoute, "route");
    }
}

