/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.EDuplicateDetectionStrategy;
import org.onebusaway.gtfs_merge.strategies.EDuplicateRenamingStrategy;
import org.onebusaway.gtfs_merge.strategies.ELogDuplicatesStrategy;
import org.onebusaway.gtfs_merge.strategies.EntityMergeStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityMergeStrategy
implements EntityMergeStrategy {
    private static final Logger _log = LoggerFactory.getLogger(AbstractEntityMergeStrategy.class);
    protected EDuplicateDetectionStrategy _duplicateDetectionStrategy = null;
    protected double _minElementsInCommonScoreForAutoDetect = 0.5;
    protected double _minElementsDuplicateScoreForAutoDetect = 0.5;
    protected double _minElementDuplicateScoreForFuzzyMatch = 0.5;
    protected ELogDuplicatesStrategy _logDuplicatesStrategy = ELogDuplicatesStrategy.NONE;
    private EDuplicateRenamingStrategy _duplicateRenamingStrategy = EDuplicateRenamingStrategy.CONTEXT;

    public void setDuplicateDetectionStrategy(EDuplicateDetectionStrategy duplicateDetectionStrategy) {
        this._duplicateDetectionStrategy = duplicateDetectionStrategy;
    }

    public void setLogDuplicatesStrategy(ELogDuplicatesStrategy logDuplicatesStrategy) {
        this._logDuplicatesStrategy = logDuplicatesStrategy;
    }

    public void setDuplicateRenamingStrategy(EDuplicateRenamingStrategy duplicateRenamingStrategy) {
        this._duplicateRenamingStrategy = duplicateRenamingStrategy;
    }

    public EDuplicateRenamingStrategy getDuplicateRenamingStrategy() {
        return this._duplicateRenamingStrategy;
    }

    protected EDuplicateDetectionStrategy determineDuplicateDetectionStrategy(GtfsMergeContext context) {
        if (this._duplicateDetectionStrategy != null) {
            return this._duplicateDetectionStrategy;
        }
        EDuplicateDetectionStrategy resolvedDuplicateDetectionStrategy = context.getResolvedDuplicateDetectionStrategy();
        if (resolvedDuplicateDetectionStrategy == null) {
            resolvedDuplicateDetectionStrategy = this.pickBestDuplicateDetectionStrategy(context);
            _log.info("best duplicate detection strategy for " + this.getDescription() + " = " + String.valueOf((Object)resolvedDuplicateDetectionStrategy));
            context.setResolvedDuplicateDetectionStrategy(resolvedDuplicateDetectionStrategy);
        }
        return resolvedDuplicateDetectionStrategy;
    }

    protected abstract EDuplicateDetectionStrategy pickBestDuplicateDetectionStrategy(GtfsMergeContext var1);

    protected abstract String getDescription();
}

