/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies.scoring;

import java.util.List;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringStrategy;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringSupport;

public class TripScheduleOverlapDuplicateScoringStrategy
implements DuplicateScoringStrategy<Trip> {
    @Override
    public double score(GtfsMergeContext context, Trip source, Trip target) {
        int[] sourceInterval = this.getScheduleIntervalForTrip(context.getSource(), source);
        int[] targetInterval = this.getScheduleIntervalForTrip((GtfsRelationalDao)context.getTarget(), target);
        if (sourceInterval == null || targetInterval == null) {
            return 0.0;
        }
        return DuplicateScoringSupport.scoreIntervalOverlap(sourceInterval, targetInterval);
    }

    private int[] getScheduleIntervalForTrip(GtfsRelationalDao dao, Trip trip) {
        List stopTimes = dao.getStopTimesForTrip(trip);
        if (stopTimes.isEmpty()) {
            return null;
        }
        StopTime first = (StopTime)stopTimes.getFirst();
        StopTime last = (StopTime)stopTimes.getLast();
        if (!first.isDepartureTimeSet() || !last.isArrivalTimeSet()) {
            throw new IllegalStateException("expected departure time for first stop and arrival time for last stop to be set for trip with id " + String.valueOf(trip.getId()));
        }
        int minTime = first.getDepartureTime();
        int maxTime = last.getArrivalTime();
        return new int[]{minTime, maxTime};
    }
}

