/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies.scoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringStrategy;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringSupport;

public class RouteStopsInCommonDuplicateScoringStrategy
implements DuplicateScoringStrategy<Route> {
    @Override
    public double score(GtfsMergeContext context, Route source, Route target) {
        Set<StopLocation> sourceStops = this.getAllStopsForRoute(context.getSource(), source);
        Set<StopLocation> targetStops = this.getAllStopsForRoute((GtfsRelationalDao)context.getTarget(), target);
        return DuplicateScoringSupport.scoreElementOverlap(sourceStops, targetStops);
    }

    private Set<StopLocation> getAllStopsForRoute(GtfsRelationalDao dao, Route route) {
        HashSet<StopLocation> stops = new HashSet<StopLocation>();
        ArrayList tripsForRoute = new ArrayList();
        tripsForRoute.addAll(dao.getTripsForRoute(route));
        for (Trip trip : tripsForRoute) {
            ArrayList stopTimesForTrip = new ArrayList();
            stopTimesForTrip.addAll(dao.getStopTimesForTrip(trip));
            for (StopTime stopTime : stopTimesForTrip) {
                stops.add(stopTime.getStop());
            }
        }
        return stops;
    }
}

