/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import java.util.Collection;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AbstractCollectionEntityMergeStrategy;

public class ShapePointMergeStrategy
extends AbstractCollectionEntityMergeStrategy<AgencyAndId> {
    public ShapePointMergeStrategy() {
        super("shapes.txt shape_id");
    }

    @Override
    public void getEntityTypes(Collection<Class<?>> entityTypes) {
        entityTypes.add(ShapePoint.class);
    }

    @Override
    protected Collection<AgencyAndId> getKeys(GtfsRelationalDao dao) {
        return dao.getAllShapeIds();
    }

    @Override
    protected double scoreDuplicateKey(GtfsMergeContext context, AgencyAndId key) {
        return 0.0;
    }

    @Override
    protected void renameKey(GtfsMergeContext context, AgencyAndId oldId, AgencyAndId newId) {
        GtfsRelationalDao source = context.getSource();
        for (ShapePoint shapePoint : source.getShapePointsForShapeId(oldId)) {
            shapePoint.setShapeId(newId);
        }
        for (Trip trip : source.getTripsForShapeId(oldId)) {
            trip.setShapeId(newId);
        }
    }

    @Override
    protected void saveElementsForKey(GtfsMergeContext context, AgencyAndId shapeId) {
        GtfsRelationalDao source = context.getSource();
        GtfsMutableRelationalDao target = context.getTarget();
        for (ShapePoint shapePoint : source.getShapePointsForShapeId(shapeId)) {
            shapePoint.setId(Integer.valueOf(0));
            shapePoint.setSequence(context.getNextSequenceCounter());
            target.saveEntity((Object)shapePoint);
        }
    }
}

