/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.strategies.EDuplicateDetectionStrategy;

public class GtfsMergeContext {
    private final GtfsRelationalDao source;
    private final GtfsMutableRelationalDao target;
    private final String prefix;
    private final Map<String, Object> entityByRawId;
    private final Set<String> entitiesJustAdded = new HashSet<String>();
    private int _sequenceCounter = 1;
    private EDuplicateDetectionStrategy _resolvedDuplicateDetectionStrategy;

    public GtfsMergeContext(GtfsRelationalDao source, GtfsMutableRelationalDao target, String prefix, Map<String, Object> entityByRawId) {
        this.source = source;
        this.target = target;
        this.prefix = prefix;
        this.entityByRawId = entityByRawId;
    }

    public GtfsRelationalDao getSource() {
        return this.source;
    }

    public GtfsMutableRelationalDao getTarget() {
        return this.target;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void putEntityWithRawId(String rawId, Object entity) {
        this.entityByRawId.put(rawId, entity);
        this.entitiesJustAdded.add(rawId);
    }

    public Object getEntityForRawId(String rawId) {
        return this.entityByRawId.get(rawId);
    }

    public boolean isEntityJustAddedWithRawId(String rawId) {
        return this.entitiesJustAdded.contains(rawId);
    }

    public int getNextSequenceCounter() {
        return this._sequenceCounter++;
    }

    public EDuplicateDetectionStrategy getResolvedDuplicateDetectionStrategy() {
        return this._resolvedDuplicateDetectionStrategy;
    }

    public void setResolvedDuplicateDetectionStrategy(EDuplicateDetectionStrategy resolvedDuplicateDetectionStrategy) {
        this._resolvedDuplicateDetectionStrategy = resolvedDuplicateDetectionStrategy;
    }
}

