/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities;

import java.util.ArrayList;
import java.util.List;

public class DelimitedTextParser {
    private final char _delimiter;
    private boolean _trimInitialWhitespace = false;

    public DelimitedTextParser(char delimiter) {
        this._delimiter = delimiter;
    }

    public void setTrimInitialWhitespace(boolean trimInitialWhitespace) {
        this._trimInitialWhitespace = trimInitialWhitespace;
    }

    public final List<String> parse(String line) {
        EParseState resetState;
        StringBuilder token = new StringBuilder();
        ArrayList<StringBuilder> tokens = new ArrayList<StringBuilder>();
        if (line.length() > 0) {
            tokens.add(token);
        }
        EParseState state = resetState = this._trimInitialWhitespace ? EParseState.TRIM_INIT_WHITESPACE : EParseState.DATA;
        block19: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (state.ordinal()) {
                case 0: {
                    if (c == this._delimiter) {
                        token = new StringBuilder();
                        tokens.add(token);
                        continue block19;
                    }
                    switch (c) {
                        case ' ': {
                            continue block19;
                        }
                        case '\"': {
                            if (token.length() == 0) {
                                state = EParseState.DATA_IN_QUOTES;
                                continue block19;
                            }
                            token.append(c);
                            continue block19;
                        }
                    }
                    state = EParseState.DATA;
                    token.append(c);
                    continue block19;
                }
                case 1: {
                    if (c == this._delimiter) {
                        token = new StringBuilder();
                        tokens.add(token);
                        state = resetState;
                        continue block19;
                    }
                    switch (c) {
                        case '\"': {
                            if (token.length() == 0) {
                                state = EParseState.DATA_IN_QUOTES;
                                continue block19;
                            }
                            token.append(c);
                            continue block19;
                        }
                    }
                    token.append(c);
                    continue block19;
                }
                case 2: {
                    switch (c) {
                        case '\"': {
                            state = EParseState.END_QUOTE;
                            continue block19;
                        }
                    }
                    token.append(c);
                    continue block19;
                }
                case 3: {
                    if (c == this._delimiter) {
                        token = new StringBuilder();
                        tokens.add(token);
                        state = resetState;
                        continue block19;
                    }
                    switch (c) {
                        case '\"': {
                            token.append('\"');
                            state = EParseState.DATA_IN_QUOTES;
                            continue block19;
                        }
                    }
                    token.append(c);
                    state = EParseState.DATA;
                }
            }
        }
        ArrayList<String> retro = new ArrayList<String>(tokens.size());
        for (StringBuilder b : tokens) {
            retro.add(b.toString());
        }
        return retro;
    }

    private static enum EParseState {
        TRIM_INIT_WHITESPACE,
        DATA,
        DATA_IN_QUOTES,
        END_QUOTE;

    }
}

