/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.CsvEntityContextImpl;
import org.onebusaway.csv_entities.CsvInputSource;
import org.onebusaway.csv_entities.CsvTokenizerStrategy;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.csv_entities.FileCsvInputSource;
import org.onebusaway.csv_entities.IndividualCsvEntityReader;
import org.onebusaway.csv_entities.TokenizerStrategy;
import org.onebusaway.csv_entities.ZipFileCsvInputSource;
import org.onebusaway.csv_entities.exceptions.CsvEntityIOException;
import org.onebusaway.csv_entities.exceptions.MissingRequiredEntityException;
import org.onebusaway.csv_entities.schema.DefaultEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchema;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;

public class CsvEntityReader {
    public static final String KEY_CONTEXT = CsvEntityReader.class.getName() + ".context";
    private EntitySchemaFactory _entitySchemaFactory = new DefaultEntitySchemaFactory();
    private EntityHandlerImpl _handler = new EntityHandlerImpl();
    private CsvEntityContextImpl _context = new CsvEntityContextImpl();
    private CsvInputSource _source;
    private TokenizerStrategy _tokenizerStrategy = new CsvTokenizerStrategy();
    private List<EntityHandler> _handlers = new ArrayList<EntityHandler>();
    private boolean _trimValues = false;
    private boolean _internStrings = false;
    private Map<String, String> _stringTable = new HashMap<String, String>();

    public EntitySchemaFactory getEntitySchemaFactory() {
        return this._entitySchemaFactory;
    }

    public void setEntitySchemaFactory(EntitySchemaFactory entitySchemaFactory) {
        this._entitySchemaFactory = entitySchemaFactory;
    }

    public CsvInputSource getInputSource() {
        return this._source;
    }

    public void setInputSource(CsvInputSource source) {
        this._source = source;
    }

    public void setInputLocation(File path) throws IOException {
        this._source = path.isDirectory() ? new FileCsvInputSource(path) : new ZipFileCsvInputSource(new ZipFile(path));
    }

    public void setTokenizerStrategy(TokenizerStrategy tokenizerStrategy) {
        this._tokenizerStrategy = tokenizerStrategy;
    }

    public void setTrimValues(boolean trimValues) {
        this._trimValues = trimValues;
    }

    public void addEntityHandler(EntityHandler handler) {
        this._handlers.add(handler);
    }

    public CsvEntityContext getContext() {
        return this._context;
    }

    public void setInternStrings(boolean internStrings) {
        this._internStrings = internStrings;
    }

    public void readEntities(Class<?> entityClass) throws IOException {
        this.readEntities(entityClass, this._source);
    }

    public void readEntities(Class<?> entityClass, CsvInputSource source) throws IOException {
        InputStream is = this.openInputStreamForEntityClass(source, entityClass);
        if (is != null) {
            this.readEntities(entityClass, is);
        }
    }

    public void readEntities(Class<?> entityClass, InputStream is) throws IOException, CsvEntityIOException {
        this.readEntities(entityClass, new InputStreamReader(is, "UTF-8"));
    }

    public void readEntities(Class<?> entityClass, Reader reader) throws IOException, CsvEntityIOException {
        EntitySchema schema = this._entitySchemaFactory.getSchema(entityClass);
        IndividualCsvEntityReader entityLoader = this.createIndividualCsvEntityReader(this._context, schema, this._handler);
        entityLoader.setTrimValues(this._trimValues);
        BufferedReader lineReader = new BufferedReader(reader);
        lineReader.mark(1);
        int c = lineReader.read();
        if (c != 65279) {
            lineReader.reset();
        }
        String line = null;
        int lineNumber = 1;
        try {
            while ((line = lineReader.readLine()) != null) {
                if (line.isEmpty() || line.length() == 1 && line.charAt(0) == '\u001a') continue;
                List<String> values = this._tokenizerStrategy.parse(line);
                if (this._internStrings) {
                    this.internStrings(values);
                }
                entityLoader.handleLine(values);
                ++lineNumber;
            }
        }
        catch (Exception ex) {
            throw new CsvEntityIOException(entityClass, schema.getFilename(), lineNumber, ex);
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected IndividualCsvEntityReader createIndividualCsvEntityReader(CsvEntityContext context, EntitySchema schema, EntityHandler handler) {
        return new IndividualCsvEntityReader(context, schema, handler);
    }

    public void injectEntity(Object entity) {
        this._handler.handleEntity(entity);
    }

    public InputStream openInputStreamForEntityClass(CsvInputSource source, Class<?> entityClass) throws IOException {
        EntitySchema schema = this._entitySchemaFactory.getSchema(entityClass);
        String name = schema.getFilename();
        if (!this._source.hasResource(name)) {
            if (schema.isRequired()) {
                throw new MissingRequiredEntityException(entityClass, name);
            }
            return null;
        }
        return this._source.getResource(name);
    }

    public void close() throws IOException {
        if (this._source != null) {
            this._source.close();
        }
    }

    private void internStrings(List<String> values) {
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            String existing = this._stringTable.get(value);
            if (existing != null) {
                values.set(i, existing);
                continue;
            }
            this._stringTable.put(value, value);
        }
    }

    private class EntityHandlerImpl
    implements EntityHandler {
        private EntityHandlerImpl() {
        }

        @Override
        public void handleEntity(Object entity) {
            for (EntityHandler handler : CsvEntityReader.this._handlers) {
                handler.handleEntity(entity);
            }
        }
    }
}

