/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities.schema;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.csv_entities.exceptions.IntrospectionException;
import org.onebusaway.csv_entities.exceptions.MethodInvocationException;
import org.onebusaway.csv_entities.exceptions.NoSuchPropertyException;
import org.onebusaway.csv_entities.schema.BeanWrapper;

public class BeanWrapperFactory {
    private static Map<Class<?>, BeanClassWrapperImpl> _classWrappers = new HashMap();

    public static BeanWrapper wrap(Object object) {
        Class<?> c = object.getClass();
        BeanClassWrapperImpl classWrapper = _classWrappers.get(c);
        if (classWrapper == null) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(c);
                classWrapper = new BeanClassWrapperImpl(beanInfo);
                _classWrappers.put(c, classWrapper);
            }
            catch (Exception ex) {
                throw new IntrospectionException(c);
            }
        }
        return new BeanWrapperImpl(classWrapper, object);
    }

    private static class BeanClassWrapperImpl {
        private Map<String, Method> _readMethods = new HashMap<String, Method>();
        private Map<String, Method> _writeMethods = new HashMap<String, Method>();

        public BeanClassWrapperImpl(BeanInfo info) {
            PropertyDescriptor[] properties;
            for (PropertyDescriptor property : properties = info.getPropertyDescriptors()) {
                String name = property.getName();
                this._readMethods.put(name, property.getReadMethod());
                this._writeMethods.put(name, property.getWriteMethod());
            }
        }

        public Class<?> getPropertyType(Object object, String propertyName) {
            Method method = this._readMethods.get(propertyName);
            if (method == null) {
                throw new NoSuchPropertyException(object.getClass(), propertyName);
            }
            return method.getReturnType();
        }

        public Object getPropertyValue(Object object, String propertyName) {
            Method method = this._readMethods.get(propertyName);
            if (method == null) {
                throw new NoSuchPropertyException(object.getClass(), propertyName);
            }
            try {
                return method.invoke(object, new Object[0]);
            }
            catch (Exception ex) {
                throw new MethodInvocationException(object.getClass(), method, ex);
            }
        }

        public void setPropertyValue(Object object, String propertyName, Object value) {
            Method method = this._writeMethods.get(propertyName);
            if (method == null) {
                throw new NoSuchPropertyException(object.getClass(), propertyName);
            }
            try {
                method.invoke(object, value);
            }
            catch (Exception ex) {
                throw new MethodInvocationException(object.getClass(), method, ex);
            }
        }
    }

    private static class BeanWrapperImpl
    implements BeanWrapper {
        private BeanClassWrapperImpl _classWrapper;
        private Object _wrappedInstance;

        public BeanWrapperImpl(BeanClassWrapperImpl classWrapper, Object wrappedInstance) {
            this._classWrapper = classWrapper;
            this._wrappedInstance = wrappedInstance;
        }

        @Override
        public <T> T getWrappedInstance(Class<T> type) {
            return (T)this._wrappedInstance;
        }

        @Override
        public Class<?> getPropertyType(String propertyName) {
            return this._classWrapper.getPropertyType(this._wrappedInstance, propertyName);
        }

        @Override
        public Object getPropertyValue(String propertyName) {
            return this._classWrapper.getPropertyValue(this._wrappedInstance, propertyName);
        }

        @Override
        public void setPropertyValue(String propertyName, Object value) {
            this._classWrapper.setPropertyValue(this._wrappedInstance, propertyName, value);
        }
    }
}

