/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.IndividualCsvEntityWriter;
import org.onebusaway.csv_entities.OutputStrategy;
import org.onebusaway.csv_entities.exceptions.CsvException;
import org.onebusaway.csv_entities.schema.EntitySchema;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;

class ZipOutputStrategy
implements OutputStrategy {
    private final ZipOutputStream _out;
    private final PrintWriter _writer;
    private final Set<Class<?>> _typesWeHaveAlreadySeen = new HashSet();
    private Class<?> _currentType = null;
    private IndividualCsvEntityWriter _currentWriter = null;

    public ZipOutputStrategy(ZipOutputStream out, PrintWriter writer) {
        this._out = out;
        this._writer = writer;
    }

    public static ZipOutputStrategy create(File path) {
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(path));
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            return new ZipOutputStrategy(out, writer);
        }
        catch (IOException ex) {
            throw new CsvException("Error creating ZipOutputStrategy for path " + String.valueOf(path), ex);
        }
    }

    @Override
    public IndividualCsvEntityWriter getEntityWriter(EntitySchemaFactory entitySchemaFactory, CsvEntityContext context, Class<?> entityType) {
        if (this._currentType != null && this._currentType.equals(entityType)) {
            return this._currentWriter;
        }
        this.closeCurrentEntityWriter();
        if (!this._typesWeHaveAlreadySeen.add(entityType)) {
            throw new IllegalStateException("When writing to a ZIP output feed, entities cannot be written in arbitrary order but must be grouped by type.  You have attempted to write an entity of type " + String.valueOf(entityType) + " but the zip entry for that type has already been closed.");
        }
        this._currentType = entityType;
        EntitySchema schema = entitySchemaFactory.getSchema(entityType);
        ZipEntry entry = new ZipEntry(schema.getFilename());
        try {
            this._out.putNextEntry(entry);
        }
        catch (IOException ex) {
            throw new CsvException("Error opening zip entry", ex);
        }
        this._currentWriter = new IndividualCsvEntityWriter(context, schema, this._writer);
        return this._currentWriter;
    }

    @Override
    public void flush() throws IOException {
        this._out.flush();
    }

    @Override
    public void close() throws IOException {
        this.closeCurrentEntityWriter();
        this._out.close();
    }

    private void closeCurrentEntityWriter() {
        if (this._currentType != null) {
            try {
                this._writer.flush();
                this._out.closeEntry();
            }
            catch (IOException ex) {
                throw new CsvException("Error closing zip entry", ex);
            }
            this._currentWriter = null;
            this._currentType = null;
        }
    }
}

