/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities;

import java.util.ArrayList;
import java.util.List;

public class DelimitedTextParser {
    public static void parse(String line, List<String> tokens) {
        if (line.length() == 0) {
            tokens.add("");
            return;
        }
        DelimitedTextParser.parseImpl(line, tokens);
        if (line.charAt(line.length() - 1) == ',') {
            tokens.add("");
        }
    }

    public static List<String> parse(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        DelimitedTextParser.parse(line, tokens);
        return tokens;
    }

    private static void parseImpl(String line, List<String> tokens) {
        int lineLength = line.length();
        int i = 0;
        while (i < lineLength) {
            int startIndex;
            char c = line.charAt(i);
            if (c == ',') {
                tokens.add("");
                ++i;
                continue;
            }
            if (c == '\"') {
                startIndex = i + 1;
                do {
                    if (++i < lineLength) continue;
                    throw new IllegalStateException("Expected double quoted followed by delimiter or another double quote");
                } while (line.charAt(i) != '\"');
                int endIndex = i++;
                if (i >= lineLength) {
                    tokens.add(line.substring(startIndex, endIndex));
                    break;
                }
                if (line.charAt(i) == ',') {
                    tokens.add(line.substring(startIndex, endIndex));
                    ++i;
                    continue;
                }
                if (line.charAt(i) != '\"') {
                    throw new IllegalStateException("Expected double quote followed by delimiter or another double quote");
                }
                i = DelimitedTextParser.handleQuotedColumnWithEscape(line, tokens, startIndex, endIndex, i, lineLength);
                continue;
            }
            startIndex = i;
            while (++i < lineLength && line.charAt(i) != ',') {
            }
            tokens.add(line.substring(startIndex, i));
            ++i;
        }
    }

    private static int handleQuotedColumnWithEscape(String line, List<String> tokens, int startIndex, int endIndex, int i, int lineLength) {
        StringBuilder builder = new StringBuilder(Math.min(line.length() - startIndex, (endIndex - startIndex) * 2));
        builder.append(line, startIndex, endIndex);
        do {
            builder.append('\"');
            startIndex = i + 1;
            do {
                if (++i < lineLength) continue;
                throw new IllegalStateException("Expected end-quote");
            } while (line.charAt(i) != '\"');
            builder.append(line, startIndex, i);
            if (++i >= lineLength) {
                tokens.add(builder.toString());
                return i;
            }
            if (line.charAt(i) != ',') continue;
            tokens.add(builder.toString());
            return ++i;
        } while (line.charAt(i) == '\"');
        throw new IllegalStateException("Expected end of line or divider after double quote");
    }
}

