/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader.model;

import java.io.ByteArrayInputStream;
import java.util.List;
import org.ofdrw.core.signatures.appearance.StampAnnot;
import org.ofdrw.core.signatures.sig.SignedInfo;
import org.ofdrw.gm.ses.parse.SESVersion;
import org.ofdrw.gm.ses.parse.SESVersionHolder;
import org.ofdrw.gm.ses.v1.SES_ESPictrueInfo;
import org.ofdrw.gm.ses.v1.SES_Signature;
import org.ofdrw.gm.ses.v4.TBS_Sign;

public class StampAnnotEntity {
    private SignedInfo signedInfo;
    private byte[] imageByte;
    private String imgType;
    private SESVersionHolder sesVersionHolder;

    private StampAnnotEntity() {
    }

    public StampAnnotEntity(SESVersionHolder sesVersionHolder, SignedInfo signedInfo) {
        this.signedInfo = signedInfo;
        this.sesVersionHolder = sesVersionHolder;
        this.init();
    }

    private void init() {
        if (this.sesVersionHolder.getVersion() == SESVersion.v4) {
            org.ofdrw.gm.ses.v4.SES_Signature sesSignature = this.sesVersionHolder.getInstanceV4();
            TBS_Sign toSign = sesSignature.getToSign();
            SES_ESPictrueInfo picture = toSign.getEseal().geteSealInfo().getPicture();
            this.imgType = picture.getType().getString();
            this.imageByte = picture.getData().getOctets();
        } else {
            SES_Signature sesSignature = this.sesVersionHolder.getInstanceV1();
            org.ofdrw.gm.ses.v1.TBS_Sign toSign = sesSignature.getToSign();
            SES_ESPictrueInfo picture = toSign.getEseal().getEsealInfo().getPicture();
            this.imgType = picture.getType().getString();
            this.imageByte = picture.getData().getOctets();
        }
    }

    public List<StampAnnot> getStampAnnots() {
        return this.signedInfo.getStampAnnots();
    }

    public byte[] getImageByte() {
        return this.imageByte;
    }

    public String getImgType() {
        return this.imgType;
    }

    public ByteArrayInputStream getImageStream() {
        return new ByteArrayInputStream(this.imageByte);
    }

    public SESVersionHolder getHolder() {
        return this.sesVersionHolder;
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }
}

