/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.InformalTag;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.PagedResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TagsResponse
extends PagedResponse {
    private static final long serialVersionUID = 1L;
    private List<InformalTag> tags = null;

    public TagsResponse() {
    }

    public TagsResponse(TagsResponse template) {
        super(template);
        if (template != null) {
            this.tags = template.getTags();
        }
    }

    public List<InformalTag> getTags() {
        if (this.tags == null) {
            return null;
        }
        if (this.tags.isEmpty()) {
            return null;
        }
        ArrayList<InformalTag> clonedList = new ArrayList<InformalTag>();
        for (InformalTag existingElement : this.tags) {
            clonedList.add(new InformalTag(existingElement));
        }
        return clonedList;
    }

    public void setTags(List<InformalTag> tags) {
        this.tags = tags;
    }

    @Override
    public String toString() {
        return "TagsResponse{tags=" + this.tags + ", startingFromElement=" + this.getStartingFromElement() + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        TagsResponse that = (TagsResponse)((Object)objectToCompare);
        return this.getStartingFromElement() == that.getStartingFromElement() && Objects.equals(this.getTags(), that.getTags());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTags(), this.getStartingFromElement());
    }
}

