/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.database.connector;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.datamanager.api.DataManagerEventListener;
import org.odpi.openmetadata.accessservices.datamanager.client.ConnectionManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerEventClient;
import org.odpi.openmetadata.accessservices.datamanager.client.DatabaseManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseViewElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseForeignKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabasePrimaryKeyProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseViewProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class DatabaseIntegratorContext {
    private ConnectionManagerClient connectionManagerClient;
    private DatabaseManagerClient databaseManagerClient;
    private DataManagerEventClient eventClient;
    private String userId;
    private String databaseManagerGUID;
    private String databaseManagerName;

    public DatabaseIntegratorContext(DatabaseManagerClient databaseManagerClient, ConnectionManagerClient connectionManagerClient, DataManagerEventClient eventClient, String userId, String databaseManagerGUID, String databaseManagerName) {
        this.databaseManagerClient = databaseManagerClient;
        this.eventClient = eventClient;
        this.userId = userId;
        this.connectionManagerClient = connectionManagerClient;
        this.databaseManagerGUID = databaseManagerGUID;
        this.databaseManagerName = databaseManagerName;
    }

    public void registerListener(DataManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public String createDatabase(DatabaseProperties databaseProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.createDatabase(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseProperties);
    }

    public String createDatabaseFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.createDatabaseFromTemplate(this.userId, this.databaseManagerGUID, this.databaseManagerName, templateGUID, templateProperties);
    }

    public void updateDatabase(String databaseGUID, DatabaseProperties databaseProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.updateDatabase(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseGUID, databaseProperties);
    }

    public void publishDatabase(String databaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.publishDatabase(this.userId, databaseGUID);
    }

    public void withdrawDatabase(String databaseGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.withdrawDatabase(this.userId, databaseGUID);
    }

    public void removeDatabase(String databaseGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.removeDatabase(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseGUID, qualifiedName);
    }

    public List<DatabaseElement> findDatabases(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.findDatabases(this.userId, searchString, startFrom, pageSize);
    }

    public List<DatabaseElement> getDatabasesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getDatabasesByName(this.userId, name, startFrom, pageSize);
    }

    public List<DatabaseElement> getMyDatabases(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getDatabasesForDatabaseManager(this.userId, this.databaseManagerGUID, this.databaseManagerName, startFrom, pageSize);
    }

    public DatabaseElement getDatabaseByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getDatabaseByGUID(this.userId, guid);
    }

    public String createDatabaseSchema(String databaseGUID, DatabaseSchemaProperties databaseSchemaProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.createDatabaseSchema(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseGUID, databaseSchemaProperties);
    }

    public String createDatabaseSchemaFromTemplate(String templateGUID, String databaseGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.createDatabaseSchemaFromTemplate(this.userId, this.databaseManagerGUID, this.databaseManagerName, templateGUID, databaseGUID, templateProperties);
    }

    public void updateDatabaseSchema(String databaseSchemaGUID, DatabaseSchemaProperties databaseSchemaProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.updateDatabaseSchema(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseSchemaGUID, databaseSchemaProperties);
    }

    public void publishDatabaseSchema(String databaseSchemaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.publishDatabaseSchema(this.userId, databaseSchemaGUID);
    }

    public void withdrawDatabaseSchema(String databaseSchemaGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.withdrawDatabaseSchema(this.userId, databaseSchemaGUID);
    }

    public void removeDatabaseSchema(String databaseSchemaGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.removeDatabaseSchema(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseSchemaGUID, qualifiedName);
    }

    public List<DatabaseSchemaElement> findDatabaseSchemas(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.findDatabaseSchemas(this.userId, searchString, startFrom, pageSize);
    }

    public List<DatabaseSchemaElement> getSchemasForDatabase(String databaseGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getSchemasForDatabase(this.userId, databaseGUID, startFrom, pageSize);
    }

    public List<DatabaseSchemaElement> getDatabaseSchemasByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getDatabaseSchemasByName(this.userId, name, startFrom, pageSize);
    }

    public DatabaseSchemaElement getDatabaseSchemaByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getDatabaseSchemaByGUID(this.userId, guid);
    }

    public String createDatabaseTable(String databaseSchemaGUID, DatabaseTableProperties databaseTableProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.createDatabaseTable(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseSchemaGUID, databaseTableProperties);
    }

    public String createDatabaseTableFromTemplate(String templateGUID, String databaseSchemaGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.createDatabaseTableFromTemplate(this.userId, this.databaseManagerGUID, this.databaseManagerName, templateGUID, databaseSchemaGUID, templateProperties);
    }

    public void updateDatabaseTable(String databaseTableGUID, DatabaseTableProperties databaseTableProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.updateDatabaseTable(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseTableGUID, databaseTableProperties);
    }

    public void removeDatabaseTable(String databaseTableGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.removeDatabaseTable(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseTableGUID, qualifiedName);
    }

    public List<DatabaseTableElement> findDatabaseTables(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.findDatabaseTables(this.userId, searchString, startFrom, pageSize);
    }

    public List<DatabaseTableElement> getTablesForDatabaseSchema(String databaseSchemaGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getTablesForDatabaseSchema(this.userId, databaseSchemaGUID, startFrom, pageSize);
    }

    public List<DatabaseTableElement> getDatabaseTablesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getDatabaseTablesByName(this.userId, name, startFrom, pageSize);
    }

    public DatabaseTableElement getDatabaseTableByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getDatabaseTableByGUID(this.userId, guid);
    }

    public String createDatabaseView(String databaseSchemaGUID, DatabaseViewProperties databaseViewProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.createDatabaseView(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseSchemaGUID, databaseViewProperties);
    }

    public String createDatabaseViewFromTemplate(String templateGUID, String databaseSchemaGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.createDatabaseViewFromTemplate(this.userId, this.databaseManagerGUID, this.databaseManagerName, templateGUID, databaseSchemaGUID, templateProperties);
    }

    public void updateDatabaseView(String databaseViewGUID, DatabaseViewProperties databaseViewProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.updateDatabaseView(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseViewGUID, databaseViewProperties);
    }

    public void removeDatabaseView(String databaseViewGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.removeDatabaseView(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseViewGUID, qualifiedName);
    }

    public List<DatabaseViewElement> findDatabaseViews(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.findDatabaseViews(this.userId, searchString, startFrom, pageSize);
    }

    public List<DatabaseViewElement> getViewsForDatabaseSchema(String databaseSchemaGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getViewsForDatabaseSchema(this.userId, databaseSchemaGUID, startFrom, pageSize);
    }

    public List<DatabaseViewElement> getDatabaseViewsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getDatabaseViewsByName(this.userId, name, startFrom, pageSize);
    }

    public DatabaseViewElement getDatabaseViewByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getDatabaseViewByGUID(this.userId, guid);
    }

    public String createDatabaseColumn(String databaseTableGUID, DatabaseColumnProperties databaseColumnProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.createDatabaseColumn(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseTableGUID, databaseColumnProperties);
    }

    public String createDatabaseColumnFromTemplate(String templateGUID, String databaseTableGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.createDatabaseColumnFromTemplate(this.userId, this.databaseManagerGUID, this.databaseManagerName, templateGUID, databaseTableGUID, templateProperties);
    }

    public void updateDatabaseColumn(String databaseColumnGUID, DatabaseColumnProperties databaseColumnProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.updateDatabaseColumn(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseColumnGUID, databaseColumnProperties);
    }

    public void removeDatabaseColumn(String databaseColumnGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.removeDatabaseColumn(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseColumnGUID, qualifiedName);
    }

    public List<DatabaseColumnElement> findDatabaseColumns(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.findDatabaseColumns(this.userId, searchString, startFrom, pageSize);
    }

    public List<DatabaseColumnElement> getColumnsForDatabaseTable(String databaseTableGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getColumnsForDatabaseTable(this.userId, databaseTableGUID, startFrom, pageSize);
    }

    public List<DatabaseColumnElement> getDatabaseColumnsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getDatabaseColumnsByName(this.userId, name, startFrom, pageSize);
    }

    public DatabaseColumnElement getDatabaseColumnByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseManagerClient.getDatabaseColumnByGUID(this.userId, guid);
    }

    public void setPrimaryKeyOnColumn(String databaseColumnGUID, DatabasePrimaryKeyProperties databasePrimaryKeyProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.setPrimaryKeyOnColumn(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseColumnGUID, databasePrimaryKeyProperties);
    }

    public void removePrimaryKeyFromColumn(String databaseColumnGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.removePrimaryKeyFromColumn(this.userId, this.databaseManagerGUID, this.databaseManagerName, databaseColumnGUID);
    }

    public void addForeignKeyRelationship(String primaryKeyColumnGUID, String foreignKeyColumnGUID, DatabaseForeignKeyProperties databaseForeignKeyProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.addForeignKeyRelationship(this.userId, this.databaseManagerGUID, this.databaseManagerName, primaryKeyColumnGUID, foreignKeyColumnGUID, databaseForeignKeyProperties);
    }

    public void removeForeignKeyRelationship(String primaryKeyColumnGUID, String foreignKeyColumnGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.databaseManagerClient.removeForeignKeyRelationship(this.userId, this.databaseManagerGUID, this.databaseManagerName, primaryKeyColumnGUID, foreignKeyColumnGUID);
    }

    public String createConnection(ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createConnection(this.userId, null, null, connectionProperties);
    }

    public String createConnectionFromTemplate(String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createConnectionFromTemplate(this.userId, null, null, templateGUID, templateProperties);
    }

    public void updateConnection(String connectionGUID, boolean isMergeUpdate, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.updateConnection(this.userId, this.databaseManagerGUID, this.databaseManagerName, connectionGUID, isMergeUpdate, connectionProperties);
    }

    public void setupConnectorType(String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupConnectorType(this.userId, null, null, connectionGUID, connectorTypeGUID);
    }

    public void clearConnectorType(String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearConnectorType(this.userId, this.databaseManagerGUID, this.databaseManagerName, connectionGUID, connectorTypeGUID);
    }

    public void setupEndpoint(String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupEndpoint(this.userId, null, null, connectionGUID, endpointGUID);
    }

    public void clearEndpoint(String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearEndpoint(this.userId, this.databaseManagerGUID, this.databaseManagerName, connectionGUID, endpointGUID);
    }

    public void setupEmbeddedConnection(String connectionGUID, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupEmbeddedConnection(this.userId, null, null, connectionGUID, position, displayName, arguments, embeddedConnectionGUID);
    }

    public void clearEmbeddedConnection(String connectionGUID, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearEmbeddedConnection(this.userId, this.databaseManagerGUID, this.databaseManagerName, connectionGUID, embeddedConnectionGUID);
    }

    public void setupAssetConnection(String assetGUID, String assetSummary, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.setupAssetConnection(this.userId, null, null, assetGUID, assetSummary, connectionGUID);
    }

    public void clearAssetConnection(String assetGUID, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.clearAssetConnection(this.userId, this.databaseManagerGUID, this.databaseManagerName, assetGUID, connectionGUID);
    }

    public void removeConnection(String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.removeConnection(this.userId, this.databaseManagerGUID, this.databaseManagerName, connectionGUID);
    }

    public List<ConnectionElement> findConnections(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findConnections(this.userId, searchString, startFrom, pageSize);
    }

    public List<ConnectionElement> getConnectionsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectionsByName(this.userId, name, startFrom, pageSize);
    }

    public ConnectionElement getConnectionByGUID(String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectionByGUID(this.userId, connectionGUID);
    }

    public String createEndpoint(EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createEndpoint(this.userId, null, null, endpointProperties);
    }

    public String createEndpointFromTemplate(String networkAddress, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.createEndpointFromTemplate(this.userId, this.databaseManagerGUID, this.databaseManagerName, networkAddress, templateGUID, templateProperties);
    }

    public void updateEndpoint(boolean isMergeUpdate, String endpointGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.updateEndpoint(this.userId, this.databaseManagerGUID, this.databaseManagerName, isMergeUpdate, endpointGUID, endpointProperties);
    }

    public void removeEndpoint(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.connectionManagerClient.removeEndpoint(this.userId, this.databaseManagerGUID, this.databaseManagerName, endpointGUID);
    }

    public List<EndpointElement> findEndpoints(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findEndpoints(this.userId, searchString, startFrom, pageSize);
    }

    public List<EndpointElement> getEndpointsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getEndpointsByName(this.userId, name, startFrom, pageSize);
    }

    public EndpointElement getEndpointByGUID(String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getEndpointByGUID(this.userId, endpointGUID);
    }

    public List<ConnectorTypeElement> findConnectorTypes(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.findConnectorTypes(this.userId, searchString, startFrom, pageSize);
    }

    public List<ConnectorTypeElement> getConnectorTypesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectorTypesByName(this.userId, name, startFrom, pageSize);
    }

    public ConnectorTypeElement getConnectorTypeByGUID(String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionManagerClient.getConnectorTypeByGUID(this.userId, connectorTypeGUID);
    }
}

