/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.DisplayApplicationInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.SchemaManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataContainerElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFieldElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FormElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.QueryElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.ReportElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataContainerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFieldProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FormProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.QueryProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ReportProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataContainerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataContainerResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataContainersResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.ElementStubResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.FormRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FormResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.FormsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.QueriesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.QueryRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.QueryResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.ReportRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ReportResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.ReportsResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;

public class DisplayApplicationClient
extends SchemaManagerClient
implements DisplayApplicationInterface {
    private static final String formURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/forms";
    private static final String reportURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/reports";
    private static final String queryURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/queries";
    private static final String schemaURLTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schemas";
    private static final String defaultSchemaAttributeName = "DisplayDataField";

    public DisplayApplicationClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, auditLog);
    }

    public DisplayApplicationClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot);
    }

    public DisplayApplicationClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public DisplayApplicationClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public DisplayApplicationClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, userId, password);
    }

    public String createForm(String userId, String applicationGUID, String applicationName, boolean applicationIsHome, FormProperties formProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createForm";
        String propertiesParameterName = "formProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createForm");
        this.invalidParameterHandler.validateObject((Object)formProperties, "formProperties", "createForm");
        this.invalidParameterHandler.validateName(formProperties.getQualifiedName(), "qualifiedName", "createForm");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/forms?applicationIsHome={2}";
        FormRequestBody requestBody = new FormRequestBody(formProperties);
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createForm", urlTemplate, requestBody, new Object[]{this.serverName, userId, applicationIsHome});
        return restResult.getGUID();
    }

    public String createFormFromTemplate(String userId, String applicationGUID, String applicationName, boolean applicationIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFormFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createFormFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createFormFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createFormFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createFormFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/forms/from-template/{2}?applicationIsHome={3}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createFormFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, applicationIsHome});
        return restResult.getGUID();
    }

    public void updateForm(String userId, String applicationGUID, String applicationName, String formGUID, boolean isMergeUpdate, FormProperties formProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateForm";
        String elementGUIDParameterName = "formGUID";
        String propertiesParameterName = "formProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateForm");
        this.invalidParameterHandler.validateGUID(formGUID, "formGUID", "updateForm");
        this.invalidParameterHandler.validateObject((Object)formProperties, "formProperties", "updateForm");
        this.invalidParameterHandler.validateName(formProperties.getQualifiedName(), "qualifiedName", "updateForm");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/forms/{2}?isMergeUpdate={3}";
        FormRequestBody requestBody = new FormRequestBody(formProperties);
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        this.restClient.callVoidPostRESTCall("updateForm", urlTemplate, requestBody, new Object[]{this.serverName, userId, formGUID, isMergeUpdate});
    }

    public void publishForm(String userId, String formGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishForm";
        String elementGUIDParameterName = "formGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishForm");
        this.invalidParameterHandler.validateGUID(formGUID, "formGUID", "publishForm");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/forms/{2}/publish";
        this.restClient.callVoidPostRESTCall("publishForm", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, formGUID});
    }

    public void withdrawForm(String userId, String formGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawForm";
        String elementGUIDParameterName = "formGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawForm");
        this.invalidParameterHandler.validateGUID(formGUID, "formGUID", "withdrawForm");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/forms/{2}/withdraw";
        this.restClient.callVoidPostRESTCall("withdrawForm", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, formGUID});
    }

    public void removeForm(String userId, String applicationGUID, String applicationName, String formGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeForm";
        String elementGUIDParameterName = "formGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeForm");
        this.invalidParameterHandler.validateGUID(formGUID, "formGUID", "removeForm");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeForm");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/forms/{2}/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        this.restClient.callVoidPostRESTCall("removeForm", urlTemplate, requestBody, new Object[]{this.serverName, userId, formGUID, qualifiedName});
    }

    public List<FormElement> findForms(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findForms";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findForms");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findForms");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findForms");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/forms/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        FormsResponse restResult = this.restClient.callFormsPostRESTCall("findForms", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<FormElement> getFormsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFormsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getFormsByName");
        this.invalidParameterHandler.validateName(name, "name", "getFormsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getFormsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/forms/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        FormsResponse restResult = this.restClient.callFormsPostRESTCall("getFormsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<FormElement> getFormsForApplication(String userId, String applicationGUID, String applicationName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFormsForApplication";
        String applicationGUIDParameterName = "applicationGUID";
        String applicationNameParameterName = "applicationName";
        this.invalidParameterHandler.validateUserId(userId, "getFormsForApplication");
        this.invalidParameterHandler.validateGUID(applicationGUID, "applicationGUID", "getFormsForApplication");
        this.invalidParameterHandler.validateName(applicationName, "applicationName", "getFormsForApplication");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getFormsForApplication");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/forms/applications/{2}/{3}?startFrom={4}&pageSize={5}";
        FormsResponse restResult = this.restClient.callFormsGetRESTCall("getFormsForApplication", urlTemplate, this.serverName, userId, applicationGUID, applicationName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public FormElement getFormByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFormByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getFormByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getFormByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/forms/{2}";
        FormResponse restResult = this.restClient.callFormGetRESTCall("getFormByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public String createReport(String userId, String applicationGUID, String applicationName, boolean applicationIsHome, ReportProperties reportProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createReport";
        String propertiesParameterName = "reportProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createReport");
        this.invalidParameterHandler.validateObject((Object)reportProperties, "reportProperties", "createReport");
        this.invalidParameterHandler.validateName(reportProperties.getQualifiedName(), "qualifiedName", "createReport");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/reports?applicationIsHome={2}";
        ReportRequestBody requestBody = new ReportRequestBody(reportProperties);
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createReport", urlTemplate, requestBody, new Object[]{this.serverName, userId, applicationIsHome});
        return restResult.getGUID();
    }

    public String createReportFromTemplate(String userId, String applicationGUID, String applicationName, boolean applicationIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createReportFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createReportFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createReportFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createReportFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createReportFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/reports/from-template/{2}?applicationIsHome={3}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createReportFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, applicationIsHome});
        return restResult.getGUID();
    }

    public void updateReport(String userId, String applicationGUID, String applicationName, String reportGUID, boolean isMergeUpdate, ReportProperties reportProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateReport";
        String elementGUIDParameterName = "reportGUID";
        String propertiesParameterName = "reportProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateReport");
        this.invalidParameterHandler.validateGUID(reportGUID, "reportGUID", "updateReport");
        this.invalidParameterHandler.validateObject((Object)reportProperties, "reportProperties", "updateReport");
        this.invalidParameterHandler.validateName(reportProperties.getQualifiedName(), "qualifiedName", "updateReport");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/reports/{2}?isMergeUpdate={3}";
        ReportRequestBody requestBody = new ReportRequestBody(reportProperties);
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        this.restClient.callVoidPostRESTCall("updateReport", urlTemplate, requestBody, new Object[]{this.serverName, userId, reportGUID, isMergeUpdate});
    }

    public void publishReport(String userId, String reportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishReport";
        String elementGUIDParameterName = "reportGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishReport");
        this.invalidParameterHandler.validateGUID(reportGUID, "reportGUID", "publishReport");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/reports/{2}/publish";
        this.restClient.callVoidPostRESTCall("publishReport", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, reportGUID});
    }

    public void withdrawReport(String userId, String reportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawReport";
        String elementGUIDParameterName = "reportGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawReport");
        this.invalidParameterHandler.validateGUID(reportGUID, "reportGUID", "withdrawReport");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/reports/{2}/withdraw";
        this.restClient.callVoidPostRESTCall("withdrawReport", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, reportGUID});
    }

    public void removeReport(String userId, String applicationGUID, String applicationName, String reportGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeReport";
        String elementGUIDParameterName = "reportGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeReport");
        this.invalidParameterHandler.validateGUID(reportGUID, "reportGUID", "removeReport");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeReport");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/reports/{2}/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        this.restClient.callVoidPostRESTCall("removeReport", urlTemplate, requestBody, new Object[]{this.serverName, userId, reportGUID, qualifiedName});
    }

    public List<ReportElement> findReports(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findReports";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findReports");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findReports");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findReports");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/reports/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ReportsResponse restResult = this.restClient.callReportsPostRESTCall("findReports", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ReportElement> getReportsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getReportsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getReportsByName");
        this.invalidParameterHandler.validateName(name, "name", "getReportsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getReportsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/reports/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ReportsResponse restResult = this.restClient.callReportsPostRESTCall("getReportsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<ReportElement> getReportsForApplication(String userId, String applicationGUID, String applicationName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getReportsForApplication";
        String applicationGUIDParameterName = "applicationGUID";
        String applicationNameParameterName = "applicationName";
        this.invalidParameterHandler.validateUserId(userId, "getReportsForApplication");
        this.invalidParameterHandler.validateGUID(applicationGUID, "applicationGUID", "getReportsForApplication");
        this.invalidParameterHandler.validateName(applicationName, "applicationName", "getReportsForApplication");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getReportsForApplication");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/reports/applications/{2}/{3}?startFrom={4}&pageSize={5}";
        ReportsResponse restResult = this.restClient.callReportsGetRESTCall("getReportsForApplication", urlTemplate, this.serverName, userId, applicationGUID, applicationName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public ReportElement getReportByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getReportByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getReportByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getReportByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/reports/{2}";
        ReportResponse restResult = this.restClient.callReportGetRESTCall("getReportByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public String createQuery(String userId, String applicationGUID, String applicationName, boolean applicationIsHome, QueryProperties queryProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createQuery";
        String propertiesParameterName = "queryProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createQuery");
        this.invalidParameterHandler.validateObject((Object)queryProperties, "queryProperties", "createQuery");
        this.invalidParameterHandler.validateName(queryProperties.getQualifiedName(), "qualifiedName", "createQuery");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/queries?applicationIsHome={2}";
        QueryRequestBody requestBody = new QueryRequestBody(queryProperties);
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createQuery", urlTemplate, requestBody, new Object[]{this.serverName, userId, applicationIsHome});
        return restResult.getGUID();
    }

    public String createQueryFromTemplate(String userId, String applicationGUID, String applicationName, boolean applicationIsHome, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createQueryFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createQueryFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createQueryFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createQueryFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createQueryFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/queries/from-template/{2}?applicationIsHome={3}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createQueryFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID, applicationIsHome});
        return restResult.getGUID();
    }

    public void updateQuery(String userId, String applicationGUID, String applicationName, String queryGUID, boolean isMergeUpdate, QueryProperties queryProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateQuery";
        String elementGUIDParameterName = "queryGUID";
        String propertiesParameterName = "queryProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateQuery");
        this.invalidParameterHandler.validateGUID(queryGUID, "queryGUID", "updateQuery");
        this.invalidParameterHandler.validateObject((Object)queryProperties, "queryProperties", "updateQuery");
        this.invalidParameterHandler.validateName(queryProperties.getQualifiedName(), "qualifiedName", "updateQuery");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/queries/{2}?isMergeUpdate={3}";
        QueryRequestBody requestBody = new QueryRequestBody(queryProperties);
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        this.restClient.callVoidPostRESTCall("updateQuery", urlTemplate, requestBody, new Object[]{this.serverName, userId, queryGUID, isMergeUpdate});
    }

    public void publishQuery(String userId, String queryGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishQuery";
        String elementGUIDParameterName = "queryGUID";
        this.invalidParameterHandler.validateUserId(userId, "publishQuery");
        this.invalidParameterHandler.validateGUID(queryGUID, "queryGUID", "publishQuery");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/queries/{2}/publish";
        this.restClient.callVoidPostRESTCall("publishQuery", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, queryGUID});
    }

    public void withdrawQuery(String userId, String queryGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawQuery";
        String elementGUIDParameterName = "queryGUID";
        this.invalidParameterHandler.validateUserId(userId, "withdrawQuery");
        this.invalidParameterHandler.validateGUID(queryGUID, "queryGUID", "withdrawQuery");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/queries/{2}/withdraw";
        this.restClient.callVoidPostRESTCall("withdrawQuery", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, queryGUID});
    }

    public void removeQuery(String userId, String applicationGUID, String applicationName, String queryGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeQuery";
        String elementGUIDParameterName = "queryGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "removeQuery");
        this.invalidParameterHandler.validateGUID(queryGUID, "queryGUID", "removeQuery");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "removeQuery");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/queries/{2}/{3}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        this.restClient.callVoidPostRESTCall("removeQuery", urlTemplate, requestBody, new Object[]{this.serverName, userId, queryGUID, qualifiedName});
    }

    public List<QueryElement> findQueries(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findQueries";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findQueries");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findQueries");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findQueries");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/queries/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        QueriesResponse restResult = this.restClient.callQueriesPostRESTCall("findQueries", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<QueryElement> getQueriesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getQueriesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getQueriesByName");
        this.invalidParameterHandler.validateName(name, "name", "getQueriesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getQueriesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/queries/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        QueriesResponse restResult = this.restClient.callQueriesPostRESTCall("getQueriesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<QueryElement> getQueriesForApplication(String userId, String applicationGUID, String applicationName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getQueriesForApplication";
        String applicationGUIDParameterName = "applicationGUID";
        String applicationNameParameterName = "applicationName";
        this.invalidParameterHandler.validateUserId(userId, "getQueriesForApplication");
        this.invalidParameterHandler.validateGUID(applicationGUID, "applicationGUID", "getQueriesForApplication");
        this.invalidParameterHandler.validateName(applicationName, "applicationName", "getQueriesForApplication");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getQueriesForApplication");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/queries/applications/{2}/{3}?startFrom={4}&pageSize={5}";
        QueriesResponse restResult = this.restClient.callQueriesGetRESTCall("getQueriesForApplication", urlTemplate, this.serverName, userId, applicationGUID, applicationName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public QueryElement getQueryByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getQueryByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getQueryByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getQueryByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/queries/{2}";
        QueryResponse restResult = this.restClient.callQueryGetRESTCall("getQueryByGUID", urlTemplate, this.serverName, userId, guid);
        return restResult.getElement();
    }

    public String createDataContainer(String userId, String applicationGUID, String applicationName, boolean applicationIsHome, String parentElementGUID, DataContainerProperties dataContainerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataContainer";
        String propertiesParameterName = "dataContainerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataContainer");
        this.invalidParameterHandler.validateObject((Object)dataContainerProperties, "dataContainerProperties", "createDataContainer");
        this.invalidParameterHandler.validateName(dataContainerProperties.getQualifiedName(), "qualifiedName", "createDataContainer");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schemas/elements/{2}/data-containers?applicationIsHome={3}";
        DataContainerRequestBody requestBody = new DataContainerRequestBody(dataContainerProperties);
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDataContainer", urlTemplate, requestBody, new Object[]{this.serverName, userId, parentElementGUID, applicationIsHome});
        return restResult.getGUID();
    }

    public String createDataContainerFromTemplate(String userId, String applicationGUID, String applicationName, boolean applicationIsHome, String parentElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataContainerFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataContainerFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createDataContainerFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createDataContainerFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createDataContainerFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schemas/elements/{2}/data-containers/from-template/{3}?applicationIsHome={4}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDataContainerFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, parentElementGUID, templateGUID, applicationIsHome});
        return restResult.getGUID();
    }

    public void updateDataContainer(String userId, String applicationGUID, String applicationName, String dataContainerGUID, boolean isMergeUpdate, DataContainerProperties dataContainerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataContainer";
        String elementGUIDParameterName = "dataContainerGUID";
        String propertiesParameterName = "dataContainerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateDataContainer");
        this.invalidParameterHandler.validateGUID(dataContainerGUID, "dataContainerGUID", "updateDataContainer");
        this.invalidParameterHandler.validateObject((Object)dataContainerProperties, "dataContainerProperties", "updateDataContainer");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(dataContainerProperties.getQualifiedName(), "qualifiedName", "updateDataContainer");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schemas/data-containers/{2}?isMergeUpdate={3}";
        DataContainerRequestBody requestBody = new DataContainerRequestBody(dataContainerProperties);
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        this.restClient.callVoidPostRESTCall("updateDataContainer", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataContainerGUID, isMergeUpdate});
    }

    public void removeDataContainer(String userId, String applicationGUID, String applicationName, String dataContainerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDataContainer";
        String elementGUIDParameterName = "dataContainerGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeDataContainer");
        this.invalidParameterHandler.validateGUID(dataContainerGUID, "dataContainerGUID", "removeDataContainer");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schemas/data-containers/{2}/delete";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(applicationGUID);
        requestBody.setExternalSourceName(applicationName);
        this.restClient.callVoidPostRESTCall("removeDataContainer", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataContainerGUID});
    }

    public List<DataContainerElement> findDataContainers(String userId, String typeName, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDataContainers";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDataContainers");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDataContainers");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDataContainers");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schemas/data-containers/types/{2}/by-search-string?startFrom={3}&pageSize={4}";
        String requestTypeName = "DataContainer";
        if (typeName != null) {
            requestTypeName = typeName;
        }
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        DataContainersResponse restResult = this.restClient.callDataContainersPostRESTCall("findDataContainers", urlTemplate, requestBody, this.serverName, userId, requestTypeName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DataContainerElement> getDataContainersForElement(String userId, String parentElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDataContainer";
        String parentElementGUIDParameterName = "parentElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "findDataContainer");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "findDataContainer");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDataContainer");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schemas/data-containers/by-parent-element/{2}?startFrom={4}&pageSize={5}";
        DataContainersResponse restResult = this.restClient.callDataContainersGetRESTCall("findDataContainer", urlTemplate, this.serverName, userId, parentElementGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DataContainerElement> getDataContainerByName(String userId, String name, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataContainerByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDataContainerByName");
        this.invalidParameterHandler.validateName(name, "name", "getDataContainerByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDataContainerByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schemas/data-containers/types/{2}/by-name?startFrom={3}&pageSize={4}";
        String requestTypeName = "DataContainer";
        if (typeName != null) {
            requestTypeName = typeName;
        }
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        DataContainersResponse restResult = this.restClient.callDataContainersPostRESTCall("getDataContainerByName", urlTemplate, requestBody, this.serverName, userId, requestTypeName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public DataContainerElement getDataContainerByGUID(String userId, String dataContainerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataContainerByGUID";
        String guidParameterName = "dataContainerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataContainerByGUID");
        this.invalidParameterHandler.validateGUID(dataContainerGUID, "dataContainerGUID", "getDataContainerByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schemas/data-containers/{2}";
        DataContainerResponse restResult = this.restClient.callDataContainerGetRESTCall("getDataContainerByGUID", urlTemplate, this.serverName, userId, dataContainerGUID);
        return restResult.getElement();
    }

    public ElementStub getDataContainerParent(String userId, String dataContainerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataContainerByGUID";
        String guidParameterName = "dataContainerGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataContainerByGUID");
        this.invalidParameterHandler.validateGUID(dataContainerGUID, "dataContainerGUID", "getDataContainerByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/schemas/data-containers/{2}/parent";
        ElementStubResponse restResult = this.restClient.callElementStubGetRESTCall("getDataContainerByGUID", urlTemplate, this.serverName, userId, dataContainerGUID);
        return restResult.getElement();
    }

    public String createDataField(String userId, String applicationGUID, String applicationName, boolean applicationIsHome, String parentElementGUID, DataFieldProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataField";
        String parentElementGUIDParameterName = "parentElementGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataField");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "createDataField");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createDataField");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createDataField");
        if (applicationIsHome) {
            return super.createSchemaAttribute(userId, applicationGUID, applicationName, parentElementGUID, (SchemaAttributeProperties)properties);
        }
        return super.createSchemaAttribute(userId, null, null, parentElementGUID, (SchemaAttributeProperties)properties);
    }

    public String createDataFieldFromTemplate(String userId, String applicationGUID, String applicationName, boolean applicationIsHome, String templateGUID, String parentElementGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataFieldFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "parentElementGUID";
        String propertiesParameterName = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createDataFieldFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createDataFieldFromTemplate");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "createDataFieldFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "createDataFieldFromTemplate");
        if (applicationIsHome) {
            return super.createSchemaAttributeFromTemplate(userId, applicationGUID, applicationName, parentElementGUID, templateGUID, templateProperties);
        }
        return super.createSchemaAttributeFromTemplate(userId, null, null, parentElementGUID, templateGUID, templateProperties);
    }

    public void setupSchemaType(String userId, String applicationGUID, String applicationName, boolean applicationIsHome, String relationshipTypeName, String apiParameterGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (applicationIsHome) {
            super.setupSchemaType(userId, applicationGUID, applicationName, relationshipTypeName, apiParameterGUID, schemaTypeGUID);
        } else {
            super.setupSchemaType(userId, null, null, relationshipTypeName, apiParameterGUID, schemaTypeGUID);
        }
    }

    public void updateDataField(String userId, String applicationGUID, String applicationName, String dataFieldGUID, boolean isMergeUpdate, DataFieldProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataField";
        String elementGUIDParameterName = "dataFieldGUID";
        String propertiesParameterName = "reportProperties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateDataField");
        this.invalidParameterHandler.validateGUID(dataFieldGUID, "dataFieldGUID", "updateDataField");
        this.invalidParameterHandler.validateObject((Object)properties, "reportProperties", "updateDataField");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateDataField");
        }
        super.updateSchemaAttribute(userId, applicationGUID, applicationName, dataFieldGUID, isMergeUpdate, (SchemaAttributeProperties)properties);
    }

    public void removeDataField(String userId, String applicationGUID, String applicationName, String dataFieldGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDataField";
        String elementGUIDParameterName = "dataFieldGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeDataField");
        this.invalidParameterHandler.validateGUID(dataFieldGUID, "dataFieldGUID", "removeDataField");
        super.removeSchemaAttribute(userId, applicationGUID, applicationName, dataFieldGUID);
    }

    private List<DataFieldElement> getDataFieldFromSchemaAttributes(List<SchemaAttributeElement> schemaAttributeElements) {
        if (schemaAttributeElements != null) {
            ArrayList<DataFieldElement> dataFieldElements = new ArrayList<DataFieldElement>();
            for (SchemaAttributeElement schemaAttributeElement : schemaAttributeElements) {
                if (schemaAttributeElement == null) continue;
                DataFieldElement dataFieldElement = new DataFieldElement(schemaAttributeElement);
                dataFieldElements.add(dataFieldElement);
            }
            if (!dataFieldElements.isEmpty()) {
                return dataFieldElements;
            }
        }
        return null;
    }

    public List<DataFieldElement> findDataFields(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findDataFields";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findDataFields");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findDataFields");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findDataFields");
        List<SchemaAttributeElement> schemaAttributeElements = super.findSchemaAttributes(userId, searchString, defaultSchemaAttributeName, startFrom, validatedPageSize);
        return this.getDataFieldFromSchemaAttributes(schemaAttributeElements);
    }

    public List<DataFieldElement> getChildDataFields(String userId, String parentElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFieldsForReport";
        String parentElementGUIDParameterName = "parentElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getDataFieldsForReport");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "getDataFieldsForReport");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDataFieldsForReport");
        List<SchemaAttributeElement> schemaAttributeElements = super.getNestedAttributes(userId, parentElementGUID, startFrom, validatedPageSize);
        return this.getDataFieldFromSchemaAttributes(schemaAttributeElements);
    }

    public List<DataFieldElement> getDataFieldsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFieldsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDataFieldsByName");
        this.invalidParameterHandler.validateName(name, "name", "getDataFieldsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getDataFieldsByName");
        List<SchemaAttributeElement> schemaAttributeElements = super.getSchemaAttributesByName(userId, name, defaultSchemaAttributeName, startFrom, validatedPageSize);
        return this.getDataFieldFromSchemaAttributes(schemaAttributeElements);
    }

    public DataFieldElement getDataFieldByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataFieldByGUID";
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDataFieldByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDataFieldByGUID");
        SchemaAttributeElement schemaAttributeElement = super.getSchemaAttributeByGUID(userId, guid);
        if (schemaAttributeElement != null) {
            return new DataFieldElement(schemaAttributeElement);
        }
        return null;
    }
}

