/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements ErrorHandler {
    private static final Logger LOG = Logger.getLogger(DefaultErrorHandler.class.getName());
    private ArrayList<SAXParseException> mWarnings = null;
    private ArrayList<SAXParseException> mErrors = null;
    private ArrayList<SAXParseException> mFatalErrors = null;
    private final StringBuilder mValidationMessages = new StringBuilder();

    private static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.mWarnings == null) {
            this.mWarnings = new ArrayList(1);
        }
        this.mWarnings.add(exception);
        this.mValidationMessages.append("\n\nVALIDATION WARNING:\n").append(DefaultErrorHandler.getStackTrace(exception)).append("\n");
        LOG.log(Level.WARNING, "\n\nVALIDATION WARNING:\n{0}\n", DefaultErrorHandler.getStackTrace(exception));
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (this.mErrors == null) {
            this.mErrors = new ArrayList(1);
        }
        this.mErrors.add(exception);
        this.mValidationMessages.append("\n\nVALIDATION ERROR:\n").append(DefaultErrorHandler.getStackTrace(exception)).append("\n");
        LOG.log(Level.SEVERE, "\n\nVALIDATION ERROR:\n{0}\n", DefaultErrorHandler.getStackTrace(exception));
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.mFatalErrors == null) {
            this.mFatalErrors = new ArrayList(1);
        }
        this.mFatalErrors.add(exception);
        this.mValidationMessages.append("\n\nVALIDATION FATALERROR:\n").append(DefaultErrorHandler.getStackTrace(exception)).append("\n");
        LOG.log(Level.SEVERE, "\n\nVALIDATION FATALERROR:\n{0}\n", DefaultErrorHandler.getStackTrace(exception));
        throw exception;
    }

    public List<SAXParseException> getWarnings() {
        return this.mWarnings;
    }

    public List<SAXParseException> getErrors() {
        return this.mErrors;
    }

    public List<SAXParseException> getFatalErrors() {
        return this.mFatalErrors;
    }

    public String getValidationMessages() {
        return this.mValidationMessages.toString();
    }
}

