/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.table.TableDefaultCellStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableNumberRowsRepeatedAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableVisibilityAttribute;
import org.odftoolkit.odfdom.dom.attribute.xml.XmlIdAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;

public class TableTableRowElement
extends OdfStylableElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TABLE, "table-row");
    private static final String VISIBLE = "visible";
    private static final String COLLAPSE = "collapse";

    public TableTableRowElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME, OdfStyleFamily.TableRow, OdfName.newName(OdfDocumentNamespace.TABLE, "style-name"));
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getTableDefaultCellStyleNameAttribute() {
        TableDefaultCellStyleNameAttribute attr = (TableDefaultCellStyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TABLE, "default-cell-style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTableDefaultCellStyleNameAttribute(String tableDefaultCellStyleNameValue) {
        TableDefaultCellStyleNameAttribute attr = new TableDefaultCellStyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(tableDefaultCellStyleNameValue);
    }

    public Integer getTableNumberRowsRepeatedAttribute() {
        TableNumberRowsRepeatedAttribute attr = (TableNumberRowsRepeatedAttribute)this.getOdfAttribute(OdfDocumentNamespace.TABLE, "number-rows-repeated");
        if (attr != null) {
            return attr.intValue();
        }
        return Integer.valueOf("1");
    }

    public void setTableNumberRowsRepeatedAttribute(Integer tableNumberRowsRepeatedValue) {
        TableNumberRowsRepeatedAttribute attr = new TableNumberRowsRepeatedAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(tableNumberRowsRepeatedValue);
    }

    public String getTableStyleNameAttribute() {
        TableStyleNameAttribute attr = (TableStyleNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TABLE, "style-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTableStyleNameAttribute(String tableStyleNameValue) {
        TableStyleNameAttribute attr = new TableStyleNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(tableStyleNameValue);
    }

    public String getTableVisibilityAttribute() {
        TableVisibilityAttribute attr = (TableVisibilityAttribute)this.getOdfAttribute(OdfDocumentNamespace.TABLE, "visibility");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return VISIBLE;
    }

    public void setTableVisibilityAttribute(String tableVisibilityValue) {
        TableVisibilityAttribute attr = new TableVisibilityAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(tableVisibilityValue);
    }

    public String getXmlIdAttribute() {
        XmlIdAttribute attr = (XmlIdAttribute)this.getOdfAttribute(OdfDocumentNamespace.XML, "id");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setXmlIdAttribute(String xmlIdValue) {
        XmlIdAttribute attr = new XmlIdAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(xmlIdValue);
    }

    public TableCoveredTableCellElement newTableCoveredTableCellElement(double officeValueValue, String officeValueTypeValue) {
        TableCoveredTableCellElement tableCoveredTableCell = ((OdfFileDom)this.ownerDocument).newOdfElement(TableCoveredTableCellElement.class);
        tableCoveredTableCell.setOfficeValueAttribute(officeValueValue);
        tableCoveredTableCell.setOfficeValueTypeAttribute(officeValueTypeValue);
        this.appendChild((Node)((Object)tableCoveredTableCell));
        return tableCoveredTableCell;
    }

    public TableTableCellElement newTableTableCellElement(double officeValueValue, String officeValueTypeValue) {
        TableTableCellElement tableTableCell = ((OdfFileDom)this.ownerDocument).newOdfElement(TableTableCellElement.class);
        tableTableCell.setOfficeValueAttribute(officeValueValue);
        tableTableCell.setOfficeValueTypeAttribute(officeValueTypeValue);
        this.appendChild((Node)((Object)tableTableCell));
        return tableTableCell;
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    @Override
    public boolean isComponentRoot() {
        return true;
    }

    public void setVisiblity(Boolean show) {
        boolean isVisible = Boolean.TRUE;
        if (this.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "visibility")) {
            isVisible = VISIBLE.equals(this.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "visibility"));
        }
        if (show.booleanValue() && !isVisible || !show.booleanValue() && isVisible) {
            if (show.booleanValue()) {
                this.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), VISIBLE);
            } else {
                this.setAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "table:visibility", COLLAPSE);
            }
        }
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void setRepetition(int repetition) {
        if (repetition >= 0) {
            this.setTableNumberRowsRepeatedAttribute(repetition);
        }
    }

    @Override
    public int getRepetition() {
        Integer repeated = this.getTableNumberRowsRepeatedAttribute();
        if (repeated == null) {
            repeated = 1;
        }
        return repeated;
    }

    @Override
    public OdfElement split(int posStart) {
        TableTableRowElement newElement = this;
        if (posStart > 0) {
            newElement = (TableTableRowElement)((Object)this.cloneNode(true));
            int repeated = this.getTableNumberRowsRepeatedAttribute();
            if (repeated > 1) {
                if (posStart > 1) {
                    this.setTableNumberRowsRepeatedAttribute(posStart);
                } else {
                    this.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-repeated");
                }
                if (repeated - posStart > 1) {
                    newElement.setTableNumberRowsRepeatedAttribute(repeated - posStart);
                } else {
                    newElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-repeated");
                }
            }
            OdfElement nextElementSibling = OdfElement.getNextSiblingElement((Node)((Object)this));
            OdfElement parent = (OdfElement)((Object)this.getParentNode());
            if (nextElementSibling == null) {
                parent.appendChild((Node)((Object)newElement));
            } else {
                parent.insertBefore((Node)((Object)newElement), (Node)((Object)nextElementSibling));
            }
        }
        return newElement;
    }
}

