/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.odftoolkit.odfdom.changes.Annotation;
import org.odftoolkit.odfdom.changes.Cell;
import org.odftoolkit.odfdom.changes.JsonOperationConsumer;
import org.odftoolkit.odfdom.changes.Row;
import org.odftoolkit.odfdom.changes.Table;
import org.odftoolkit.odfdom.changes.TextContainer;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.dr3d.Dr3dSceneElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCaptionElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCircleElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawConnectorElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawControlElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCustomShapeElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawEllipseElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawGElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawLineElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageThumbnailElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPathElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPolylineElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawRectElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawRegularPolygonElement;
import org.odftoolkit.odfdom.dom.element.form.FormConnectionResourceElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationEndElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeChartElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDatabaseElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDrawingElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeImageElement;
import org.odftoolkit.odfdom.dom.element.office.OfficePresentationElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeSpreadsheetElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterLeftElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderLeftElement;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnGroupElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowGroupElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowsElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextAuthorInitialsElement;
import org.odftoolkit.odfdom.dom.element.text.TextBookmarkElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextLineBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextListHeaderElement;
import org.odftoolkit.odfdom.dom.element.text.TextListItemElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.element.text.TextTabElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Component {
    private static final Logger LOG = Logger.getLogger(Component.class.getName());
    private static final String LIBRE_OFFICE_MS_INTEROP_NAMESPACE = "urn:openoffice:names:experimental:ooo-ms-interop:xmlns:field:1.0";
    private static final String LIBRE_OFFICE_MS_INTEROP_LOCALNAME = "fieldmark";
    List<Component> mChildren;
    public OdfElement mRootElement;
    private Component mParent;
    private Component mRootComponent;
    boolean mHasRepeated = false;

    public static boolean isComponentRoot(Element element) {
        boolean isComponent = false;
        if (element instanceof OdfElement) {
            isComponent = Component.isComponentRoot(((OdfElement)((Object)element)).getNamespaceURI(), ((OdfElement)((Object)element)).getLocalName());
        }
        return isComponent;
    }

    public static boolean isComponentRoot(String uri, String localName) {
        boolean isComponent = false;
        if (uri != null) {
            if (uri.equals(TextPElement.ELEMENT_NAME.getUri())) {
                if (localName.equals(TextPElement.ELEMENT_NAME.getLocalName())) {
                    isComponent = true;
                } else if (localName.equals(TextHElement.ELEMENT_NAME.getLocalName())) {
                    isComponent = true;
                } else if (localName.equals(TextTabElement.ELEMENT_NAME.getLocalName())) {
                    isComponent = true;
                } else if (localName.equals(TextLineBreakElement.ELEMENT_NAME.getLocalName())) {
                    isComponent = true;
                }
            } else if (uri.equals(TableTableElement.ELEMENT_NAME.getUri())) {
                if (localName.equals(TableTableElement.ELEMENT_NAME.getLocalName())) {
                    isComponent = true;
                } else if (localName.equals(TableTableRowElement.ELEMENT_NAME.getLocalName())) {
                    isComponent = true;
                } else if (localName.equals(TableTableCellElement.ELEMENT_NAME.getLocalName())) {
                    isComponent = true;
                }
            } else if (uri.equals(DrawFrameElement.ELEMENT_NAME.getUri()) && localName.equals(DrawFrameElement.ELEMENT_NAME.getLocalName())) {
                isComponent = true;
            } else if (Component.isShapeElement(uri, localName)) {
                isComponent = true;
            } else if (uri.equals(OfficeAnnotationElement.ELEMENT_NAME.getUri()) && localName.equals(OfficeAnnotationElement.ELEMENT_NAME.getLocalName()) || uri.equals(OfficeAnnotationEndElement.ELEMENT_NAME.getUri()) && localName.equals(OfficeAnnotationEndElement.ELEMENT_NAME.getLocalName())) {
                isComponent = true;
            }
            if (Component.isField(uri, localName)) {
                isComponent = true;
            }
        }
        return isComponent;
    }

    public static boolean isComponentWrapper(Element element) {
        boolean isWrapper = false;
        if (element instanceof OdfElement) {
            isWrapper = Component.isComponentWrapper(((OdfElement)((Object)element)).getNamespaceURI(), ((OdfElement)((Object)element)).getLocalName());
        }
        return isWrapper;
    }

    public static boolean isComponentWrapper(String uri, String localName) {
        boolean isWrapper = false;
        if (uri != null && uri.equals(TextListElement.ELEMENT_NAME.getUri())) {
            if (localName.equals(TextListElement.ELEMENT_NAME.getLocalName())) {
                isWrapper = true;
            } else if (localName.equals(TextListItemElement.ELEMENT_NAME.getLocalName())) {
                isWrapper = true;
            } else if (localName.equals(TextListHeaderElement.ELEMENT_NAME.getLocalName())) {
                isWrapper = true;
            } else if (localName.equals(TextBookmarkElement.ELEMENT_NAME.getLocalName())) {
                isWrapper = true;
            }
        } else if (uri != null && uri.equals(TableTableElement.ELEMENT_NAME.getUri())) {
            if (localName.equals(TableTableRowsElement.ELEMENT_NAME.getLocalName())) {
                isWrapper = true;
            } else if (localName.equals(TableTableRowGroupElement.ELEMENT_NAME.getLocalName())) {
                isWrapper = true;
            } else if (localName.equals(TableTableColumnsElement.ELEMENT_NAME.getLocalName())) {
                isWrapper = true;
            } else if (localName.equals(TableTableColumnGroupElement.ELEMENT_NAME.getLocalName())) {
                isWrapper = true;
            }
        }
        return isWrapper;
    }

    public static boolean isTextComponentRoot(Node textContainer) {
        boolean isTextElement = false;
        if (textContainer instanceof TextPElement || textContainer instanceof TextHElement) {
            isTextElement = true;
        }
        return isTextElement;
    }

    public static boolean isTextComponentRoot(String uri, String localName) {
        boolean isComponent = false;
        if (uri != null && uri.equals(TextPElement.ELEMENT_NAME.getUri())) {
            if (localName.equals(TextPElement.ELEMENT_NAME.getLocalName())) {
                isComponent = true;
            } else if (localName.equals(TextHElement.ELEMENT_NAME.getLocalName())) {
                isComponent = true;
            }
        }
        return isComponent;
    }

    public static boolean isRowComponentRoot(Node textContainer) {
        boolean isRowElement = false;
        if (textContainer instanceof TableTableRowElement) {
            isRowElement = true;
        }
        return isRowElement;
    }

    public static boolean isRowComponentRoot(String uri, String localName) {
        boolean isComponent = false;
        if (uri != null && uri.equals(TableTableRowElement.ELEMENT_NAME.getUri())) {
            if (localName.equals(TableTableRowElement.ELEMENT_NAME.getLocalName())) {
                isComponent = true;
            } else if (localName.equals(TextHElement.ELEMENT_NAME.getLocalName())) {
                isComponent = true;
            }
        }
        return isComponent;
    }

    public static boolean isField(String uri, String localName) {
        boolean isField = false;
        if (uri != null && uri.equals(TextAuthorInitialsElement.ELEMENT_NAME.getUri())) {
            if (localName.equals("author-initials") || localName.equals("author-name") || localName.equals("bookmark-ref") || localName.equals("chapter") || localName.equals("character-count") || localName.equals("conditional-text") || localName.equals("creation-date") || localName.equals("creation-time") || localName.equals("creator") || localName.equals("database-display") || localName.equals("database-name") || localName.equals("database-row-number") || localName.equals("date") || localName.equals("dde-connection") || localName.equals("description") || localName.equals("editing-cycles") || localName.equals("editing-duration") || localName.equals("execute-macro") || localName.equals("expression") || localName.equals("file-name") || localName.equals("hidden-paragraph") || localName.equals("hidden-text") || localName.equals("image-count") || localName.equals("initial-creator") || localName.equals("keywords") || localName.equals("measure") || localName.equals("meta-field") || localName.equals("modification-date") || localName.equals("modification-time") || localName.equals("note-ref") || localName.equals("object-count") || localName.equals("page-continuation") || localName.equals("page-count") || localName.equals("page-number") || localName.equals("page-variable-get") || localName.equals("page-variable-set") || localName.equals("paragraph-count") || localName.equals("placeholder") || localName.equals("print-date") || localName.equals("print-time") || localName.equals("printed-by") || localName.equals("reference-ref") || localName.equals("script") || localName.equals("sender-city") || localName.equals("sender-company") || localName.equals("sender-country") || localName.equals("sender-email") || localName.equals("sender-fax") || localName.equals("sender-firstname") || localName.equals("sender-initials") || localName.equals("sender-lastname") || localName.equals("sender-phone-private") || localName.equals("sender-phone-work") || localName.equals("sender-position") || localName.equals("sender-postal-code") || localName.equals("sender-state-or-province") || localName.equals("sender-street") || localName.equals("sender-title") || localName.equals("sequence-ref") || localName.equals("sequence") || localName.equals("sheet-name") || localName.equals("subject") || localName.equals("table-count") || localName.equals("template-name") || localName.equals("text-input") || localName.equals("time") || localName.equals("title") || localName.equals("user-defined") || localName.equals("user-field-get") || localName.equals("user-field-input") || localName.equals("variable-get") || localName.equals("variable-input") || localName.equals("variable-set") || localName.equals("word-count")) {
                isField = true;
            }
        } else if (uri != null && uri.equals(FormConnectionResourceElement.ELEMENT_NAME.getUri())) {
            if (localName.equals("connection-resource")) {
                isField = true;
            }
        } else if (uri != null && uri.equals(LIBRE_OFFICE_MS_INTEROP_NAMESPACE) && localName.equals(LIBRE_OFFICE_MS_INTEROP_LOCALNAME)) {
            isField = true;
        }
        return isField;
    }

    public static boolean isDocumentRoot(String uri, String localName) {
        boolean isRoot = false;
        if (uri.equals(OfficeTextElement.ELEMENT_NAME.getUri())) {
            if (localName.equals(OfficeTextElement.ELEMENT_NAME.getLocalName())) {
                isRoot = true;
            } else if (localName.equals(OfficeSpreadsheetElement.ELEMENT_NAME.getLocalName())) {
                isRoot = true;
            } else if (localName.equals(OfficePresentationElement.ELEMENT_NAME.getLocalName())) {
                isRoot = true;
            } else if (localName.equals(OfficeChartElement.ELEMENT_NAME.getLocalName())) {
                isRoot = true;
            } else if (localName.equals(OfficeDrawingElement.ELEMENT_NAME.getLocalName())) {
                isRoot = true;
            } else if (localName.equals(OfficeImageElement.ELEMENT_NAME.getLocalName())) {
                isRoot = true;
            } else if (localName.equals(OfficeDatabaseElement.ELEMENT_NAME.getLocalName())) {
                isRoot = true;
            }
        } else if (Component.isHeaderRoot(uri, localName) || Component.isFooterRoot(uri, localName)) {
            isRoot = true;
        }
        return isRoot;
    }

    public static boolean isHeaderRoot(String uri, String localName) {
        boolean isRoot = false;
        if (uri != null && uri.equals(StyleHeaderElement.ELEMENT_NAME.getUri()) && localName.equals(StyleHeaderElement.ELEMENT_NAME.getLocalName())) {
            isRoot = true;
        }
        if (uri != null && uri.equals(StyleHeaderLeftElement.ELEMENT_NAME.getUri()) && localName.equals(StyleHeaderLeftElement.ELEMENT_NAME.getLocalName())) {
            isRoot = true;
        }
        if (uri != null && uri.equals(StyleHeaderLeftElement.ELEMENT_NAME.getUri()) && localName.equals("header-first")) {
            isRoot = true;
        }
        return isRoot;
    }

    public static boolean isFooterRoot(String uri, String localName) {
        boolean isRoot = false;
        if (uri != null && uri.equals(StyleFooterElement.ELEMENT_NAME.getUri()) && localName.equals(StyleFooterElement.ELEMENT_NAME.getLocalName())) {
            isRoot = true;
        }
        if (uri != null && uri.equals(StyleFooterLeftElement.ELEMENT_NAME.getUri()) && localName.equals(StyleFooterLeftElement.ELEMENT_NAME.getLocalName())) {
            isRoot = true;
        }
        if (uri != null && uri.equals(StyleFooterLeftElement.ELEMENT_NAME.getUri()) && localName.equals("footer-first")) {
            isRoot = true;
        }
        return isRoot;
    }

    public static boolean isShapeElement(String uri, String localName) {
        boolean isShape = false;
        if (uri != null && localName != null) {
            if (uri.equals(DrawRectElement.ELEMENT_NAME.getUri()) && (localName.equals(DrawCaptionElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawCircleElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawControlElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawCustomShapeElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawEllipseElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawGElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawPageThumbnailElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawPathElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawPolylineElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawPolygonElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawRectElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawRegularPolygonElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawLineElement.ELEMENT_NAME.getLocalName()) || localName.equals(DrawConnectorElement.ELEMENT_NAME.getLocalName()))) {
                isShape = true;
            }
            if (uri.equals(Dr3dSceneElement.ELEMENT_NAME.getUri()) && localName.equals(Dr3dSceneElement.ELEMENT_NAME.getLocalName())) {
                isShape = true;
            }
        }
        return isShape;
    }

    public static boolean isWhiteSpaceElement(String uri, String localName) {
        boolean isWhiteSpace = false;
        if (uri.equals(TextSElement.ELEMENT_NAME.getUri()) && localName.equals(TextSElement.ELEMENT_NAME.getLocalName())) {
            isWhiteSpace = true;
        }
        return isWhiteSpace;
    }

    public static boolean isCoveredComponentRoot(String uri, String localName) {
        boolean isComponent = false;
        if (uri.equals(TableTableElement.ELEMENT_NAME.getUri()) && localName.equals(TableCoveredTableCellElement.ELEMENT_NAME.getLocalName())) {
            isComponent = true;
        }
        return isComponent;
    }

    public static boolean isTextSelection(Node textSelection) {
        boolean isTextElement = false;
        if (textSelection instanceof TextSpanElement || textSelection instanceof TextAElement) {
            isTextElement = true;
        }
        return isTextElement;
    }

    public Component(OdfElement componentElement) {
        this.mRootElement = componentElement;
        componentElement.setComponent(this);
    }

    protected Component(OdfElement componentElement, Component parent) {
        this.mRootElement = componentElement;
        componentElement.setComponent(this);
        this.mParent = parent;
    }

    public Component getParent() {
        return this.mParent;
    }

    public static OdfElement getCorrectStartElementOfChild(OdfElement parentElement, OdfElement existingChildElement) {
        OdfElement existingParentElement = (OdfElement)((Object)existingChildElement.getParentNode());
        if ((existingParentElement instanceof TextListItemElement || existingParentElement instanceof TextListHeaderElement) && existingChildElement instanceof TextParagraphElementBase) {
            TextParagraphElementBase existingParagraph = (TextParagraphElementBase)existingChildElement;
            JsonOperationConsumer.isolateListParagraph(existingParagraph);
            OdfElement potentialParent = (OdfElement)((Object)existingParagraph.getParentNode());
            while (potentialParent != null && !parentElement.equals((Object)potentialParent) && !parentElement.equals((Object)(potentialParent = (OdfElement)((Object)potentialParent.getParentNode())))) {
                existingChildElement = potentialParent;
            }
        }
        return existingChildElement;
    }

    public Component getLastChild() {
        Component lastChild = null;
        if (this.mChildren != null) {
            lastChild = this.mChildren.get(this.mChildren.size());
        }
        return lastChild;
    }

    public Document getOwnerDocument() {
        return this.mRootElement.getOwnerDocument();
    }

    public Node getChildNode(int position) {
        OdfElement rootElement = null;
        Component c = null;
        if (this.mChildren != null && this.mChildren.size() > position) {
            c = this.mChildren.get(position);
        }
        if (c != null) {
            rootElement = c.getRootElement();
        }
        return rootElement;
    }

    public Component get(JSONArray position) {
        return this.get(position, false, false, 0);
    }

    protected Component get(JSONArray position, boolean needParent, boolean needFollowingSibling, int depth) {
        Component c;
        block13: {
            c = null;
            int maxDepth = position.length() - 1;
            if (!needParent && maxDepth > depth || needParent && maxDepth - 1 != depth) {
                try {
                    Node startNode = this.getChildNode(position.getInt(depth));
                    if (startNode instanceof OdfElement) {
                        c = ((OdfElement)((Object)startNode)).getComponent();
                    }
                    if (c != null) {
                        c = c.get(position, needParent, needFollowingSibling, depth + 1);
                        break block13;
                    }
                    LOG.fine("Component yet missing!");
                }
                catch (JSONException ex) {
                    Logger.getLogger(Component.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                try {
                    if (needFollowingSibling) {
                        Node startNode = this.getChildNode(position.getInt(depth) + 1);
                        if (startNode instanceof OdfElement) {
                            c = ((OdfElement)((Object)startNode)).getComponent();
                        }
                    } else {
                        Node startNode = this.getChildNode(position.getInt(depth));
                        if (startNode instanceof OdfElement) {
                            c = ((OdfElement)((Object)startNode)).getComponent();
                            Component parent = c.getParent();
                            parent.getPosition(c);
                        }
                    }
                    if (c == null) {
                        LOG.fine("Component yet missing!");
                    }
                }
                catch (JSONException ex) {
                    Logger.getLogger(Component.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return c;
    }

    public Component getNextSiblingOf(JSONArray position) {
        return this.get(position, false, true, 0);
    }

    public Component getParentOf(JSONArray position) {
        Component c = null;
        c = position.length() == 1 ? this.getRootComponent() : this.get(position, true, false, 0);
        return c;
    }

    public Component getRootComponent() {
        if (this.mRootComponent == null) {
            for (Component parent = this; parent != null; parent = parent.getParent()) {
                this.mRootComponent = parent;
            }
        }
        return this.mRootComponent;
    }

    public List<Component> getChildren() {
        return this.mChildren;
    }

    public OdfElement getRootElement() {
        return this.mRootElement;
    }

    void setRootElement(OdfElement odfElement) {
        this.mRootElement = odfElement;
    }

    public Component createChildComponent(OdfElement componentRoot) {
        componentRoot.markAsComponentRoot(true);
        return Component.createChildComponent(-1, this, componentRoot);
    }

    public static Component createChildComponent(int position, Component parentComponent, OdfElement newChildElement) {
        Component c = Component.createComponent(parentComponent, newChildElement);
        if (!(parentComponent instanceof Table || parentComponent instanceof Row || parentComponent instanceof Cell || parentComponent instanceof TextContainer)) {
            Component.addComponent(position, parentComponent, c);
        }
        LOG.log(Level.FINEST, "***\n***  New Component: {0}\n*** {1}\n***", new Object[]{parentComponent.getPosition(c), newChildElement.toString()});
        return c;
    }

    public static Component createComponent(Component parentComponent, OdfElement newChildElement) {
        newChildElement.markAsComponentRoot(true);
        Component c = newChildElement instanceof TableTableElement ? new Table(newChildElement, parentComponent) : (newChildElement instanceof TableTableRowElement ? new Row(newChildElement, parentComponent) : (newChildElement instanceof TableTableCellElement || newChildElement instanceof TableCoveredTableCellElement ? new Cell(newChildElement, parentComponent) : (Component.isTextComponentRoot((Node)((Object)newChildElement)) ? new TextContainer(newChildElement, parentComponent) : (newChildElement instanceof OfficeAnnotationElement ? new Annotation(newChildElement, parentComponent) : new Component(newChildElement, parentComponent)))));
        newChildElement.setComponent(c);
        return c;
    }

    static void addComponent(int pos, Component parent, Component child) {
        parent.addChild(pos, child);
    }

    public void addChild(int index, Component c) {
        if (this.mChildren == null && this.mChildren == null) {
            this.mChildren = new LinkedList<Component>();
        }
        if (index >= 0) {
            this.mChildren.add(index, c);
        } else {
            this.mChildren.add(c);
        }
    }

    public Node remove(int position) {
        Component c;
        OdfElement n = null;
        if (this.mChildren != null && (c = this.mChildren.remove(position)) != null) {
            n = c.getRootElement();
        }
        return n;
    }

    public int size() {
        int size = 0;
        if (this.mChildren != null) {
            size = this.mChildren.size();
        }
        return size;
    }

    public void hasRepeated(boolean hasRepeated) {
        this.mHasRepeated = hasRepeated;
    }

    public boolean hasRepeated() {
        return this.mHasRepeated;
    }

    protected String getPosition(Component c) {
        String s;
        if (c.mParent != null) {
            Component parent;
            LinkedList<Integer> position = new LinkedList<Integer>();
            while ((parent = c.getParent()) != null) {
                int childPos = parent.indexOf(c);
                position.add(childPos);
                c = parent;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = position.size() - 1; i >= 0; --i) {
                sb.append("/").append(position.get(i));
            }
            s = sb.toString();
        } else {
            s = "/";
        }
        return s;
    }

    protected static String getPositionString(Component c) {
        String s;
        if (c.mParent != null) {
            Component parent;
            LinkedList<Integer> position = new LinkedList<Integer>();
            while ((parent = c.getParent()) != null) {
                int childPos = parent.indexOf(c);
                position.add(childPos);
                c = parent;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = position.size() - 1; i >= 0; --i) {
                sb.append("/").append(position.get(i));
            }
            s = sb.toString();
        } else {
            s = "/";
        }
        return s;
    }

    public int indexOf(Object o) {
        int position = -1;
        if (this.mChildren != null) {
            position = this.mChildren.indexOf(o);
        } else {
            Object targetNode = null;
            OdfElement parentNode = null;
            if (o instanceof Component) {
                Component c = (Component)o;
                targetNode = c.getRootElement();
                parentNode = c.getParent().getRootElement();
            } else if (o instanceof Node) {
                targetNode = (Node)o;
                parentNode = (OdfElement)((Object)targetNode.getParentNode());
            }
            if (targetNode != null && targetNode instanceof OdfElement && parentNode != null && parentNode.equals((Object)this.mRootElement)) {
                position = this.findPosition((Element)((Object)parentNode), (OdfElement)((Object)targetNode));
            }
        }
        return position;
    }

    private Integer findPosition(Element parentComponentElement, OdfElement targetNode) {
        int pos = -1;
        if (parentComponentElement != null && targetNode != null && targetNode.hasAncestor(parentComponentElement)) {
            this.findChild(0, parentComponentElement, (Node)((Object)targetNode));
        }
        return pos;
    }

    private Integer findChild(Integer pos, Element parentComponentElement, Node child) {
        if (child != null) {
            if (child instanceof OdfElement) {
                OdfElement childElement = (OdfElement)((Object)child);
                if (childElement.isComponentRoot()) {
                    pos = pos + childElement.getRepetition();
                    pos = this.findChild(pos, parentComponentElement, childElement.getPreviousSibling());
                } else {
                    pos = Component.isComponentWrapper((Element)((Object)childElement)) ? this.findChild(pos, parentComponentElement, (Node)((Object)childElement.getLastChildElement())) : this.findChild(pos, parentComponentElement, childElement.getPreviousSibling());
                }
            } else {
                pos = this.findChild(pos, parentComponentElement, child.getPreviousSibling());
            }
        }
        return pos;
    }

    public String toString() {
        String s = "POS:" + this.getPosition(this);
        s = this.mRootElement != null ? s + this.mRootElement.getPrefix() + ":" + this.mRootElement.getLocalName() : s + "NO ROOT ELEMENT!!!";
        return s;
    }

    public static Map<String, OdfStylePropertiesSet> getAllStyleGroupingIdProperties(OdfStylableElement styleElement) {
        return Component.getAllStyleGroupingIdProperties(styleElement.getStyleFamily());
    }

    public static Map<String, OdfStylePropertiesSet> getAllStyleGroupingIdProperties(OdfStyleFamily styleFamily) {
        HashMap<String, OdfStylePropertiesSet> familyProperties = new HashMap<String, OdfStylePropertiesSet>();
        if (styleFamily.equals(OdfStyleFamily.Paragraph)) {
            familyProperties.put("paragraph", OdfStylePropertiesSet.ParagraphProperties);
            familyProperties.put("character", OdfStylePropertiesSet.TextProperties);
        } else if (styleFamily.equals(OdfStyleFamily.Text)) {
            familyProperties.put("character", OdfStylePropertiesSet.TextProperties);
        } else if (styleFamily.equals(OdfStyleFamily.Table)) {
            familyProperties.put("table", OdfStylePropertiesSet.TableProperties);
        } else if (styleFamily.equals(OdfStyleFamily.TableRow)) {
            familyProperties.put("row", OdfStylePropertiesSet.TableRowProperties);
        } else if (styleFamily.equals(OdfStyleFamily.TableCell)) {
            familyProperties.put("cell", OdfStylePropertiesSet.TableCellProperties);
            familyProperties.put("paragraph", OdfStylePropertiesSet.ParagraphProperties);
            familyProperties.put("character", OdfStylePropertiesSet.TextProperties);
        } else if (styleFamily.equals(OdfStyleFamily.TableColumn)) {
            familyProperties.put("column", OdfStylePropertiesSet.TableColumnProperties);
        } else if (styleFamily.equals(OdfStyleFamily.Section)) {
            familyProperties.put("section", OdfStylePropertiesSet.SectionProperties);
        } else if (styleFamily.equals(OdfStyleFamily.List)) {
            familyProperties.put("list", OdfStylePropertiesSet.ListLevelProperties);
        } else if (styleFamily.equals(OdfStyleFamily.Chart)) {
            familyProperties.put("chart", OdfStylePropertiesSet.ChartProperties);
            familyProperties.put("drawing", OdfStylePropertiesSet.GraphicProperties);
            familyProperties.put("paragraph", OdfStylePropertiesSet.ParagraphProperties);
            familyProperties.put("character", OdfStylePropertiesSet.TextProperties);
        } else if (styleFamily.equals(OdfStyleFamily.Graphic) || styleFamily.equals(OdfStyleFamily.Presentation)) {
            familyProperties.put("drawing", OdfStylePropertiesSet.GraphicProperties);
            familyProperties.put("paragraph", OdfStylePropertiesSet.ParagraphProperties);
            familyProperties.put("character", OdfStylePropertiesSet.TextProperties);
        } else if (styleFamily.equals(OdfStyleFamily.DrawingPage)) {
            familyProperties.put("drawing", OdfStylePropertiesSet.DrawingPageProperties);
        } else if (styleFamily.equals(OdfStyleFamily.Ruby)) {
            familyProperties.put("ruby", OdfStylePropertiesSet.RubyProperties);
        }
        return familyProperties;
    }

    public static String getFamilyID(OdfStylableElement styleElement) {
        return Component.getFamilyID(styleElement.getStyleFamily());
    }

    public static String getMainStyleGroupingId(OdfStylableElement styleElement) {
        return Component.getMainStyleGroupingId(styleElement.getStyleFamily());
    }

    public static String getStyleNamePrefix(OdfStylableElement styleElement) {
        return Component.getStyleNamePrefix(styleElement.getStyleFamily());
    }

    public static String getMainStyleGroupingId(OdfStyleFamily styleFamily) {
        String familyID = null;
        if (styleFamily.equals(OdfStyleFamily.Paragraph)) {
            familyID = "paragraph";
        } else if (styleFamily.equals(OdfStyleFamily.Text)) {
            familyID = "character";
        } else if (styleFamily.equals(OdfStyleFamily.Table)) {
            familyID = "table";
        } else if (styleFamily.equals(OdfStyleFamily.TableRow)) {
            familyID = "row";
        } else if (styleFamily.equals(OdfStyleFamily.TableCell)) {
            familyID = "cell";
        } else if (styleFamily.equals(OdfStyleFamily.TableColumn)) {
            familyID = "column";
        } else if (styleFamily.equals(OdfStyleFamily.Section)) {
            familyID = "section";
        } else if (styleFamily.equals(OdfStyleFamily.List)) {
            familyID = "list";
        } else if (styleFamily.equals(OdfStyleFamily.Chart)) {
            familyID = "chart";
        } else if (styleFamily.equals(OdfStyleFamily.Graphic) || styleFamily.equals(OdfStyleFamily.Presentation)) {
            familyID = "drawing";
        } else if (styleFamily.equals(OdfStyleFamily.DrawingPage)) {
            familyID = "drawing";
        } else if (styleFamily.equals(OdfStyleFamily.Ruby)) {
            familyID = "ruby";
        }
        return familyID;
    }

    public static String getStyleNamePrefix(OdfStyleFamily styleFamily) {
        String familyID = null;
        if (styleFamily.equals(OdfStyleFamily.Paragraph) || styleFamily.equals(OdfStyleFamily.Text) || styleFamily.equals(OdfStyleFamily.Section) || styleFamily.equals(OdfStyleFamily.List) || styleFamily.equals(OdfStyleFamily.Ruby)) {
            familyID = "text";
        } else if (styleFamily.equals(OdfStyleFamily.Table) || styleFamily.equals(OdfStyleFamily.TableRow) || styleFamily.equals(OdfStyleFamily.TableCell) || styleFamily.equals(OdfStyleFamily.TableColumn)) {
            familyID = "table";
        } else if (styleFamily.equals(OdfStyleFamily.Chart)) {
            familyID = "chart";
        } else if (styleFamily.equals(OdfStyleFamily.Graphic) || styleFamily.equals(OdfStyleFamily.Presentation) || styleFamily.equals(OdfStyleFamily.DrawingPage)) {
            familyID = "draw";
        } else if (styleFamily.equals(OdfStyleFamily.Presentation)) {
            familyID = "presentation";
        }
        return familyID;
    }

    public static String getFamilyID(OdfStyleFamily styleFamily) {
        String familyID = null;
        if (styleFamily.equals(OdfStyleFamily.Paragraph)) {
            familyID = "paragraph";
        } else if (styleFamily.equals(OdfStyleFamily.Text)) {
            familyID = "character";
        } else if (styleFamily.equals(OdfStyleFamily.Table)) {
            familyID = "table";
        } else if (styleFamily.equals(OdfStyleFamily.TableRow)) {
            familyID = "row";
        } else if (styleFamily.equals(OdfStyleFamily.TableCell)) {
            familyID = "cell";
        } else if (styleFamily.equals(OdfStyleFamily.TableColumn)) {
            familyID = "column";
        } else if (styleFamily.equals(OdfStyleFamily.Section)) {
            familyID = "section";
        } else if (styleFamily.equals(OdfStyleFamily.List)) {
            familyID = "list";
        } else if (styleFamily.equals(OdfStyleFamily.Chart)) {
            familyID = "chart";
        } else if (styleFamily.equals(OdfStyleFamily.Graphic) || styleFamily.equals(OdfStyleFamily.Presentation)) {
            familyID = "drawing";
        } else if (styleFamily.equals(OdfStyleFamily.DrawingPage)) {
            familyID = "drawing";
        } else if (styleFamily.equals(OdfStyleFamily.Ruby)) {
            familyID = "ruby";
        }
        return familyID;
    }

    public static String getFamilyDisplayName(OdfStyleFamily styleFamily) {
        String familyID = null;
        if (styleFamily.equals(OdfStyleFamily.Paragraph)) {
            familyID = "Paragraph";
        } else if (styleFamily.equals(OdfStyleFamily.Text)) {
            familyID = "Character";
        } else if (styleFamily.equals(OdfStyleFamily.Table)) {
            familyID = "Table";
        } else if (styleFamily.equals(OdfStyleFamily.TableRow)) {
            familyID = "Row";
        } else if (styleFamily.equals(OdfStyleFamily.TableCell)) {
            familyID = "Cell";
        } else if (styleFamily.equals(OdfStyleFamily.TableColumn)) {
            familyID = "Column";
        } else if (styleFamily.equals(OdfStyleFamily.Section)) {
            familyID = "Section";
        } else if (styleFamily.equals(OdfStyleFamily.List)) {
            familyID = "List";
        } else if (styleFamily.equals(OdfStyleFamily.Presentation)) {
            familyID = "Presentation";
        } else if (styleFamily.equals(OdfStyleFamily.Chart)) {
            familyID = "Chart";
        } else if (styleFamily.equals(OdfStyleFamily.Graphic)) {
            familyID = "Graphic";
        } else if (styleFamily.equals(OdfStyleFamily.DrawingPage)) {
            familyID = "Drawing";
        } else if (styleFamily.equals(OdfStyleFamily.Ruby)) {
            familyID = "Ruby";
        }
        return familyID;
    }

    public static String getFamilyName(String styleId) {
        String familyID = null;
        if (styleId.equals("paragraph")) {
            familyID = OdfStyleFamily.Paragraph.getName();
        } else if (styleId.equals("character")) {
            familyID = OdfStyleFamily.Text.getName();
        } else if (styleId.equals("table")) {
            familyID = OdfStyleFamily.Table.getName();
        } else if (styleId.equals("row")) {
            familyID = OdfStyleFamily.TableRow.getName();
        } else if (styleId.equals("cell")) {
            familyID = OdfStyleFamily.TableCell.getName();
        } else if (styleId.equals("column")) {
            familyID = OdfStyleFamily.TableColumn.getName();
        } else if (styleId.equals("graphic")) {
            familyID = OdfStyleFamily.Graphic.getName();
        }
        return familyID;
    }

    public static OdfStyleFamily getFamily(String styleId) {
        OdfStyleFamily family = null;
        if (styleId.equals("paragraph")) {
            family = OdfStyleFamily.Paragraph;
        } else if (styleId.equals("character")) {
            family = OdfStyleFamily.Text;
        } else if (styleId.equals("table")) {
            family = OdfStyleFamily.Table;
        } else if (styleId.equals("row")) {
            family = OdfStyleFamily.TableRow;
        } else if (styleId.equals("cell")) {
            family = OdfStyleFamily.TableCell;
        } else if (styleId.equals("column")) {
            family = OdfStyleFamily.TableColumn;
        } else if (styleId.equals("drawing")) {
            family = OdfStyleFamily.Graphic;
        }
        return family;
    }

    public int repetition() {
        return 1;
    }
}

