/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.table;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.table.TableNumberColumnsSpannedAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableNumberMatrixColumnsSpannedAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableNumberMatrixRowsSpannedAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableNumberRowsSpannedAttribute;
import org.odftoolkit.odfdom.dom.element.dr3d.Dr3dSceneElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawAElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCaptionElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCircleElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawConnectorElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawControlElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCustomShapeElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawEllipseElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawGElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawLineElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawMeasureElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageThumbnailElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPathElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPolylineElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawRectElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawRegularPolygonElement;
import org.odftoolkit.odfdom.dom.element.number.DataStyleElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.text.TextAlphabeticalIndexElement;
import org.odftoolkit.odfdom.dom.element.text.TextBibliographyElement;
import org.odftoolkit.odfdom.dom.element.text.TextChangeElement;
import org.odftoolkit.odfdom.dom.element.text.TextChangeEndElement;
import org.odftoolkit.odfdom.dom.element.text.TextChangeStartElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextIllustrationIndexElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextNumberedParagraphElement;
import org.odftoolkit.odfdom.dom.element.text.TextObjectIndexElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSectionElement;
import org.odftoolkit.odfdom.dom.element.text.TextSoftPageBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextTableIndexElement;
import org.odftoolkit.odfdom.dom.element.text.TextTableOfContentElement;
import org.odftoolkit.odfdom.dom.element.text.TextUserIndexElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/**
 * DOM implementation of OpenDocument element  {@odf.element table:table-cell}.
 *
 */
public class TableTableCellElement extends TableTableCellElementBase {

	public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TABLE, "table-cell");

	/**
	 * Create the instance of <code>TableTableCellElement</code>
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TableTableCellElement(OdfFileDom ownerDoc) {
		super(ownerDoc, ELEMENT_NAME, OdfStyleFamily.TableCell, OdfName.newName(OdfDocumentNamespace.TABLE, "style-name"));
	}

	/**
	 * Get the element name
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element table:table-cell}.
	 */
	@Override
    public OdfName getOdfName() {
		return ELEMENT_NAME;
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableNumberColumnsSpannedAttribute</code> , See {@odf.attribute table:number-columns-spanned}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableNumberColumnsSpannedAttribute() {
		TableNumberColumnsSpannedAttribute attr = (TableNumberColumnsSpannedAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "number-columns-spanned");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return Integer.valueOf(TableNumberColumnsSpannedAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableNumberColumnsSpannedAttribute</code> , See {@odf.attribute table:number-columns-spanned}
	 *
	 * @param tableNumberColumnsSpannedValue   The type is <code>Integer</code>
	 */
	public void setTableNumberColumnsSpannedAttribute(Integer tableNumberColumnsSpannedValue) {
		TableNumberColumnsSpannedAttribute attr = new TableNumberColumnsSpannedAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(tableNumberColumnsSpannedValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableNumberMatrixColumnsSpannedAttribute</code> , See {@odf.attribute table:number-matrix-columns-spanned}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableNumberMatrixColumnsSpannedAttribute() {
		TableNumberMatrixColumnsSpannedAttribute attr = (TableNumberMatrixColumnsSpannedAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "number-matrix-columns-spanned");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableNumberMatrixColumnsSpannedAttribute</code> , See {@odf.attribute table:number-matrix-columns-spanned}
	 *
	 * @param tableNumberMatrixColumnsSpannedValue   The type is <code>Integer</code>
	 */
	public void setTableNumberMatrixColumnsSpannedAttribute(Integer tableNumberMatrixColumnsSpannedValue) {
		TableNumberMatrixColumnsSpannedAttribute attr = new TableNumberMatrixColumnsSpannedAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(tableNumberMatrixColumnsSpannedValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableNumberMatrixRowsSpannedAttribute</code> , See {@odf.attribute table:number-matrix-rows-spanned}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableNumberMatrixRowsSpannedAttribute() {
		TableNumberMatrixRowsSpannedAttribute attr = (TableNumberMatrixRowsSpannedAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "number-matrix-rows-spanned");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableNumberMatrixRowsSpannedAttribute</code> , See {@odf.attribute table:number-matrix-rows-spanned}
	 *
	 * @param tableNumberMatrixRowsSpannedValue   The type is <code>Integer</code>
	 */
	public void setTableNumberMatrixRowsSpannedAttribute(Integer tableNumberMatrixRowsSpannedValue) {
		TableNumberMatrixRowsSpannedAttribute attr = new TableNumberMatrixRowsSpannedAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(tableNumberMatrixRowsSpannedValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableNumberRowsSpannedAttribute</code> , See {@odf.attribute table:number-rows-spanned}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableNumberRowsSpannedAttribute() {
		TableNumberRowsSpannedAttribute attr = (TableNumberRowsSpannedAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "number-rows-spanned");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return Integer.valueOf(TableNumberRowsSpannedAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableNumberRowsSpannedAttribute</code> , See {@odf.attribute table:number-rows-spanned}
	 *
	 * @param tableNumberRowsSpannedValue   The type is <code>Integer</code>
	 */
	public void setTableNumberRowsSpannedAttribute(Integer tableNumberRowsSpannedValue) {
		TableNumberRowsSpannedAttribute attr = new TableNumberRowsSpannedAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(tableNumberRowsSpannedValue.intValue());
	}

	/**
	 * Create child element {@odf.element dr3d:scene}.
	 *
	 * @return the element {@odf.element dr3d:scene}
	 */
	public Dr3dSceneElement newDr3dSceneElement() {
		Dr3dSceneElement dr3dScene = ((OdfFileDom) this.ownerDocument).newOdfElement(Dr3dSceneElement.class);
		this.appendChild(dr3dScene);
		return dr3dScene;
	}

	/**
	 * Create child element {@odf.element draw:a}.
	 *
	 * @param xlinkHrefValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * @param xlinkTypeValue  the <code>String</code> value of <code>XlinkTypeAttribute</code>, see {@odf.attribute  xlink:type} at specification
	 * @return the element {@odf.element draw:a}
	 */
	 public DrawAElement newDrawAElement(String xlinkHrefValue, String xlinkTypeValue) {
		DrawAElement drawA = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawAElement.class);
		drawA.setXlinkHrefAttribute(xlinkHrefValue);
		drawA.setXlinkTypeAttribute(xlinkTypeValue);
		this.appendChild(drawA);
		return drawA;
	}

	/**
	 * Create child element {@odf.element draw:caption}.
	 *
	 * @return the element {@odf.element draw:caption}
	 */
	public DrawCaptionElement newDrawCaptionElement() {
		DrawCaptionElement drawCaption = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawCaptionElement.class);
		this.appendChild(drawCaption);
		return drawCaption;
	}

	/**
	 * Create child element {@odf.element draw:circle}.
	 *
	 * @return the element {@odf.element draw:circle}
	 */
	public DrawCircleElement newDrawCircleElement() {
		DrawCircleElement drawCircle = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawCircleElement.class);
		this.appendChild(drawCircle);
		return drawCircle;
	}

	/**
	 * Create child element {@odf.element draw:connector}.
	 *
	 * @param svgViewBoxValue  the <code>Integer</code> value of <code>SvgViewBoxAttribute</code>, see {@odf.attribute  svg:viewBox} at specification
	 * @return the element {@odf.element draw:connector}
	 */
	 public DrawConnectorElement newDrawConnectorElement(int svgViewBoxValue) {
		DrawConnectorElement drawConnector = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawConnectorElement.class);
		drawConnector.setSvgViewBoxAttribute(svgViewBoxValue);
		this.appendChild(drawConnector);
		return drawConnector;
	}

	/**
	 * Create child element {@odf.element draw:control}.
	 *
	 * @param drawControlValue  the <code>String</code> value of <code>DrawControlAttribute</code>, see {@odf.attribute  draw:control} at specification
	 * @return the element {@odf.element draw:control}
	 */
	 public DrawControlElement newDrawControlElement(String drawControlValue) {
		DrawControlElement drawControl = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawControlElement.class);
		drawControl.setDrawControlAttribute(drawControlValue);
		this.appendChild(drawControl);
		return drawControl;
	}

	/**
	 * Create child element {@odf.element draw:custom-shape}.
	 *
	 * @return the element {@odf.element draw:custom-shape}
	 */
	public DrawCustomShapeElement newDrawCustomShapeElement() {
		DrawCustomShapeElement drawCustomShape = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawCustomShapeElement.class);
		this.appendChild(drawCustomShape);
		return drawCustomShape;
	}

	/**
	 * Create child element {@odf.element draw:ellipse}.
	 *
	 * @return the element {@odf.element draw:ellipse}
	 */
	public DrawEllipseElement newDrawEllipseElement() {
		DrawEllipseElement drawEllipse = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawEllipseElement.class);
		this.appendChild(drawEllipse);
		return drawEllipse;
	}

	/**
	 * Create child element {@odf.element draw:frame}.
	 *
	 * @return the element {@odf.element draw:frame}
	 */
	public DrawFrameElement newDrawFrameElement() {
		DrawFrameElement drawFrame = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawFrameElement.class);
		this.appendChild(drawFrame);
		return drawFrame;
	}

	/**
	 * Create child element {@odf.element draw:g}.
	 *
	 * @return the element {@odf.element draw:g}
	 */
	public DrawGElement newDrawGElement() {
		DrawGElement drawG = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawGElement.class);
		this.appendChild(drawG);
		return drawG;
	}

	/**
	 * Create child element {@odf.element draw:line}.
	 *
	 * @param svgX1Value  the <code>String</code> value of <code>SvgX1Attribute</code>, see {@odf.attribute  svg:x1} at specification
	 * @param svgX2Value  the <code>String</code> value of <code>SvgX2Attribute</code>, see {@odf.attribute  svg:x2} at specification
	 * @param svgY1Value  the <code>String</code> value of <code>SvgY1Attribute</code>, see {@odf.attribute  svg:y1} at specification
	 * @param svgY2Value  the <code>String</code> value of <code>SvgY2Attribute</code>, see {@odf.attribute  svg:y2} at specification
	 * @return the element {@odf.element draw:line}
	 */
	 public DrawLineElement newDrawLineElement(String svgX1Value, String svgX2Value, String svgY1Value, String svgY2Value) {
		DrawLineElement drawLine = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawLineElement.class);
		drawLine.setSvgX1Attribute(svgX1Value);
		drawLine.setSvgX2Attribute(svgX2Value);
		drawLine.setSvgY1Attribute(svgY1Value);
		drawLine.setSvgY2Attribute(svgY2Value);
		this.appendChild(drawLine);
		return drawLine;
	}

	/**
	 * Create child element {@odf.element draw:measure}.
	 *
	 * @param svgX1Value  the <code>String</code> value of <code>SvgX1Attribute</code>, see {@odf.attribute  svg:x1} at specification
	 * @param svgX2Value  the <code>String</code> value of <code>SvgX2Attribute</code>, see {@odf.attribute  svg:x2} at specification
	 * @param svgY1Value  the <code>String</code> value of <code>SvgY1Attribute</code>, see {@odf.attribute  svg:y1} at specification
	 * @param svgY2Value  the <code>String</code> value of <code>SvgY2Attribute</code>, see {@odf.attribute  svg:y2} at specification
	 * @return the element {@odf.element draw:measure}
	 */
	 public DrawMeasureElement newDrawMeasureElement(String svgX1Value, String svgX2Value, String svgY1Value, String svgY2Value) {
		DrawMeasureElement drawMeasure = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawMeasureElement.class);
		drawMeasure.setSvgX1Attribute(svgX1Value);
		drawMeasure.setSvgX2Attribute(svgX2Value);
		drawMeasure.setSvgY1Attribute(svgY1Value);
		drawMeasure.setSvgY2Attribute(svgY2Value);
		this.appendChild(drawMeasure);
		return drawMeasure;
	}

	/**
	 * Create child element {@odf.element draw:page-thumbnail}.
	 *
	 * @return the element {@odf.element draw:page-thumbnail}
	 */
	public DrawPageThumbnailElement newDrawPageThumbnailElement() {
		DrawPageThumbnailElement drawPageThumbnail = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawPageThumbnailElement.class);
		this.appendChild(drawPageThumbnail);
		return drawPageThumbnail;
	}

	/**
	 * Create child element {@odf.element draw:path}.
	 *
	 * @param svgDValue  the <code>String</code> value of <code>SvgDAttribute</code>, see {@odf.attribute  svg:d} at specification
	 * @param svgViewBoxValue  the <code>Integer</code> value of <code>SvgViewBoxAttribute</code>, see {@odf.attribute  svg:viewBox} at specification
	 * @return the element {@odf.element draw:path}
	 */
	 public DrawPathElement newDrawPathElement(String svgDValue, int svgViewBoxValue) {
		DrawPathElement drawPath = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawPathElement.class);
		drawPath.setSvgDAttribute(svgDValue);
		drawPath.setSvgViewBoxAttribute(svgViewBoxValue);
		this.appendChild(drawPath);
		return drawPath;
	}

	/**
	 * Create child element {@odf.element draw:polygon}.
	 *
	 * @param drawPointsValue  the <code>String</code> value of <code>DrawPointsAttribute</code>, see {@odf.attribute  draw:points} at specification
	 * @param svgViewBoxValue  the <code>Integer</code> value of <code>SvgViewBoxAttribute</code>, see {@odf.attribute  svg:viewBox} at specification
	 * @return the element {@odf.element draw:polygon}
	 */
	 public DrawPolygonElement newDrawPolygonElement(String drawPointsValue, int svgViewBoxValue) {
		DrawPolygonElement drawPolygon = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawPolygonElement.class);
		drawPolygon.setDrawPointsAttribute(drawPointsValue);
		drawPolygon.setSvgViewBoxAttribute(svgViewBoxValue);
		this.appendChild(drawPolygon);
		return drawPolygon;
	}

	/**
	 * Create child element {@odf.element draw:polyline}.
	 *
	 * @param drawPointsValue  the <code>String</code> value of <code>DrawPointsAttribute</code>, see {@odf.attribute  draw:points} at specification
	 * @param svgViewBoxValue  the <code>Integer</code> value of <code>SvgViewBoxAttribute</code>, see {@odf.attribute  svg:viewBox} at specification
	 * @return the element {@odf.element draw:polyline}
	 */
	 public DrawPolylineElement newDrawPolylineElement(String drawPointsValue, int svgViewBoxValue) {
		DrawPolylineElement drawPolyline = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawPolylineElement.class);
		drawPolyline.setDrawPointsAttribute(drawPointsValue);
		drawPolyline.setSvgViewBoxAttribute(svgViewBoxValue);
		this.appendChild(drawPolyline);
		return drawPolyline;
	}

	/**
	 * Create child element {@odf.element draw:rect}.
	 *
	 * @return the element {@odf.element draw:rect}
	 */
	public DrawRectElement newDrawRectElement() {
		DrawRectElement drawRect = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawRectElement.class);
		this.appendChild(drawRect);
		return drawRect;
	}

	/**
	 * Create child element {@odf.element draw:regular-polygon}.
	 *
	 * @param drawConcaveValue  the <code>Boolean</code> value of <code>DrawConcaveAttribute</code>, see {@odf.attribute  draw:concave} at specification
	 * @param drawCornersValue  the <code>Integer</code> value of <code>DrawCornersAttribute</code>, see {@odf.attribute  draw:corners} at specification
	 * @return the element {@odf.element draw:regular-polygon}
	 */
	 public DrawRegularPolygonElement newDrawRegularPolygonElement(boolean drawConcaveValue, int drawCornersValue) {
		DrawRegularPolygonElement drawRegularPolygon = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawRegularPolygonElement.class);
		drawRegularPolygon.setDrawConcaveAttribute(drawConcaveValue);
		drawRegularPolygon.setDrawCornersAttribute(drawCornersValue);
		this.appendChild(drawRegularPolygon);
		return drawRegularPolygon;
	}

	/**
	 * Create child element {@odf.element office:annotation}.
	 *
	 * @return the element {@odf.element office:annotation}
	 */
	public OfficeAnnotationElement newOfficeAnnotationElement() {
		OfficeAnnotationElement officeAnnotation = ((OdfFileDom) this.ownerDocument).newOdfElement(OfficeAnnotationElement.class);
		this.appendChild(officeAnnotation);
		return officeAnnotation;
	}

	/**
	 * Create child element {@odf.element table:cell-range-source}.
	 *
	 * @param tableLastColumnSpannedValue  the <code>Integer</code> value of <code>TableLastColumnSpannedAttribute</code>, see {@odf.attribute  table:last-column-spanned} at specification
	 * @param tableLastRowSpannedValue  the <code>Integer</code> value of <code>TableLastRowSpannedAttribute</code>, see {@odf.attribute  table:last-row-spanned} at specification
	 * @param tableNameValue  the <code>String</code> value of <code>TableNameAttribute</code>, see {@odf.attribute  table:name} at specification
	 * @param xlinkHrefValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * @param xlinkTypeValue  the <code>String</code> value of <code>XlinkTypeAttribute</code>, see {@odf.attribute  xlink:type} at specification
	 * @return the element {@odf.element table:cell-range-source}
	 */
	 public TableCellRangeSourceElement newTableCellRangeSourceElement(int tableLastColumnSpannedValue, int tableLastRowSpannedValue, String tableNameValue, String xlinkHrefValue, String xlinkTypeValue) {
		TableCellRangeSourceElement tableCellRangeSource = ((OdfFileDom) this.ownerDocument).newOdfElement(TableCellRangeSourceElement.class);
		tableCellRangeSource.setTableLastColumnSpannedAttribute(tableLastColumnSpannedValue);
		tableCellRangeSource.setTableLastRowSpannedAttribute(tableLastRowSpannedValue);
		tableCellRangeSource.setTableNameAttribute(tableNameValue);
		tableCellRangeSource.setXlinkHrefAttribute(xlinkHrefValue);
		tableCellRangeSource.setXlinkTypeAttribute(xlinkTypeValue);
		this.appendChild(tableCellRangeSource);
		return tableCellRangeSource;
	}

	/**
	 * Create child element {@odf.element table:detective}.
	 *
	 * @return the element {@odf.element table:detective}
	 */
	public TableDetectiveElement newTableDetectiveElement() {
		TableDetectiveElement tableDetective = ((OdfFileDom) this.ownerDocument).newOdfElement(TableDetectiveElement.class);
		this.appendChild(tableDetective);
		return tableDetective;
	}

	/**
	 * Create child element {@odf.element table:table}.
	 *
	 * @return the element {@odf.element table:table}
	 */
	public TableTableElement newTableTableElement() {
		TableTableElement tableTable = ((OdfFileDom) this.ownerDocument).newOdfElement(TableTableElement.class);
		this.appendChild(tableTable);
		return tableTable;
	}

	/**
	 * Create child element {@odf.element text:alphabetical-index}.
	 *
	 * @param textNameValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return the element {@odf.element text:alphabetical-index}
	 */
	 public TextAlphabeticalIndexElement newTextAlphabeticalIndexElement(String textNameValue) {
		TextAlphabeticalIndexElement textAlphabeticalIndex = ((OdfFileDom) this.ownerDocument).newOdfElement(TextAlphabeticalIndexElement.class);
		textAlphabeticalIndex.setTextNameAttribute(textNameValue);
		this.appendChild(textAlphabeticalIndex);
		return textAlphabeticalIndex;
	}

	/**
	 * Create child element {@odf.element text:bibliography}.
	 *
	 * @param textNameValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return the element {@odf.element text:bibliography}
	 */
	 public TextBibliographyElement newTextBibliographyElement(String textNameValue) {
		TextBibliographyElement textBibliography = ((OdfFileDom) this.ownerDocument).newOdfElement(TextBibliographyElement.class);
		textBibliography.setTextNameAttribute(textNameValue);
		this.appendChild(textBibliography);
		return textBibliography;
	}

	/**
	 * Create child element {@odf.element text:change}.
	 *
	 * @param textChangeIdValue  the <code>String</code> value of <code>TextChangeIdAttribute</code>, see {@odf.attribute  text:change-id} at specification
	 * @return the element {@odf.element text:change}
	 */
	 public TextChangeElement newTextChangeElement(String textChangeIdValue) {
		TextChangeElement textChange = ((OdfFileDom) this.ownerDocument).newOdfElement(TextChangeElement.class);
		textChange.setTextChangeIdAttribute(textChangeIdValue);
		this.appendChild(textChange);
		return textChange;
	}

	/**
	 * Create child element {@odf.element text:change-end}.
	 *
	 * @param textChangeIdValue  the <code>String</code> value of <code>TextChangeIdAttribute</code>, see {@odf.attribute  text:change-id} at specification
	 * @return the element {@odf.element text:change-end}
	 */
	 public TextChangeEndElement newTextChangeEndElement(String textChangeIdValue) {
		TextChangeEndElement textChangeEnd = ((OdfFileDom) this.ownerDocument).newOdfElement(TextChangeEndElement.class);
		textChangeEnd.setTextChangeIdAttribute(textChangeIdValue);
		this.appendChild(textChangeEnd);
		return textChangeEnd;
	}

	/**
	 * Create child element {@odf.element text:change-start}.
	 *
	 * @param textChangeIdValue  the <code>String</code> value of <code>TextChangeIdAttribute</code>, see {@odf.attribute  text:change-id} at specification
	 * @return the element {@odf.element text:change-start}
	 */
	 public TextChangeStartElement newTextChangeStartElement(String textChangeIdValue) {
		TextChangeStartElement textChangeStart = ((OdfFileDom) this.ownerDocument).newOdfElement(TextChangeStartElement.class);
		textChangeStart.setTextChangeIdAttribute(textChangeIdValue);
		this.appendChild(textChangeStart);
		return textChangeStart;
	}

	/**
	 * Create child element {@odf.element text:h}.
	 *
	 * @param textOutlineLevelValue  the <code>Integer</code> value of <code>TextOutlineLevelAttribute</code>, see {@odf.attribute  text:outline-level} at specification
	 * @return the element {@odf.element text:h}
	 */
	 public TextHElement newTextHElement(int textOutlineLevelValue) {
		TextHElement textH = ((OdfFileDom) this.ownerDocument).newOdfElement(TextHElement.class);
		textH.setTextOutlineLevelAttribute(textOutlineLevelValue);
		this.appendChild(textH);
		return textH;
	}

	/**
	 * Create child element {@odf.element text:illustration-index}.
	 *
	 * @param textNameValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return the element {@odf.element text:illustration-index}
	 */
	 public TextIllustrationIndexElement newTextIllustrationIndexElement(String textNameValue) {
		TextIllustrationIndexElement textIllustrationIndex = ((OdfFileDom) this.ownerDocument).newOdfElement(TextIllustrationIndexElement.class);
		textIllustrationIndex.setTextNameAttribute(textNameValue);
		this.appendChild(textIllustrationIndex);
		return textIllustrationIndex;
	}

	/**
	 * Create child element {@odf.element text:list}.
	 *
	 * @return the element {@odf.element text:list}
	 */
	public TextListElement newTextListElement() {
		TextListElement textList = ((OdfFileDom) this.ownerDocument).newOdfElement(TextListElement.class);
		this.appendChild(textList);
		return textList;
	}

	/**
	 * Create child element {@odf.element text:numbered-paragraph}.
	 *
	 * @param textListIdValue  the <code>String</code> value of <code>TextListIdAttribute</code>, see {@odf.attribute  text:list-id} at specification
	 * @return the element {@odf.element text:numbered-paragraph}
	 */
	 public TextNumberedParagraphElement newTextNumberedParagraphElement(String textListIdValue) {
		TextNumberedParagraphElement textNumberedParagraph = ((OdfFileDom) this.ownerDocument).newOdfElement(TextNumberedParagraphElement.class);
		textNumberedParagraph.setTextListIdAttribute(textListIdValue);
		this.appendChild(textNumberedParagraph);
		return textNumberedParagraph;
	}

	/**
	 * Create child element {@odf.element text:object-index}.
	 *
	 * @param textNameValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return the element {@odf.element text:object-index}
	 */
	 public TextObjectIndexElement newTextObjectIndexElement(String textNameValue) {
		TextObjectIndexElement textObjectIndex = ((OdfFileDom) this.ownerDocument).newOdfElement(TextObjectIndexElement.class);
		textObjectIndex.setTextNameAttribute(textNameValue);
		this.appendChild(textObjectIndex);
		return textObjectIndex;
	}

	/**
	 * Create child element {@odf.element text:p}.
	 *
	 * @return the element {@odf.element text:p}
	 */
	public TextPElement newTextPElement() {
		TextPElement textP = ((OdfFileDom) this.ownerDocument).newOdfElement(TextPElement.class);
		this.appendChild(textP);
		return textP;
	}

	/**
	 * Create child element {@odf.element text:section}.
	 *
	 * @param textDisplayValue  the <code>String</code> value of <code>TextDisplayAttribute</code>, see {@odf.attribute  text:display} at specification
	 * @param textNameValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return the element {@odf.element text:section}
	 */
	 public TextSectionElement newTextSectionElement(String textDisplayValue, String textNameValue) {
		TextSectionElement textSection = ((OdfFileDom) this.ownerDocument).newOdfElement(TextSectionElement.class);
		textSection.setTextDisplayAttribute(textDisplayValue);
		textSection.setTextNameAttribute(textNameValue);
		this.appendChild(textSection);
		return textSection;
	}

	/**
	 * Create child element {@odf.element text:soft-page-break}.
	 *
	 * @return the element {@odf.element text:soft-page-break}
	 */
	public TextSoftPageBreakElement newTextSoftPageBreakElement() {
		TextSoftPageBreakElement textSoftPageBreak = ((OdfFileDom) this.ownerDocument).newOdfElement(TextSoftPageBreakElement.class);
		this.appendChild(textSoftPageBreak);
		return textSoftPageBreak;
	}

	/**
	 * Create child element {@odf.element text:table-index}.
	 *
	 * @param textNameValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return the element {@odf.element text:table-index}
	 */
	 public TextTableIndexElement newTextTableIndexElement(String textNameValue) {
		TextTableIndexElement textTableIndex = ((OdfFileDom) this.ownerDocument).newOdfElement(TextTableIndexElement.class);
		textTableIndex.setTextNameAttribute(textNameValue);
		this.appendChild(textTableIndex);
		return textTableIndex;
	}

	/**
	 * Create child element {@odf.element text:table-of-content}.
	 *
	 * @param textNameValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return the element {@odf.element text:table-of-content}
	 */
	 public TextTableOfContentElement newTextTableOfContentElement(String textNameValue) {
		TextTableOfContentElement textTableOfContent = ((OdfFileDom) this.ownerDocument).newOdfElement(TextTableOfContentElement.class);
		textTableOfContent.setTextNameAttribute(textNameValue);
		this.appendChild(textTableOfContent);
		return textTableOfContent;
	}

	/**
	 * Create child element {@odf.element text:user-index}.
	 *
	 * @param textNameValue  the <code>String</code> value of <code>TextNameAttribute</code>, see {@odf.attribute  text:name} at specification
	 * @return the element {@odf.element text:user-index}
	 */
	 public TextUserIndexElement newTextUserIndexElement(String textNameValue) {
		TextUserIndexElement textUserIndex = ((OdfFileDom) this.ownerDocument).newOdfElement(TextUserIndexElement.class);
		textUserIndex.setTextNameAttribute(textNameValue);
		this.appendChild(textUserIndex);
		return textUserIndex;
	}

	@Override
	public void accept(ElementVisitor visitor) {
		if (visitor instanceof DefaultElementVisitor) {
			DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
			defaultVisitor.visit(this);
		} else {
			visitor.visit(this);
		}
	}

	@Override
	/** If this element is the first - perhaps only - element of a logical group of XML elements. For instance: table, paragraph */
	public boolean isComponentRoot(){
		return true;
	}

	@Override
	// ToDo: Move this to a intermediate class, e.g. ComponentRootElement
	/** @return the component size of a heading, which is always 1 */
	public int getRepetition() {
		Integer repeated =  super.getTableNumberColumnsRepeatedAttribute();
		if (repeated == null) {
			repeated = 1;
		}
		return repeated;
	}

	@Override
	// ToDo: Move this to a intermediate class, e.g. ComponentRootElement
	/**
	 * @return the component size of a heading, which is always 1
	 */
	public boolean isRepeatable() {
		return true;
	}

	@Override
	// ToDo: Move this to a intermediate class, e.g. ComponentRootElement
	/** @return the component size of a heading, which is always 1 */
	public void setRepetition(int repetition) {
		super.setTableNumberColumnsRepeatedAttribute(repetition);
	}
    public DataStyleElement getOwnDataStyle(){
        try {
            String styleName = getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name");
            String dataStyleName = "";
            OdfFileDom xDoc = (OdfFileDom)getOwnerDocument();
            OdfDocument odfDoc = (OdfDocument)xDoc.getDocument();
            OdfOfficeStyles officeStyles = odfDoc.getStylesDom().getOfficeStyles();
            if(styleName == null || styleName.isEmpty()){
                TableTableRowElement row =  (TableTableRowElement) getParentNode();
                TableTableCellElement rowCell = (TableTableCellElement)row.getFirstChild();
                int cellIndex = 0;
                while(rowCell != null){
                    if(rowCell.equals(this)){
                        break;
                    }
                    cellIndex += rowCell.getRepetition();
                    rowCell = (TableTableCellElement)rowCell.getNextSibling();
                }

                Node tableNode = row.getParentNode();
                TableTableColumnElement columnNode = OdfElement.findFirstChildNode(TableTableColumnElement.class, tableNode);
                int colIndex = 0;
                while(columnNode != null){
                    TableTableColumnElement column = columnNode;
                    if(colIndex <= cellIndex && cellIndex <= colIndex + column.getRepetition() - 1){
                        styleName = column.getTableDefaultCellStyleNameAttribute();
                        break;
                    }
                    columnNode = (TableTableColumnElement)columnNode.getNextSibling();
                }
            }
            OdfStyle ownStyle = officeStyles.getStyle(styleName, OdfStyleFamily.TableCell);
            if(ownStyle == null) {
                ownStyle = odfDoc.getContentDom().getAutomaticStyles().getStyle(styleName, OdfStyleFamily.TableCell);
            }
            dataStyleName = ownStyle.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "data-style-name");
            if(dataStyleName != null) {
                DataStyleElement dataStyle = officeStyles.getAllDataStyles().get(dataStyleName);
                if(dataStyle == null) {
                    dataStyle = odfDoc.getContentDom().getAutomaticStyles().getAllDataStyles().get(dataStyleName);
                }
                return dataStyle;
            }
        } catch (SAXException e) {
            Logger.getLogger(TableTableCellElement.class.getName()).log(Level.SEVERE, null, e);
        } catch (IOException ex) {
            Logger.getLogger(TableTableCellElement.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}
