/*
 * Decompiled with CFR 0.152.
 */
package org.octopusden.releng.versions;

import java.util.ArrayList;
import java.util.Objects;
import org.octopusden.releng.versions.IVersionInfo;
import org.octopusden.releng.versions.NumericVersion;
import org.octopusden.releng.versions.VersionNames;

public class NumericVersionFactory {
    final VersionNames versionNames;

    public NumericVersionFactory(VersionNames versionNames) {
        this.versionNames = versionNames;
    }

    public IVersionInfo create(String rawVersion) {
        int r;
        Objects.requireNonNull(rawVersion, "version can't be null");
        ArrayList<String> strings = new ArrayList<String>();
        int l = 0;
        for (r = 0; r < rawVersion.length(); ++r) {
            char c = rawVersion.charAt(r);
            if (c != '_' && c != '.' && c != '-') continue;
            strings.add(rawVersion.substring(l, r));
            l = r + 1;
        }
        strings.add(rawVersion.substring(l, r));
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (String stringItem : strings) {
            int item;
            try {
                item = Integer.parseInt(stringItem);
            }
            catch (NumberFormatException e) {
                continue;
            }
            items.add(item);
        }
        return new NumericVersion(this.versionNames, items, rawVersion, rawVersion.endsWith("-SNAPSHOT"), rawVersion.endsWith("_RC"));
    }

    public IVersionInfo create(int ... elements) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int element : elements) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(".");
            }
            stringBuilder.append(element);
        }
        return this.create(stringBuilder.toString());
    }
}

