/*
 * Decompiled with CFR 0.152.
 */
package org.octopusden.releng.versions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class ComponentVersionFormat {
    private static final int MAGIK = 31;
    @JsonProperty
    private String majorVersionFormat;
    @JsonProperty
    private String releaseVersionFormat;
    @JsonProperty
    private String buildVersionFormat;
    @JsonProperty
    private String lineVersionFormat;

    private ComponentVersionFormat(String releaseVersionFormat, String majorVersionFormat, String buildVersionFormat, String lineVersionFormat) {
        this.releaseVersionFormat = releaseVersionFormat;
        this.majorVersionFormat = majorVersionFormat;
        this.buildVersionFormat = buildVersionFormat;
        this.lineVersionFormat = lineVersionFormat;
    }

    public static ComponentVersionFormat create(String majorVersionFormat, String releaseVersionFormat) {
        return ComponentVersionFormat.create(majorVersionFormat, releaseVersionFormat, null, null);
    }

    @JsonCreator
    public static ComponentVersionFormat create(@JsonProperty(value="majorVersionFormat") String majorVersionFormat, @JsonProperty(value="releaseVersionFormat") String releaseVersionFormat, @JsonProperty(value="buildVersionFormat") String buildVersionFormat, @JsonProperty(value="lineVersionFormat") String lineVersionFormat) {
        return new ComponentVersionFormat(releaseVersionFormat, majorVersionFormat, buildVersionFormat, lineVersionFormat);
    }

    public String getReleaseVersionFormat() {
        return this.releaseVersionFormat;
    }

    public String getMajorVersionFormat() {
        return this.majorVersionFormat;
    }

    public String getBuildVersionFormat() {
        return this.buildVersionFormat;
    }

    public String getLineVersionFormat() {
        return this.lineVersionFormat;
    }

    public String toString() {
        return "ComponentVersionFormat{releaseVersionFormat='" + this.releaseVersionFormat + '\'' + ", majorVersionFormat='" + this.majorVersionFormat + '\'' + ", buildVersionFormat='" + this.buildVersionFormat + '\'' + ", lineVersionFormat='" + this.lineVersionFormat + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentVersionFormat that = (ComponentVersionFormat)o;
        if (this.releaseVersionFormat != null ? !this.releaseVersionFormat.equals(that.releaseVersionFormat) : that.releaseVersionFormat != null) {
            return false;
        }
        if (this.majorVersionFormat != null ? !this.majorVersionFormat.equals(that.majorVersionFormat) : that.majorVersionFormat != null) {
            return false;
        }
        if (this.lineVersionFormat != null ? !this.lineVersionFormat.equals(that.lineVersionFormat) : that.lineVersionFormat != null) {
            return false;
        }
        return !(this.buildVersionFormat == null ? that.buildVersionFormat != null : !this.buildVersionFormat.equals(that.buildVersionFormat));
    }

    public int hashCode() {
        int result = this.releaseVersionFormat != null ? this.releaseVersionFormat.hashCode() : 0;
        result = 31 * result + (this.majorVersionFormat != null ? this.majorVersionFormat.hashCode() : 0);
        result = 31 * result + (this.buildVersionFormat != null ? this.buildVersionFormat.hashCode() : 0);
        result = 31 * result + (this.lineVersionFormat != null ? this.lineVersionFormat.hashCode() : 0);
        return result;
    }
}

