/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.utils;

import com.platformlib.process.api.ProcessInstance;
import com.platformlib.process.configurator.ProcessOutputConfigurator;
import com.platformlib.process.local.factory.LocalProcessBuilderFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenseRegistryClient {
    private final Logger LOGGER = LoggerFactory.getLogger(LicenseRegistryClient.class);
    private static final String LICENSE_REGISTRY_GIT_REPOSITORY_PROPERTY_NAME = "license-registry.git-repository";
    private final Map<String, String> cachedFiles;
    private static LicenseRegistryClient INSTANCE;

    private LicenseRegistryClient(String gitRepository) {
        this.cachedFiles = this.initialize(gitRepository);
    }

    private Map<String, String> initialize(String gitRepository) {
        Path tmpPath;
        Objects.requireNonNull(gitRepository);
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            tmpPath = Files.createTempDirectory("licenses-", new FileAttribute[0]);
        }
        catch (IOException ioException) {
            throw new IllegalStateException(ioException);
        }
        try {
            ProcessInstance processInstance = (ProcessInstance)LocalProcessBuilderFactory.newLocalProcessBuilder().logger(configuration -> configuration.logger(this.LOGGER)).processInstance(ProcessOutputConfigurator::unlimited).command("git").build().execute(new Object[]{"clone", "--depth=1", gitRepository, tmpPath}).toCompletableFuture().join();
            if (processInstance.getExitCode() != 0) {
                this.LOGGER.error("The git clone command stdout: {}", (Object)String.join((CharSequence)"\n", processInstance.getStdOut()));
                this.LOGGER.error("The git clone command stderr: {}", (Object)String.join((CharSequence)"\n", processInstance.getStdErr()));
                throw new IllegalStateException("Unable to clone git repository " + gitRepository);
            }
            this.LOGGER.info("Cloned {} into {}", (Object)gitRepository, (Object)tmpPath);
            Files.walk(tmpPath, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                try {
                    result.put(path.getFileName().toString(), new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
                }
                catch (IOException ioException) {
                    throw new IllegalStateException(ioException);
                }
            });
            Arrays.asList("templates", "licenses").forEach(source -> {
                try {
                    Files.walk(tmpPath.resolve((String)source), 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        try {
                            result.put(source + "/" + path.getFileName().toString(), new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
                        }
                        catch (IOException ioException) {
                            throw new IllegalStateException(ioException);
                        }
                    });
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (IOException exception) {
            throw new IllegalStateException(exception);
        }
        finally {
            try {
                Files.walk(tmpPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException ioException) {
                this.LOGGER.warn("Unable to delete temporary resource", (Throwable)ioException);
            }
        }
        this.LOGGER.debug("License cached files are: " + String.join((CharSequence)",", result.keySet()));
        return result;
    }

    public static synchronized LicenseRegistryClient getInstance() {
        if (INSTANCE == null) {
            String licenseRegistryGitRepository = Optional.ofNullable(System.getProperty(LICENSE_REGISTRY_GIT_REPOSITORY_PROPERTY_NAME, System.getenv(LICENSE_REGISTRY_GIT_REPOSITORY_PROPERTY_NAME))).orElseThrow(() -> new IllegalArgumentException("Either Environment variable or JVM argument for set 'license-registry.git-repository' must be provided"));
            INSTANCE = new LicenseRegistryClient(licenseRegistryGitRepository);
        }
        return INSTANCE;
    }

    public String getFileContent(String fileName) {
        if (!this.cachedFiles.containsKey(fileName)) {
            throw new IllegalArgumentException("The file '" + fileName + "' hasn't been found");
        }
        return this.cachedFiles.get(fileName);
    }
}

