/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.LicenseRegistryClient;

public class LicenseDownloader {
    private String proxyUrl;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;

    public LicenseDownloader(String proxyAddr) {
        this.proxyUrl = proxyAddr;
    }

    public void downloadFromGitLab(String licenseUrlString, File outputFile) {
        try {
            System.out.println("Downloading " + licenseUrlString);
            Response response = Request.Get((String)licenseUrlString).execute();
            response.saveContent(outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadLicense(String licenseUrlString, String loginPassword, File outputFile) throws IOException {
        InputStream licenseInputStream;
        if (licenseUrlString == null || licenseUrlString.length() == 0) {
            return;
        }
        if (!licenseUrlString.startsWith("http")) {
            licenseInputStream = new ByteArrayInputStream(LicenseRegistryClient.getInstance().getFileContent(licenseUrlString).getBytes(StandardCharsets.UTF_8));
        } else {
            URLConnection connection = this.newConnection(licenseUrlString, loginPassword);
            boolean redirect = false;
            if (connection instanceof HttpURLConnection) {
                int status = ((HttpURLConnection)connection).getResponseCode();
                boolean bl = redirect = 302 == status || 301 == status || 303 == status;
            }
            if (redirect) {
                String newUrl = connection.getHeaderField("Location");
                connection = this.newConnection(newUrl, loginPassword);
            }
            licenseInputStream = connection.getInputStream();
            outputFile = LicenseDownloader.updateFileExtension(outputFile, connection.getContentType());
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
            LicenseDownloader.copyStream(licenseInputStream, fos);
            licenseInputStream.close();
            fos.close();
        }
        finally {
            FileUtil.tryClose(licenseInputStream);
            FileUtil.tryClose(fos);
        }
    }

    private static void copyStream(InputStream inStream, OutputStream outStream) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = inStream.read(buf)) > 0) {
            outStream.write(buf, 0, len);
        }
    }

    private URLConnection newConnection(String url, String loginPassword) throws IOException {
        Proxy proxy;
        URL licenseUrl = new URL(url);
        if (this.proxyUrl != null) {
            URL purl = new URL(this.proxyUrl);
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(purl.getHost(), purl.getPort()));
        } else {
            proxy = Proxy.NO_PROXY;
        }
        URLConnection connection = licenseUrl.openConnection(proxy);
        if (loginPassword != null) {
            connection.setRequestProperty("Proxy-Authorization", loginPassword);
        }
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        return connection;
    }

    private static File updateFileExtension(File outputFile, String mimeType) {
        String realExtension = LicenseDownloader.getFileExtension(mimeType);
        if (realExtension != null && !outputFile.getName().endsWith(realExtension)) {
            return new File(outputFile.getAbsolutePath() + realExtension);
        }
        return outputFile;
    }

    private static String getFileExtension(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        String lowerMimeType = mimeType.toLowerCase();
        if (lowerMimeType.contains("plain")) {
            return ".txt";
        }
        if (lowerMimeType.contains("html")) {
            return ".html";
        }
        if (lowerMimeType.contains("pdf")) {
            return ".pdf";
        }
        return null;
    }
}

