/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.nexus;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.util.EntityUtils;
import org.apache.maven.model.License;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.license.nexus.ComponentInfo;

public class LicenseProcessor {
    private static final List<String> IGNORED_LICENSES = Collections.unmodifiableList(Arrays.asList("Not-Declared", "Not Declared", "UNSPECIFIED", "No-Sources", "No Sources"));
    private Log log;
    private String proxyUrl;

    public LicenseProcessor(Log log, String proxyUrl) {
        this.log = log;
        this.proxyUrl = proxyUrl;
    }

    public Log getLog() {
        return this.log;
    }

    public List<License> getLicencesByProject(MavenProject depMavenProject) {
        try {
            Response response;
            HttpResponse httpResponse;
            int statusCode;
            String url = this.getUrl(depMavenProject);
            this.getLog().info((CharSequence)("Executing " + url));
            Request request = this.request(url);
            if (this.proxyUrl != null) {
                request = request.viaProxy(this.proxyUrl);
            }
            if ((statusCode = (httpResponse = (response = request.execute()).returnResponse()).getStatusLine().getStatusCode()) == 200) {
                String responseStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                System.out.println(responseStr);
                List<License> mavenLicenses = this.getLicensesFromJSON(responseStr);
                if (mavenLicenses.isEmpty()) {
                    this.getLog().info((CharSequence)("No licenses found in Nexus for " + this.toString(depMavenProject) + " in Nexus"));
                } else {
                    this.getLog().info((CharSequence)("Nexus licenses found for " + this.toString(depMavenProject) + ": " + this.toString(mavenLicenses)));
                }
                return mavenLicenses;
            }
            if (statusCode == 404) {
                this.getLog().info((CharSequence)("license for " + this.toString(depMavenProject) + ":" + depMavenProject.getVersion() + " is not found in Nexus"));
            } else {
                this.getLog().info((CharSequence)("Unknown status code for " + this.toString(depMavenProject) + " : " + statusCode));
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage());
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    private String toString(List<License> mavenLicenses) {
        ArrayList<String> licenseNameList = new ArrayList<String>();
        for (License license : mavenLicenses) {
            licenseNameList.add(license.getName());
        }
        return StringUtils.join(licenseNameList, (String)",");
    }

    private String toString(MavenProject depMavenProject) {
        return depMavenProject.getGroupId() + ":" + depMavenProject.getArtifact();
    }

    private Request request(String url) {
        return Request.Get((String)url).addHeader("Connection", "Keep-Alive").addHeader("User-Agent", "Nexus/2.14.5-02 (PRO; Linux; 3.10.0-327.36.1.el7.x86_64; amd64; 1.8.0_102)").addHeader("Accept-Encoding", "gzip,deflate");
    }

    List<License> getLicensesFromJSON(String responseStr) throws IOException {
        ComponentInfo componentInfo = this.parseJSON(responseStr);
        List<String> declaredLicenseIds = this.parseLicenseList(componentInfo.getDeclaredLicenses());
        List<String> observedLicenseIds = this.parseLicenseList(componentInfo.getObservedLicenses());
        HashSet<String> uniqueLicences = new HashSet<String>();
        uniqueLicences.addAll(declaredLicenseIds);
        uniqueLicences.addAll(observedLicenseIds);
        ArrayList<License> mavenLicenses = new ArrayList<License>();
        for (String licenseId : uniqueLicences) {
            License e = new License();
            e.setName(licenseId);
            mavenLicenses.add(e);
        }
        return mavenLicenses;
    }

    List<String> parseLicenseList(List<ComponentInfo.License> declaredLicenses) {
        ArrayList<String> allLicences = new ArrayList<String>();
        for (ComponentInfo.License declaredLicense : declaredLicenses) {
            String licenseId = declaredLicense.getLicenseId();
            List<String> licenses = this.parseLicense(licenseId);
            allLicences.addAll(licenses);
        }
        return allLicences;
    }

    public List<String> parseLicense(String licenseStr) {
        String[] items = licenseStr.split(" or ");
        ArrayList<String> list = new ArrayList<String>();
        for (String item : items) {
            if (!StringUtils.isNotBlank((CharSequence)item) || IGNORED_LICENSES.contains(item.trim())) continue;
            list.add(item);
        }
        return list;
    }

    private String getUrl(MavenProject depMavenProject) {
        String groupId = depMavenProject.getGroupId();
        String version = depMavenProject.getVersion();
        String packaging = depMavenProject.getPackaging();
        String artifactId = depMavenProject.getArtifactId();
        return "https://rhc-pro.sonatype.com/rest/rhc/extras/componentDetails/b82cd057df4f463e9a0ffe5b782a2163/5af35056b4d257e4b64b9e8069c0746e8b08629f?componentIdentifier=%7B%22format%22:%22maven%22,%22coordinates%22:%7B%22artifactId%22:%22" + artifactId + "%22,%22extension%22:%22" + packaging + "%22,%22groupId%22:%22" + groupId + "%22,%22version%22:%22" + version + "%22%7D%7D&licenseId=803a54e2d20bb68c7aca5955ff1ccf24732351ff";
    }

    ComponentInfo parseJSON(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (ComponentInfo)mapper.readValue(data, ComponentInfo.class);
    }
}

