/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ThirdPartyHelper;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.nexus.LicenseProcessor;
import org.codehaus.mojo.license.utils.LicenseRegistryClient;
import org.codehaus.mojo.license.utils.SortedProperties;

public class DefaultThirdPartyHelper
implements ThirdPartyHelper {
    private final DependenciesTool dependenciesTool;
    private final ThirdPartyTool thirdPartyTool;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;
    private final MavenProject project;
    private final String encoding;
    private final boolean verbose;
    private final Log log;
    private static SortedMap<String, MavenProject> artifactCache;

    public DefaultThirdPartyHelper(MavenProject project, String encoding, boolean verbose, DependenciesTool dependenciesTool, ThirdPartyTool thirdPartyTool, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, Log log) {
        this.project = project;
        this.encoding = encoding;
        this.verbose = verbose;
        this.dependenciesTool = dependenciesTool;
        this.thirdPartyTool = thirdPartyTool;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
        this.log = log;
        this.thirdPartyTool.setVerbose(verbose);
    }

    @Override
    public SortedMap<String, MavenProject> getArtifactCache() {
        if (artifactCache == null) {
            artifactCache = new TreeMap<String, MavenProject>();
        }
        return artifactCache;
    }

    @Override
    public SortedMap<String, MavenProject> loadDependencies(MavenProjectDependenciesConfigurator configuration) {
        return this.dependenciesTool.loadProjectDependencies(this.project, configuration, this.localRepository, this.remoteRepositories, this.getArtifactCache());
    }

    @Override
    public SortedProperties loadThirdPartyDescriptorForUnsafeMapping(Set<Artifact> topLevelDependencies, SortedSet<MavenProject> unsafeDependencies, Collection<MavenProject> projects, LicenseMap licenseMap) throws ThirdPartyToolException, IOException {
        return this.thirdPartyTool.loadThirdPartyDescriptorsForUnsafeMapping(topLevelDependencies, this.encoding, projects, unsafeDependencies, licenseMap, this.localRepository, this.remoteRepositories);
    }

    @Override
    public SortedProperties loadUnsafeMapping(LicenseMap licenseMap, File missingFile, SortedMap<String, MavenProject> projectDependencies) throws IOException {
        return this.thirdPartyTool.loadUnsafeMapping(licenseMap, projectDependencies, this.encoding, missingFile);
    }

    @Override
    public LicenseMap createLicenseMap(SortedMap<String, MavenProject> dependencies, String proxyUrl) {
        Collection<MavenProject> values = dependencies.values();
        return this.createLicenseMap(values, proxyUrl);
    }

    @Override
    public LicenseMap createLicenseMap(Collection<MavenProject> dependencies, String proxyUrl) {
        LicenseMap licenseMap = new LicenseMap();
        for (MavenProject project : dependencies) {
            this.thirdPartyTool.addLicense(licenseMap, project, project.getLicenses());
        }
        this.updateLicensesWithInfoFromNexus(licenseMap, proxyUrl);
        return licenseMap;
    }

    private void updateLicensesWithInfoFromNexus(LicenseMap licenseMap, String proxyUrl) {
        SortedSet mavenProjects = (SortedSet)licenseMap.get("Unknown license");
        if (mavenProjects != null) {
            TreeSet projectsToIterate = new TreeSet(mavenProjects);
            Iterator iterator = projectsToIterate.iterator();
            while (iterator.hasNext()) {
                LicenseProcessor licenseProcessor = new LicenseProcessor(this.log, proxyUrl);
                MavenProject mavenProject = (MavenProject)iterator.next();
                List<License> licences = licenseProcessor.getLicencesByProject(mavenProject);
                if (licences.isEmpty()) continue;
                mavenProjects.remove(mavenProject);
                this.thirdPartyTool.addLicense(licenseMap, mavenProject, licences);
            }
        }
    }

    @Override
    public void attachThirdPartyDescriptor(File file) {
        this.thirdPartyTool.attachThirdPartyDescriptor(this.project, file);
    }

    @Override
    public SortedSet<MavenProject> getProjectsWithNoLicense(LicenseMap licenseMap) {
        return this.thirdPartyTool.getProjectsWithNoLicense(licenseMap, this.verbose);
    }

    @Override
    public SortedProperties createUnsafeMapping(LicenseMap licenseMap, File missingFile, boolean useRepositoryMissingFiles, SortedSet<MavenProject> unsafeDependencies, SortedMap<String, MavenProject> projectDependencies) throws ProjectBuildingException, IOException, ThirdPartyToolException {
        SortedProperties unsafeMappings = this.loadUnsafeMapping(licenseMap, missingFile, projectDependencies);
        if (CollectionUtils.isNotEmpty(unsafeDependencies) && useRepositoryMissingFiles) {
            ArrayList<MavenProject> projects = new ArrayList<MavenProject>(projectDependencies.values());
            projects.remove(this.project);
            projects.removeAll(unsafeDependencies);
            SortedProperties resolvedUnsafeMapping = this.loadThirdPartyDescriptorForUnsafeMapping(this.project.getArtifacts(), unsafeDependencies, projects, licenseMap);
            for (Object coord : resolvedUnsafeMapping.keySet()) {
                String s = (String)coord;
                if (!projectDependencies.containsKey(s)) continue;
                unsafeMappings.put(s, resolvedUnsafeMapping.get(s));
            }
        }
        return unsafeMappings;
    }

    @Override
    public void mergeLicenses(List<String> licenseMerges, LicenseMap licenseMap) throws MojoFailureException {
        this.log.info((CharSequence)"Loading merges from merges.txt");
        Scanner mergesLines = new Scanner(LicenseRegistryClient.getInstance().getFileContent("merges.txt")).useDelimiter("\\n");
        while (mergesLines.hasNext()) {
            licenseMerges.add(mergesLines.next());
        }
        HashSet<String> licenseFound = new HashSet<String>();
        if (!CollectionUtils.isEmpty(licenseMerges)) {
            HashMap<String, Set<String>> mergedLicenses = new HashMap<String, Set<String>>();
            for (String string : licenseMerges) {
                String string2 = string.trim();
                String[] split = string2.split("\\s*\\|\\s*");
                String mainLicense = split[0];
                Set mergeList = mergedLicenses.containsKey(mainLicense) ? (Set)mergedLicenses.get(mainLicense) : new HashSet();
                for (int i = 0; i < split.length; ++i) {
                    String licenseToAdd = split[i];
                    if (i == 0) continue;
                    if (mergeList.contains(licenseToAdd) || licenseFound.contains(licenseToAdd)) {
                        throw new MojoFailureException("The license " + licenseToAdd + " was already registred in the configuration, please use only one such entry as describe in example http://mojo.codehaus.org/license-maven-plugin/examples/example-thirdparty.html#Merge_licenses.");
                    }
                    mergeList.add(licenseToAdd);
                    licenseFound.add(licenseToAdd);
                }
                mergedLicenses.put(mainLicense, mergeList);
            }
            for (Map.Entry entry : mergedLicenses.entrySet()) {
                String mainLicense = (String)entry.getKey();
                Set mergedLicense = (Set)entry.getValue();
                if (this.verbose) {
                    this.log.info((CharSequence)("Will merge to *" + mainLicense + "*, licenses: " + mergedLicense));
                }
                this.thirdPartyTool.mergeLicenses(licenseMap, mainLicense, mergedLicense);
            }
        }
    }
}

