/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Mojo(name="jars-json-list", requiresProject=false, requiresDirectInvocation=false, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class JarsJsonListMojo
extends AbstractMojo {
    private static final Pattern JAR_VERSION_PATTERN = Pattern.compile("-r?\\d");
    private static final Pattern POM_XML_ENTRY = Pattern.compile("^META-INF/maven/.+/pom\\.xml$");
    private static final Map<String, XPathExpression[]> POM_INFO_XPATHS = JarsJsonListMojo.getPomInfoXPathExpressions();
    @Parameter(property="jarDirectory", defaultValue="dist/lib")
    private String jarDirectory;
    @Parameter(property="jarInfoFile", defaultValue="jar-info.properties")
    private String jarInfoFile;
    @Parameter(property="outputFile", defaultValue="third-party.json")
    private String outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)("JARs directory: " + this.jarDirectory));
            this.getLog().info((CharSequence)("JAR information file: " + this.jarInfoFile));
            this.getLog().info((CharSequence)("Output file: " + this.outputFile));
            Properties artifacts = new Properties();
            artifacts.load(new FileReader(this.jarInfoFile));
            List<Map> infos = Files.list(Paths.get(this.jarDirectory, new String[0])).filter(path -> path.getFileName().toString().endsWith(".jar")).sorted().map(path -> this.extractJarInfo((Path)path, artifacts)).filter(Objects::nonNull).collect(Collectors.toList());
            JSONArray listJson = new JSONArray();
            infos.forEach(info -> {
                JSONObject infoJson = new JSONObject();
                info.forEach((arg_0, arg_1) -> ((JSONObject)infoJson).put(arg_0, arg_1));
                listJson.put((Object)infoJson);
            });
            Files.write(Paths.get(this.outputFile, new String[0]), listJson.toString(2).getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed read/write file", ex);
        }
    }

    private static Map<String, XPathExpression[]> getPomInfoXPathExpressions() {
        XPath xpath = XPathFactory.newInstance().newXPath();
        LinkedHashMap<String, XPathExpression[]> exprs = new LinkedHashMap<String, XPathExpression[]>();
        try {
            exprs.put("name", new XPathExpression[]{xpath.compile("/project/name")});
            exprs.put("groupId", new XPathExpression[]{xpath.compile("/project/groupId"), xpath.compile("/project/parent/groupId")});
            exprs.put("artifactId", new XPathExpression[]{xpath.compile("/project/artifactId")});
            exprs.put("version", new XPathExpression[]{xpath.compile("/project/version"), xpath.compile("/project/parent/version")});
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException("Failed to compile XPath expression", ex);
        }
        return exprs;
    }

    private Map<String, String> extractJarInfo(Path jarPath, Properties artifacts) {
        String jarName = jarPath.getFileName().toString();
        this.getLog().info((CharSequence)("Processing " + jarName));
        try {
            ZipFile zipFile = new ZipFile(jarPath.toFile());
            for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
                String entryName;
                if (zipEntry.isDirectory() || !POM_XML_ENTRY.matcher(entryName = zipEntry.getName()).matches()) continue;
                this.getLog().debug((CharSequence)"Found pom.xml");
                Map<String, String> mavenCoordinates = this.getPomInfo(zipFile, zipEntry);
                this.getLog().debug((CharSequence)("Maven coordinates: " + mavenCoordinates));
                return mavenCoordinates;
            }
            Map<String, String> jarCoordinates = JarsJsonListMojo.getJarInfo(jarName, artifacts);
            this.getLog().debug((CharSequence)("Jar coordinates: " + jarCoordinates));
            return jarCoordinates;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            this.getLog().error((CharSequence)("Exception raised during processing of " + jarName), (Throwable)ex);
            return null;
        }
    }

    private Map<String, String> getPomInfo(ZipFile zipFile, ZipEntry entry) throws ParserConfigurationException, IOException, SAXException {
        LinkedHashMap<String, String> pomInfo = new LinkedHashMap<String, String>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(zipFile.getInputStream(entry));
        POM_INFO_XPATHS.forEach((field, exprs) -> {
            for (XPathExpression expr : exprs) {
                try {
                    String value = expr.evaluate(doc);
                    if (value == null || value.isEmpty()) continue;
                    pomInfo.put((String)field, value);
                    break;
                }
                catch (XPathExpressionException ex) {
                    this.getLog().error((CharSequence)("Failed to evaluate XPath " + expr), (Throwable)ex);
                }
            }
        });
        pomInfo.put("packaging", "jar");
        return pomInfo;
    }

    private static Map<String, String> getJarInfo(String jarName, Properties artifacts) {
        String version;
        String artifactId;
        String artifact = jarName.substring(0, jarName.length() - 4);
        Matcher matcher = JAR_VERSION_PATTERN.matcher(artifact);
        if (matcher.find()) {
            int verIdx = matcher.start();
            artifactId = artifact.substring(0, verIdx);
            version = artifact.substring(verIdx + 1);
        } else {
            artifactId = artifact;
            version = JarsJsonListMojo.getAttribute(artifacts, artifactId, "version", null);
        }
        String name = JarsJsonListMojo.getAttribute(artifacts, artifactId, "name", null);
        String groupId = JarsJsonListMojo.getAttribute(artifacts, artifactId, "groupId", null);
        artifactId = JarsJsonListMojo.getAttribute(artifacts, artifactId, "artifactId", artifactId);
        LinkedHashMap<String, String> jarCoordinates = new LinkedHashMap<String, String>();
        jarCoordinates.put("name", name);
        jarCoordinates.put("groupId", groupId);
        jarCoordinates.put("artifactId", artifactId);
        jarCoordinates.put("version", version);
        jarCoordinates.put("packaging", "jar");
        return jarCoordinates;
    }

    private static String getAttribute(Properties artifacts, String artifactId, String attribute, String defaultValue) {
        String key = artifactId + "." + attribute;
        if (artifacts.containsKey(key)) {
            return artifacts.getProperty(key);
        }
        return defaultValue;
    }
}

