/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.codehaus.mojo.license.api.DefaultThirdPartyHelper;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.model.ProjectLicenseInfo;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.LicenseDownloader;
import org.codehaus.mojo.license.utils.LicenseRegistryClient;
import org.codehaus.mojo.license.utils.LicenseSummaryReader;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.plexus.util.Base64;

public abstract class AbstractDownloadLicensesMojo
extends AbstractMojo
implements MavenProjectDependenciesConfigurator {
    public static final String LICENSE_MAP_KEY = "licenseMap";
    @Parameter(property="license.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="license.failOnMissing", defaultValue="false")
    boolean failOnMissing;
    @Parameter(property="license.failOnBlacklist", defaultValue="false")
    boolean failOnBlacklist;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List remoteRepositories;
    @Parameter(property="licensesConfigFile", defaultValue="${project.basedir}/src/license/licenses.xml")
    private File licensesConfigFile;
    @Parameter(property="licensesOutputDirectory", defaultValue="${project.build.directory}/generated-resources/licenses")
    private File licensesOutputDirectory;
    @Parameter(property="licensesOutputFile", defaultValue="${project.build.directory}/generated-resources/licenses.xml")
    private File licensesOutputFile;
    @Parameter(property="license.excludedScopes", defaultValue="system")
    private String excludedScopes;
    @Parameter(property="license.includedScopes", defaultValue="")
    private String includedScopes;
    @Parameter(defaultValue="${settings.offline}")
    private boolean offline;
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter(defaultValue="true")
    private boolean includeTransitiveDependencies;
    @Parameter(property="license.excludeTransitiveDependencies", defaultValue="false")
    private boolean excludeTransitiveDependencies;
    @Parameter(defaultValue="${settings.proxies}", readonly=true)
    private List<Proxy> proxies;
    @Parameter(property="license.proxy", readonly=true)
    private String proxyUrl;
    @Parameter(property="license.organizeLicensesByDependencies", defaultValue="false")
    protected boolean organizeLicensesByDependencies;
    @Parameter(property="license.sortByGroupIdAndArtifactId", defaultValue="false")
    private boolean sortByGroupIdAndArtifactId;
    @Parameter(property="license.excludedGroups", defaultValue="")
    private String excludedGroups;
    @Parameter(property="license.includedGroups", defaultValue="")
    private String includedGroups;
    @Parameter(property="license.excludedArtifacts", defaultValue="")
    private String excludedArtifacts;
    @Parameter(property="license.includedArtifacts", defaultValue="")
    private String includedArtifacts;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter
    List<String> licenseMerges = new ArrayList<String>();
    @Component
    private DependenciesTool dependenciesTool;
    @Component
    private ThirdPartyTool thirdPartyTool;
    private Set<String> downloadedLicenseURLs = new HashSet<String>();
    private String proxyLoginPasswordEncoded;
    @Parameter(property="license.encoding", defaultValue="${project.build.sourceEncoding}")
    String encoding;

    protected abstract boolean isSkip();

    public final boolean isSkipAll() {
        return this.skip || this.isSkip();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected abstract SortedMap<String, MavenProject> getDependencies();

    protected SortedMap<String, MavenProject> getDependencies(MavenProject project) {
        return this.dependenciesTool.loadProjectDependencies(project, this, this.localRepository, this.remoteRepositories, null);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        LicenseMap licenseMap;
        this.initDirectories();
        if (this.isSkipAll()) {
            this.getLog().info((CharSequence)("skip flag is on, will skip goal. skipAll=" + this.skip));
            return;
        }
        this.initProxy();
        HashMap<String, ProjectLicenseInfo> configuredDepLicensesMap = new HashMap<String, ProjectLicenseInfo>();
        if (this.licensesOutputFile.exists()) {
            this.loadLicenseInfo(configuredDepLicensesMap, this.licensesOutputFile, true);
        }
        if (this.licensesConfigFile.exists()) {
            this.loadLicenseInfo(configuredDepLicensesMap, this.licensesConfigFile, false);
        }
        SortedMap<String, MavenProject> projectDependenciesMap = this.getDependencies();
        HashSet<MavenProject> dependencies = new HashSet<MavenProject>(projectDependenciesMap.values());
        if (this.getPluginContext().containsKey(LICENSE_MAP_KEY)) {
            this.getLog().info((CharSequence)"Loading licenseMap from cache");
            licenseMap = (LicenseMap)this.getPluginContext().get(LICENSE_MAP_KEY);
        } else {
            licenseMap = this.calculateLicenseMap(projectDependenciesMap, dependencies);
        }
        Properties licenseProperties = new Properties();
        try {
            this.getLog().info((CharSequence)"Loading license urls from licenses.properties");
            licenseProperties.load(new StringReader(LicenseRegistryClient.getInstance().getFileContent("licenses.properties")));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't fetch external third-party dependencies from licenses.properties", (Exception)e);
        }
        TreeMap<Object, String> licenseUrlMap = new TreeMap<Object, String>();
        TreeSet<Object> unresolvedLicenses = new TreeSet<Object>();
        for (Object licenseName : licenseMap.keySet()) {
            String licenseURL;
            if (((SortedSet)licenseMap.get(licenseName)).isEmpty()) {
                this.getLog().warn((CharSequence)("No projects for " + (String)licenseName));
            }
            if (licenseProperties.containsKey(licenseName)) {
                licenseURL = licenseProperties.getProperty((String)licenseName);
                this.getLog().info((CharSequence)("license for " + (String)licenseName + " is found = '" + licenseURL + "'"));
            } else {
                licenseURL = this.getLicenseUrlFromProjects(licenseMap, (String)licenseName, dependencies);
                this.getLog().info((CharSequence)("URL from projects for " + (String)licenseName + " = '" + licenseURL + "'"));
            }
            if (licenseURL != null) {
                licenseUrlMap.put(licenseName, licenseURL);
                continue;
            }
            unresolvedLicenses.add(licenseName);
        }
        HashMap<String, String> failedLicenses = new HashMap<String, String>();
        for (String license : licenseUrlMap.keySet()) {
            String string;
            if (this.downloadLicense(license, string = (String)licenseUrlMap.get(license))) continue;
            failedLicenses.put(license, string);
        }
        if (!unresolvedLicenses.isEmpty()) {
            StringBuilder message = new StringBuilder("\n");
            for (String string : unresolvedLicenses) {
                message.append(string).append(" -> ").append(licenseMap.get(string)).append("\n");
            }
            if (this.failOnMissing) {
                throw new MojoFailureException("URLs are not defined for the following licenses: " + message);
            }
            this.getLog().warn((CharSequence)("URLs are not defined for the following licenses: " + message));
        }
        if (!failedLicenses.isEmpty()) {
            throw new MojoFailureException("Failed to download licenses by the following urls: " + ((Object)failedLicenses).toString());
        }
    }

    private LicenseMap calculateLicenseMap(SortedMap<String, MavenProject> projectDependenciesMap, Set<MavenProject> dependencies) throws MojoFailureException {
        DefaultThirdPartyHelper thirdPartyHelper = new DefaultThirdPartyHelper(this.project, this.getEncoding(), this.isVerbose(), this.dependenciesTool, this.thirdPartyTool, this.localRepository, this.project.getRemoteArtifactRepositories(), this.getLog());
        LicenseMap licenseMap = thirdPartyHelper.createLicenseMap(dependencies, this.proxyUrl);
        this.overrideLicenses(licenseMap, projectDependenciesMap);
        thirdPartyHelper.mergeLicenses(this.licenseMerges, licenseMap);
        return licenseMap;
    }

    void overrideLicenses(LicenseMap licenseMap, SortedMap<String, MavenProject> projectDependencies) throws MojoFailureException {
        try {
            this.thirdPartyTool.overrideLicenses(licenseMap, projectDependencies, this.getEncoding(), "thirdparty-licenses.properties");
        }
        catch (IOException e) {
            throw new MojoFailureException("Can't fetch external third-party license info from thirdparty-licenses.properties", (Throwable)e);
        }
    }

    private boolean downloadLicense(String license, String licenseUrl) {
        try {
            String licenseFileName = this.getLicenseFileName(null, license, licenseUrl);
            File licenseOutputFile = new File(this.licensesOutputDirectory, licenseFileName);
            if (licenseOutputFile.exists()) {
                return true;
            }
            if (!this.downloadedLicenseURLs.contains(licenseUrl) || this.organizeLicensesByDependencies) {
                this.getLog().info((CharSequence)("Downloading " + license + " from " + licenseUrl));
                LicenseDownloader licenseDownloader = new LicenseDownloader(this.proxyUrl);
                licenseDownloader.downloadLicense(licenseUrl, this.proxyLoginPasswordEncoded, licenseOutputFile);
                this.downloadedLicenseURLs.add(licenseUrl);
                return true;
            }
        }
        catch (MalformedURLException e) {
            if (!this.quiet) {
                this.getLog().warn((CharSequence)(license + " has an invalid license URL: " + licenseUrl));
            }
        }
        catch (FileNotFoundException e) {
            if (!this.quiet) {
                this.getLog().warn((CharSequence)(license + " has a license URL that returns file not found: " + licenseUrl));
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to retrieve license " + license + " by " + licenseUrl));
            this.getLog().warn((CharSequence)e.getMessage());
        }
        return false;
    }

    private String getLicenseUrlFromProjects(LicenseMap licenseMap, String licenseName, Set<MavenProject> dependencies) {
        List<String> licenseSynonims = this.findLicenseSynonims(licenseName);
        this.getLog().debug((CharSequence)("synonyms for " + licenseName + " are " + licenseSynonims));
        SortedSet mavenProjects = (SortedSet)licenseMap.get(licenseName);
        for (MavenProject mavenProject : mavenProjects) {
            MavenProject fullMavenProject = this.findMavenProject(dependencies, mavenProject);
            List licenses = fullMavenProject.getModel().getLicenses();
            for (License licenseFromDep : licenses) {
                if (!licenseSynonims.contains(licenseFromDep.getName()) || licenseFromDep.getUrl() == null) continue;
                return licenseFromDep.getUrl();
            }
        }
        return null;
    }

    private List<String> findLicenseSynonims(String licenseName) {
        for (String licengeMergeString : this.licenseMerges) {
            String[] items;
            for (String item : items = licengeMergeString.split("\\s*\\|\\s*")) {
                if (!licenseName.equals(item)) continue;
                return Arrays.asList(items);
            }
        }
        return Collections.singletonList(licenseName);
    }

    private MavenProject findMavenProject(Set<MavenProject> dependencies, MavenProject mavenProject) {
        for (MavenProject p : dependencies) {
            if (!p.getGroupId().equals(mavenProject.getGroupId()) || !p.getArtifact().equals(mavenProject.getArtifact()) || !p.getVersion().equals(mavenProject.getVersion()) || !p.getPackaging().equals(mavenProject.getPackaging())) continue;
            return p;
        }
        this.getLog().error((CharSequence)("maven project not found for " + mavenProject));
        return mavenProject;
    }

    private List<ProjectLicenseInfo> sortByGroupIdAndArtifactId(List<ProjectLicenseInfo> depProjectLicenses) {
        ArrayList<ProjectLicenseInfo> sorted = new ArrayList<ProjectLicenseInfo>(depProjectLicenses);
        Comparator<ProjectLicenseInfo> comparator = new Comparator<ProjectLicenseInfo>(){

            @Override
            public int compare(ProjectLicenseInfo info1, ProjectLicenseInfo info2) {
                return (info1.getGroupId() + "+" + info1.getArtifactId()).compareTo(info2.getGroupId() + "+" + info2.getArtifactId());
            }
        };
        Collections.sort(sorted, comparator);
        return sorted;
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    @Override
    public boolean isExcludeTransitiveDependencies() {
        return this.excludeTransitiveDependencies;
    }

    @Override
    public List<String> getExcludedScopes() {
        return MojoHelper.getParams(this.excludedScopes);
    }

    public void setExcludedScopes(String excludedScopes) {
        this.excludedScopes = excludedScopes;
    }

    @Override
    public List<String> getIncludedScopes() {
        return MojoHelper.getParams(this.includedScopes);
    }

    @Override
    public String getIncludedArtifacts() {
        return this.includedArtifacts;
    }

    @Override
    public String getIncludedGroups() {
        return this.includedGroups;
    }

    @Override
    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    @Override
    public String getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    @Override
    public boolean isVerbose() {
        return this.getLog().isDebugEnabled();
    }

    private void initDirectories() throws MojoExecutionException {
        try {
            FileUtil.createDirectoryIfNecessary(this.licensesOutputDirectory);
            FileUtil.createDirectoryIfNecessary(this.licensesOutputFile.getParentFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create a directory...", (Exception)e);
        }
    }

    private void initProxy() throws MojoExecutionException {
        Proxy proxyToUse = null;
        for (Proxy proxy : this.proxies) {
            if (!proxy.isActive() || !"http".equals(proxy.getProtocol())) continue;
            proxyToUse = proxy;
            break;
        }
        if (proxyToUse != null) {
            System.getProperties().put("proxySet", "true");
            System.setProperty("proxyHost", proxyToUse.getHost());
            System.setProperty("proxyPort", String.valueOf(proxyToUse.getPort()));
            if (proxyToUse.getNonProxyHosts() != null) {
                System.setProperty("nonProxyHosts", proxyToUse.getNonProxyHosts());
            }
            if (proxyToUse.getUsername() != null) {
                String loginPassword = proxyToUse.getUsername() + ":" + proxyToUse.getPassword();
                this.proxyLoginPasswordEncoded = new String(Base64.encodeBase64((byte[])loginPassword.getBytes()));
            }
        }
    }

    private void loadLicenseInfo(Map<String, ProjectLicenseInfo> configuredDepLicensesMap, File licenseConfigFile, boolean previouslyDownloaded) throws MojoExecutionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(licenseConfigFile);
            List<ProjectLicenseInfo> licensesList = LicenseSummaryReader.parseLicenseSummary(fis);
            for (ProjectLicenseInfo dep : licensesList) {
                configuredDepLicensesMap.put(dep.getId(), dep);
                if (!previouslyDownloaded) continue;
                for (License license : dep.getLicenses()) {
                    this.downloadedLicenseURLs.add(license.getUrl());
                }
            }
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Unable to parse license summary output file: " + licenseConfigFile, e);
            }
            catch (Throwable throwable) {
                FileUtil.tryClose(fis);
                throw throwable;
            }
        }
        FileUtil.tryClose(fis);
    }

    private String getArtifactProjectId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    private ProjectLicenseInfo createDependencyProject(MavenProject depMavenProject) {
        ProjectLicenseInfo dependencyProject = new ProjectLicenseInfo(depMavenProject.getGroupId(), depMavenProject.getArtifactId(), depMavenProject.getVersion());
        List licenses = depMavenProject.getLicenses();
        for (Object license : licenses) {
            License license1 = (License)license;
            this.getLog().info((CharSequence)("Add license " + license1.getName() + ", " + license1.getUrl() + " to " + depMavenProject));
            dependencyProject.addLicense(license1);
        }
        return dependencyProject;
    }

    private String getLicenseFileName(ProjectLicenseInfo depProject, License license) throws MalformedURLException {
        return this.getLicenseFileName(depProject, license.getName(), license.getUrl());
    }

    private String getLicenseFileName(ProjectLicenseInfo depProject, String licenseName, String licenseUrlStr) throws MalformedURLException {
        String licenseFileName;
        File licenseUrlFile;
        if (licenseUrlStr.startsWith("http")) {
            URL licenseUrl = new URL(licenseUrlStr.replace("/raw?ref=master", "").replace("%2F", "/"));
            licenseUrlFile = new File(licenseUrl.getPath());
        } else {
            licenseUrlFile = new File(licenseUrlStr);
        }
        String defaultExtension = ".txt";
        if (this.organizeLicensesByDependencies) {
            licenseFileName = String.format("%s.%s%s", depProject.getGroupId(), depProject.getArtifactId(), licenseName != null ? "_" + licenseName : "").toLowerCase().replaceAll("\\s+", "_");
        } else {
            int extensionIndex;
            licenseFileName = licenseUrlFile.getName();
            if (licenseName != null) {
                licenseFileName = licenseName.replaceAll("/", "_") + " - " + licenseUrlFile.getName();
            }
            if ((extensionIndex = licenseFileName.lastIndexOf(".")) == -1 || extensionIndex > licenseFileName.length() - 3) {
                licenseFileName = licenseFileName + defaultExtension;
            }
            licenseFileName = licenseFileName.toLowerCase();
        }
        return licenseFileName;
    }
}

