/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractLicenseMojo;
import org.codehaus.mojo.license.api.DefaultThirdPartyHelper;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.ThirdPartyHelper;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.Dependency;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.LicenseRegistryClient;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.mojo.license.utils.SortedProperties;
import org.codehaus.mojo.license.utils.StringToList;

public abstract class AbstractAddThirdPartyMojo
extends AbstractLicenseMojo {
    protected static final String DEP_SEPARATOR = "--";
    @Parameter(property="license.outputDirectory", defaultValue="${project.build.directory}/generated-resources/licenses", required=true)
    private File outputDirectory;
    @Parameter(property="license.deployMissingFile", defaultValue="true")
    boolean deployMissingFile;
    @Parameter(property="license.useRepositoryMissingFiles", defaultValue="true")
    boolean useRepositoryMissingFiles;
    @Parameter(property="license.acceptPomPackaging", defaultValue="false")
    boolean acceptPomPackaging;
    @Parameter(property="license.excludedScopes", defaultValue="system")
    String excludedScopes;
    @Parameter(property="license.includedScopes")
    String includedScopes;
    @Parameter(property="license.excludedGroups")
    String excludedGroups;
    @Parameter(property="license.includedGroups")
    String includedGroups;
    @Parameter(property="license.excludedArtifacts")
    String excludedArtifacts;
    @Parameter(property="license.includedArtifacts")
    String includedArtifacts;
    @Parameter(property="license.includeTransitiveDependencies", defaultValue="true")
    boolean includeTransitiveDependencies;
    @Parameter(property="license.excludeTransitiveDependencies", defaultValue="false")
    boolean excludeTransitiveDependencies;
    @Parameter(property="license.thirdPartyFilename", defaultValue="THIRD-PARTY.txt", required=true)
    String thirdPartyFilename;
    @Parameter(property="license.thirdPartyDepsFilename", defaultValue="THIRD-PARTY-DEPS", required=true)
    String thirdPartyDepsJsonFilename;
    @Parameter(property="license.useMissingFile", defaultValue="false")
    boolean useMissingFile;
    @Parameter(property="license.missingFile", defaultValue="src/license/THIRD-PARTY.properties")
    File missingFile;
    @Parameter(property="license.missingLicensesFileArtifact")
    String missingLicensesFileArtifact;
    @Parameter(property="license.overrideFile", defaultValue="src/license/override-THIRD-PARTY.properties")
    File overrideFile;
    @Parameter
    List<String> licenseMerges;
    @Parameter(property="license.includedLicenses")
    IncludedLicenses includedLicenses;
    @Parameter(property="license.hiddenLicenses")
    HiddenLicenses hiddenLicenses;
    Map<String, List<Dependency>> includedDependencies = new HashMap<String, List<Dependency>>();
    Set<Dependency> listedDependencies;
    @Parameter(property="license.excludedLicenses")
    ExcludedLicenses excludedLicenses;
    @Parameter(property="license.bundleThirdPartyPath", defaultValue="META-INF/${project.artifactId}-THIRD-PARTY.txt")
    String bundleThirdPartyPath;
    @Parameter(property="license.generateBundle", defaultValue="false")
    boolean generateBundle;
    @Parameter(property="license.force", defaultValue="false")
    boolean force;
    @Deprecated
    @Parameter(property="license.failIfWarning", defaultValue="false")
    boolean failIfWarning;
    @Parameter(property="license.failOnMissing", defaultValue="false")
    boolean failOnMissing;
    @Parameter(property="license.failOnBlacklist", defaultValue="false")
    boolean failOnBlacklist;
    @Parameter(property="license.failOnNotWhitelistedDependency", defaultValue="false")
    boolean failOnNotWhitelistedDependency;
    @Parameter(property="license.sortArtifactByName", defaultValue="false")
    boolean sortArtifactByName;
    @Parameter(property="license.includedDependenciesWhitelist")
    private String includedDependenciesWhitelist;
    @Parameter(property="license.fileTemplate", defaultValue="/org/codehaus/mojo/license/third-party-file.ftl")
    String fileTemplate;
    @Parameter(property="license.fileWhitelist", defaultValue="licenses-whitelist.txt")
    private String licenseFileWhitelist;
    @Parameter(property="localRepository", required=true, readonly=true)
    ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories", required=true, readonly=true)
    List<ArtifactRepository> remoteRepositories;
    @Parameter(property="project.artifacts", required=true, readonly=true)
    Set<Artifact> dependencies;
    @Component
    private ThirdPartyTool thirdPartyTool;
    @Component
    DependenciesTool dependenciesTool;
    private ThirdPartyHelper helper;
    private SortedMap<String, MavenProject> projectDependencies;
    LicenseMap licenseMap;
    SortedSet<MavenProject> unsafeDependencies;
    private File thirdPartyFile;
    SortedProperties unsafeMappings;
    private boolean doGenerate;
    private boolean doGenerateBundle;
    private Map<String, String> globalKnownLicenses;
    private final BiConsumer<Boolean, String> logError = (error, message) -> {
        Log log = this.getLog();
        if (error.booleanValue()) {
            log.error((CharSequence)message);
        } else {
            log.warn((CharSequence)message);
        }
    };

    protected abstract SortedMap<String, MavenProject> loadDependencies();

    protected abstract SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException, ThirdPartyToolException;

    @Override
    protected void init() throws Exception {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            this.setVerbose(true);
        }
        this.getLog().info((CharSequence)String.format("Loading WHITE licenses: %s", this.licenseFileWhitelist));
        LicenseRegistryClient licenseRegistryClient = LicenseRegistryClient.getInstance();
        this.includedLicenses = new IncludedLicenses(licenseRegistryClient.getFileContent(this.licenseFileWhitelist));
        this.getLog().info((CharSequence)"Loading HIDDEN licenses: licenses-hidden.txt");
        this.hiddenLicenses = new HiddenLicenses(licenseRegistryClient.getFileContent("licenses-hidden.txt"));
        if (StringUtils.isNotBlank((CharSequence)this.includedDependenciesWhitelist)) {
            this.getLog().info((CharSequence)String.format("Loading Dependencies Whitelist: %s", this.includedDependenciesWhitelist));
            this.includedDependencies.putAll((Map)new ObjectMapper().readValue(licenseRegistryClient.getFileContent(this.includedDependenciesWhitelist), (TypeReference)new TypeReference<Map<String, List<Dependency>>>(){}));
        }
        this.thirdPartyFile = new File(this.getOutputDirectory(), this.thirdPartyFilename);
        long buildTimestamp = this.getBuildTimestamp();
        if (this.isVerbose() || this.getLog().isDebugEnabled()) {
            log.debug((CharSequence)("Build start   at : " + buildTimestamp));
            log.debug((CharSequence)("third-party file : " + this.thirdPartyFile.lastModified()));
        }
        boolean bl = this.doGenerate = this.isForce() || !this.thirdPartyFile.exists() || buildTimestamp > this.thirdPartyFile.lastModified();
        if (this.generateBundle) {
            File bundleFile = FileUtil.getFile(this.getOutputDirectory(), this.bundleThirdPartyPath);
            if (this.isVerbose() || this.getLog().isDebugEnabled()) {
                log.debug((CharSequence)("bundle third-party file : " + bundleFile.lastModified()));
            }
            this.doGenerateBundle = this.isForce() || !bundleFile.exists() || buildTimestamp > bundleFile.lastModified();
        } else {
            this.doGenerateBundle = false;
        }
        this.projectDependencies = this.loadDependencies();
        this.licenseMap = this.getHelper().createLicenseMap(this.projectDependencies, this.proxyUrl);
        this.getLog().info((CharSequence)("failOnBlackList=" + this.isFailOnBlacklist() + ", failOnMissing=" + this.isFailOnMissing() + ", failOnNotWhitelistedDependency=" + this.failOnNotWhitelistedDependency));
    }

    void consolidate() throws IOException, ArtifactNotFoundException, ArtifactResolutionException, MojoFailureException, ProjectBuildingException, ThirdPartyToolException {
        this.unsafeDependencies = this.getHelper().getProjectsWithNoLicense(this.licenseMap);
        if (!CollectionUtils.isEmpty(this.unsafeDependencies) && this.isUseMissingFile() && this.isDoGenerate()) {
            this.unsafeMappings = this.createUnsafeMapping();
        }
        this.overrideLicenses();
        if (this.licenseMerges == null) {
            this.licenseMerges = new ArrayList<String>();
        }
        this.getHelper().mergeLicenses(this.licenseMerges, this.licenseMap);
        if (this.checkUnsafeDependencies()) {
            this.resolveUnsafeDependenciesFromFile(this.missingFile);
        }
        if (!StringUtils.isBlank((CharSequence)this.missingLicensesFileArtifact) && this.checkUnsafeDependencies()) {
            String[] tokens = StringUtils.split((String)this.missingLicensesFileArtifact, (String)":");
            if (tokens.length != 3) {
                throw new MojoFailureException("Invalid missing licenses artifact, you must specify groupId:artifactId:version " + this.missingLicensesFileArtifact);
            }
            String groupId = tokens[0];
            String artifactId = tokens[1];
            String version = tokens[2];
            this.resolveUnsafeDependenciesFromArtifact(groupId, artifactId, version);
        }
    }

    File getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isFailIfWarning() {
        return this.failIfWarning;
    }

    SortedMap<String, MavenProject> getProjectDependencies() {
        return this.projectDependencies;
    }

    SortedSet<MavenProject> getUnsafeDependencies() {
        return this.unsafeDependencies;
    }

    public LicenseMap getLicenseMap() {
        return this.licenseMap;
    }

    public boolean isUseMissingFile() {
        return this.useMissingFile;
    }

    File getMissingFile() {
        return this.missingFile;
    }

    File getOverrideFile() {
        return this.overrideFile;
    }

    SortedProperties getUnsafeMappings() {
        return this.unsafeMappings;
    }

    boolean isForce() {
        return this.force;
    }

    boolean isDoGenerate() {
        return this.doGenerate;
    }

    boolean isDoGenerateBundle() {
        return this.doGenerateBundle;
    }

    private List<String> getExcludedLicenses() {
        return this.excludedLicenses.getData();
    }

    private List<String> getHiddenLicenses() {
        return this.hiddenLicenses.getData();
    }

    private List<String> getIncludedLicenses() {
        return this.includedLicenses.getData();
    }

    public void setIncludedLicenses(String includedLicenses) {
        this.includedLicenses = new IncludedLicenses(includedLicenses);
    }

    public void setExcludedLicenses(String excludedLicenses) {
        this.excludedLicenses = new ExcludedLicenses(excludedLicenses);
    }

    protected ThirdPartyHelper getHelper() {
        if (this.helper == null) {
            this.helper = new DefaultThirdPartyHelper(this.getProject(), this.getEncoding(), this.isVerbose(), this.dependenciesTool, this.thirdPartyTool, this.localRepository, this.remoteRepositories, this.getLog());
        }
        return this.helper;
    }

    void resolveUnsafeDependenciesFromArtifact(String groupId, String artifactId, String version) throws ArtifactNotFoundException, IOException, ArtifactResolutionException {
        File missingLicensesFromArtifact = this.thirdPartyTool.resolveMissingLicensesDescriptor(groupId, artifactId, version, this.localRepository, this.remoteRepositories);
        this.resolveUnsafeDependenciesFromFile(missingLicensesFromArtifact);
    }

    void resolveUnsafeDependenciesFromFile(File missingLicenses) throws IOException {
        SortedSet<MavenProject> unsafeDeps = this.getUnsafeDependencies();
        if (missingLicenses != null && missingLicenses.exists() && missingLicenses.length() > 0L) {
            SortedProperties unsafeMappings = new SortedProperties(this.getEncoding());
            if (missingLicenses.exists()) {
                unsafeMappings.load(missingLicenses);
            }
            HashSet<MavenProject> resolvedDependencies = new HashSet<MavenProject>();
            for (MavenProject unsafeDependency : unsafeDeps) {
                String id = MojoHelper.getArtifactId(unsafeDependency.getArtifact());
                if (!unsafeMappings.containsKey(id) || !StringUtils.isNotBlank((CharSequence)unsafeMappings.getProperty(id))) continue;
                this.thirdPartyTool.addLicense(this.licenseMap, unsafeDependency, unsafeMappings.getProperty(id));
                resolvedDependencies.add(unsafeDependency);
            }
            unsafeDeps.removeAll(resolvedDependencies);
        }
    }

    boolean checkUnsafeDependencies() {
        boolean unsafe;
        SortedSet<MavenProject> unsafeDeps = this.getUnsafeDependencies();
        boolean bl = unsafe = !CollectionUtils.isEmpty(unsafeDeps);
        if (unsafe) {
            Log log = this.getLog();
            log.debug((CharSequence)("There is " + unsafeDeps.size() + " dependencies with no license :"));
            for (MavenProject dep : unsafeDeps) {
                log.debug((CharSequence)(" - " + MojoHelper.getArtifactId(dep.getArtifact())));
            }
        }
        return unsafe;
    }

    boolean checkForbiddenLicenses() {
        boolean safe;
        List<String> whiteLicenses = this.getIncludedLicenses();
        List<String> blackLicenses = this.getExcludedLicenses();
        List<String> hiddenLicenses = this.getHiddenLicenses();
        HashSet<String> unsafeLicenses = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(blackLicenses)) {
            Set licenses = this.getLicenseMap().keySet();
            this.getLog().info((CharSequence)("Excluded licenses (blacklist): " + AbstractAddThirdPartyMojo.prettyString(blackLicenses)));
            for (String excludeLicense : blackLicenses) {
                if (!licenses.contains(excludeLicense) || !CollectionUtils.isNotEmpty((Collection)((Collection)this.getLicenseMap().get(excludeLicense)))) continue;
                unsafeLicenses.add(excludeLicense);
            }
        }
        if (CollectionUtils.isNotEmpty(whiteLicenses)) {
            Set dependencyLicenses = this.getLicenseMap().keySet();
            this.getLog().info((CharSequence)("Included licenses (whitelist): " + AbstractAddThirdPartyMojo.prettyString(whiteLicenses)));
            this.getLog().info((CharSequence)("Hidden licenses (HIDDEN): " + AbstractAddThirdPartyMojo.prettyString(hiddenLicenses)));
            for (String dependencyLicense : dependencyLicenses) {
                this.getLog().debug((CharSequence)("Testing license '" + dependencyLicense + "'"));
                SortedSet artifactsWithLicense = (SortedSet)this.getLicenseMap().get(dependencyLicense);
                if (whiteLicenses.contains(dependencyLicense) || !CollectionUtils.isNotEmpty((Collection)artifactsWithLicense)) continue;
                this.getLog().debug((CharSequence)("Testing dependency license '" + dependencyLicense + "' against all other licenses"));
                HashSet<MavenProject> dependenciesWithAllowedLicenses = new HashSet<MavenProject>();
                for (MavenProject dependency : artifactsWithLicense) {
                    this.getLog().debug((CharSequence)("  testing dependency " + dependency));
                    boolean forbiddenLicenseUsed = true;
                    for (String otherLicense : dependencyLicenses) {
                        if (otherLicense.equals(dependencyLicense) || artifactsWithLicense.isEmpty() || !whiteLicenses.contains(otherLicense)) continue;
                        if (hiddenLicenses.contains(dependencyLicense)) {
                            this.getLog().warn((CharSequence)("License '" + dependencyLicense + "' for '" + dependency + "'is HIDDEN'"));
                            forbiddenLicenseUsed = false;
                            break;
                        }
                        if (!((SortedSet)this.getLicenseMap().get(otherLicense)).contains(dependency)) continue;
                        this.getLog().info((CharSequence)("License '" + dependencyLicense + "' for '" + dependency + "'is OK since it is also licensed under '" + otherLicense + "'"));
                        forbiddenLicenseUsed = false;
                        break;
                    }
                    if (forbiddenLicenseUsed) {
                        unsafeLicenses.add(dependencyLicense);
                        continue;
                    }
                    dependenciesWithAllowedLicenses.add(dependency);
                }
                if (dependenciesWithAllowedLicenses.isEmpty()) continue;
                this.getLog().info((CharSequence)(((Object)dependenciesWithAllowedLicenses).toString() + " has forbidden '" + dependencyLicense + "' but are also licensed with good one"));
                artifactsWithLicense.removeAll(dependenciesWithAllowedLicenses);
            }
        }
        if (!(safe = CollectionUtils.isEmpty(unsafeLicenses))) {
            Log log = this.getLog();
            log.warn((CharSequence)("There are " + unsafeLicenses.size() + " forbidden licenses used:"));
            for (String unsafeLicense : unsafeLicenses) {
                SortedSet deps = (SortedSet)this.getLicenseMap().get(unsafeLicense);
                if (deps.isEmpty()) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("License \"").append(unsafeLicense).append("\" used by ").append(deps.size()).append(" dependencies:");
                for (MavenProject dep : deps) {
                    sb.append("\n -").append(MojoHelper.getArtifactName(dep));
                }
                log.warn((CharSequence)sb.toString());
            }
        }
        return safe;
    }

    private static String prettyString(List<String> whiteLicenses) {
        return whiteLicenses.stream().map(it -> "'" + it + "'").collect(Collectors.joining(","));
    }

    boolean checkUnlistedDependencies() {
        boolean unlisted;
        if (this.includedDependencies.isEmpty()) {
            return false;
        }
        this.getLog().info((CharSequence)("Included dependencies (whitelist): " + this.includedDependencies));
        Map<Boolean, Map<String, MavenProject>> partedDependencyMavenProjects = this.projectDependencies.entrySet().stream().collect(Collectors.partitioningBy(kebabedGav -> this.calculateDependency((String)kebabedGav.getKey()).isPresent(), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        this.listedDependencies = partedDependencyMavenProjects.getOrDefault(true, Collections.emptyMap()).entrySet().stream().map(entry -> this.calculateDependency((String)entry.getKey()).map(d -> {
            MavenProject dependency = (MavenProject)entry.getValue();
            d.update(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            return d;
        }).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
        Map unlistedDependencies = partedDependencyMavenProjects.getOrDefault(false, Collections.emptyMap());
        boolean bl = unlisted = !unlistedDependencies.isEmpty();
        if (unlisted) {
            String mainErrorMessage = "There are " + unlistedDependencies.size() + " unlisted dependencies used:";
            this.logError.accept(this.isFailOnNotWhitelistedDependency(), mainErrorMessage);
            unlistedDependencies.values().forEach(ud -> this.logError.accept(this.isFailOnNotWhitelistedDependency(), String.format("unlisted dep: %s:%s:%s", ud.getGroupId(), ud.getArtifactId(), ud.getVersion())));
        }
        return unlisted;
    }

    private Optional<Dependency> calculateDependency(String kebabGav) {
        String groupIdArtifactId = kebabGav.substring(0, kebabGav.lastIndexOf(DEP_SEPARATOR));
        String version = kebabGav.substring(kebabGav.lastIndexOf(DEP_SEPARATOR) + DEP_SEPARATOR.length());
        return this.includedDependencies.getOrDefault(groupIdArtifactId, Collections.emptyList()).stream().filter(dependency -> this.matchesVersion(version, dependency.getVersion())).findAny();
    }

    private boolean matchesVersion(String search, String pattern) {
        return Optional.ofNullable(pattern).map(search::matches).orElse(true);
    }

    void writeThirdPartyFile() throws IOException {
        if (this.doGenerate) {
            LicenseMap licenseMap1 = this.getLicenseMap();
            if (this.sortArtifactByName) {
                licenseMap1 = this.licenseMap.toLicenseMapOrderByName();
            }
            this.thirdPartyTool.writeThirdPartyFile(licenseMap1, this.thirdPartyFile, this.isVerbose(), this.getEncoding(), "templates/third-party-file.ftl", true);
        }
        if (this.doGenerateBundle) {
            this.thirdPartyTool.writeBundleThirdPartyFile(this.thirdPartyFile, this.getOutputDirectory(), this.bundleThirdPartyPath);
        }
    }

    void writeThirdPartyDependenciesFile() throws IOException {
        if (!this.includedDependencies.isEmpty() || this.failOnNotWhitelistedDependency) {
            this.dependenciesTool.writeThirdPartyDependenciesFile(this.getOutputDirectory(), this.thirdPartyDepsJsonFilename + ".json", this.listedDependencies);
        }
    }

    void overrideLicenses() throws IOException {
        this.thirdPartyTool.overrideLicenses(this.licenseMap, this.projectDependencies, this.getEncoding(), "thirdparty-licenses.properties");
    }

    private boolean isFailOnMissing() {
        return this.failOnMissing;
    }

    private boolean isFailOnBlacklist() {
        return this.failOnBlacklist;
    }

    private boolean isFailOnNotWhitelistedDependency() {
        return this.failOnNotWhitelistedDependency;
    }

    void checkMissing(boolean unsafe) throws MojoFailureException {
        if (unsafe && (this.isFailOnMissing() || this.isFailIfWarning())) {
            throw new MojoFailureException("There are some dependencies with no license, please specify them in thirdparty-licenses.properties");
        }
    }

    void checkBlacklist(boolean safeLicense) throws MojoFailureException {
        if (!safeLicense && (this.isFailOnBlacklist() || this.isFailIfWarning())) {
            throw new MojoFailureException("There are some forbidden licenses used, please check your dependencies.");
        }
    }

    void checkDependenciesWhiteList(boolean unlisted) throws MojoFailureException {
        if (unlisted && this.isFailOnNotWhitelistedDependency()) {
            throw new MojoFailureException("There are some unlisted dependencies used, please check those ones.");
        }
    }

    public static class IncludedDependencies
    extends StringToList {
        public IncludedDependencies() {
        }

        public IncludedDependencies(String data) {
            super(data);
        }

        public IncludedDependencies(Collection<String> data) {
            this.getData().addAll(data);
        }
    }

    public static class ExcludedLicenses
    extends StringToList {
        public ExcludedLicenses() {
        }

        ExcludedLicenses(String data) {
            super(data);
        }

        public void setExcludedLicense(String excludeLicense) {
            this.addEntryToList(excludeLicense);
        }
    }

    public static class HiddenLicenses
    extends StringToList {
        public HiddenLicenses() {
        }

        HiddenLicenses(String data) {
            super(data);
        }

        public void setHiddenLicense(String hiddenLicense) {
            this.addEntryToList(hiddenLicense);
        }
    }

    public static class IncludedLicenses
    extends StringToList {
        public IncludedLicenses() {
        }

        IncludedLicenses(String data) {
            super(data);
        }

        public void setIncludedLicense(String includeLicense) {
            this.addEntryToList(includeLicense);
        }
    }
}

