/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.retry.internal;

import java.time.Duration;
import java.util.Objects;
import java.util.StringJoiner;
import org.occurrent.retry.MaxAttempts;
import org.occurrent.retry.RetryInfo;

class RetryInfoImpl
implements RetryInfo {
    private final int attemptNumber;
    private final int retryCount;
    private final MaxAttempts maxAttempts;
    private final Duration backoff;

    public RetryInfoImpl(int attemptNumber, int retryCount, MaxAttempts maxAttempts, Duration backoff) {
        this.attemptNumber = attemptNumber;
        this.retryCount = retryCount;
        this.maxAttempts = maxAttempts;
        this.backoff = backoff;
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    @Override
    public int getMaxAttempts() {
        if (this.isInfiniteRetriesLeft()) {
            return Integer.MAX_VALUE;
        }
        return ((MaxAttempts.Limit)this.maxAttempts).limit();
    }

    @Override
    public int getAttemptsLeft() {
        if (this.isInfiniteRetriesLeft()) {
            return Integer.MAX_VALUE;
        }
        return this.getMaxAttempts() - this.getAttemptNumber() + 1;
    }

    @Override
    public boolean isInfiniteRetriesLeft() {
        return this.maxAttempts instanceof MaxAttempts.Infinite;
    }

    @Override
    public Duration getBackoff() {
        return this.backoff;
    }

    @Override
    public boolean isLastAttempt() {
        if (this.isInfiniteRetriesLeft()) {
            return false;
        }
        return this.getAttemptNumber() == this.getMaxAttempts();
    }

    @Override
    public boolean isFirstAttempt() {
        return this.attemptNumber == 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetryInfoImpl)) {
            return false;
        }
        RetryInfoImpl retryInfo = (RetryInfoImpl)o;
        return this.attemptNumber == retryInfo.attemptNumber && this.retryCount == retryInfo.retryCount && Objects.equals(this.maxAttempts, retryInfo.maxAttempts) && Objects.equals(this.backoff, retryInfo.backoff);
    }

    public int hashCode() {
        return Objects.hash(this.attemptNumber, this.retryCount, this.maxAttempts, this.backoff);
    }

    public String toString() {
        return new StringJoiner(", ", RetryInfoImpl.class.getSimpleName() + "[", "]").add("attemptNumber=" + this.attemptNumber).add("retryCount=" + this.retryCount).add("maxAttempts=" + this.maxAttempts).add("backoff=" + this.backoff).toString();
    }

    RetryInfoImpl increaseAttemptsByOne() {
        return new RetryInfoImpl(this.attemptNumber + 1, this.retryCount, this.maxAttempts, this.backoff);
    }

    RetryInfoImpl withBackoff(Duration backoff) {
        return new RetryInfoImpl(this.attemptNumber, this.retryCount, this.maxAttempts, backoff);
    }
}

