/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.retry.internal;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.occurrent.retry.AfterRetryInfo;
import org.occurrent.retry.Backoff;
import org.occurrent.retry.BeforeRetryInfo;
import org.occurrent.retry.ErrorInfo;
import org.occurrent.retry.MaxAttempts;
import org.occurrent.retry.RetryStrategy;
import org.occurrent.retry.RetryableErrorInfo;

public final class RetryImpl
implements RetryStrategy.Retry {
    private static final BiConsumer<ErrorInfo, Throwable> NOOP_ERROR_LISTENER = (__, ___) -> {};
    private static final BiConsumer<BeforeRetryInfo, Throwable> NOOP_BEFORE_RETRY_LISTENER = (__, ___) -> {};
    private static final BiConsumer<AfterRetryInfo, Throwable> NOOP_AFTER_RETRY_LISTENER = (__, ___) -> {};
    private static final BiConsumer<RetryableErrorInfo, Throwable> NOOP_RETRYABLE_ERROR_LISTENER = (__, ___) -> {};
    final Backoff backoff;
    final MaxAttempts maxAttempts;
    final Predicate<Throwable> retryPredicate;
    final BiConsumer<ErrorInfo, Throwable> errorListener;
    final BiConsumer<BeforeRetryInfo, Throwable> onBeforeRetryListener;
    final BiConsumer<AfterRetryInfo, Throwable> onAfterRetryListener;
    final BiConsumer<RetryableErrorInfo, Throwable> onRetryableErrorListener;
    final Function<Throwable, Throwable> errorMapper;

    private RetryImpl(Backoff backoff, MaxAttempts maxAttempts, Function<Throwable, Throwable> errorMapper, Predicate<Throwable> retryPredicate, BiConsumer<ErrorInfo, Throwable> errorListener, BiConsumer<BeforeRetryInfo, Throwable> onBeforeRetryListener, BiConsumer<AfterRetryInfo, Throwable> onAfterRetryListener, BiConsumer<RetryableErrorInfo, Throwable> onRetryableErrorListener) {
        Objects.requireNonNull(backoff, Backoff.class.getSimpleName() + " cannot be null");
        Objects.requireNonNull(maxAttempts, MaxAttempts.class.getSimpleName() + " cannot be null");
        Objects.requireNonNull(retryPredicate, "Retry predicate cannot be null");
        Objects.requireNonNull(errorMapper, "Error mapper cannot be null");
        this.backoff = backoff;
        this.maxAttempts = maxAttempts;
        this.retryPredicate = retryPredicate;
        this.errorMapper = errorMapper;
        this.errorListener = errorListener == null ? NOOP_ERROR_LISTENER : errorListener;
        this.onBeforeRetryListener = onBeforeRetryListener == null ? NOOP_BEFORE_RETRY_LISTENER : onBeforeRetryListener;
        this.onAfterRetryListener = onAfterRetryListener == null ? NOOP_AFTER_RETRY_LISTENER : onAfterRetryListener;
        this.onRetryableErrorListener = onRetryableErrorListener == null ? NOOP_RETRYABLE_ERROR_LISTENER : onRetryableErrorListener;
    }

    public RetryImpl() {
        this(Backoff.none(), MaxAttempts.Infinite.infinite(), Function.identity(), __ -> true, NOOP_ERROR_LISTENER, NOOP_BEFORE_RETRY_LISTENER, NOOP_AFTER_RETRY_LISTENER, NOOP_RETRYABLE_ERROR_LISTENER);
    }

    @Override
    public RetryStrategy.Retry backoff(Backoff backoff) {
        Objects.requireNonNull(backoff, Backoff.class.getSimpleName() + " cannot be null");
        return new RetryImpl(backoff, this.maxAttempts, this.errorMapper, this.retryPredicate, this.errorListener, this.onBeforeRetryListener, this.onAfterRetryListener, this.onRetryableErrorListener);
    }

    @Override
    public RetryStrategy.Retry infiniteAttempts() {
        return new RetryImpl(this.backoff, MaxAttempts.Infinite.infinite(), this.errorMapper, this.retryPredicate, this.errorListener, this.onBeforeRetryListener, this.onAfterRetryListener, this.onRetryableErrorListener);
    }

    @Override
    public RetryStrategy.Retry maxAttempts(int maxAttempts) {
        return new RetryImpl(this.backoff, new MaxAttempts.Limit(maxAttempts), this.errorMapper, this.retryPredicate, this.errorListener, this.onBeforeRetryListener, this.onAfterRetryListener, this.onRetryableErrorListener);
    }

    @Override
    public RetryImpl retryIf(Predicate<Throwable> retryPredicate) {
        Objects.requireNonNull(retryPredicate, "Retry predicate cannot be null");
        return new RetryImpl(this.backoff, this.maxAttempts, this.errorMapper, retryPredicate, this.errorListener, this.onBeforeRetryListener, this.onAfterRetryListener, this.onRetryableErrorListener);
    }

    @Override
    public RetryStrategy.Retry mapRetryPredicate(Function<Predicate<Throwable>, Predicate<Throwable>> retryPredicateFn) {
        Objects.requireNonNull(retryPredicateFn, "Retry predicate function cannot be null");
        return new RetryImpl(this.backoff, this.maxAttempts, this.errorMapper, retryPredicateFn.apply(this.retryPredicate), this.errorListener, this.onBeforeRetryListener, this.onAfterRetryListener, this.onRetryableErrorListener);
    }

    @Override
    public RetryStrategy.Retry mapError(Function<Throwable, Throwable> errorMapper) {
        Objects.requireNonNull(errorMapper, "Mapping function cannot be null");
        return new RetryImpl(this.backoff, this.maxAttempts, errorMapper, this.retryPredicate, this.errorListener, this.onBeforeRetryListener, this.onAfterRetryListener, this.onRetryableErrorListener);
    }

    @Override
    public <E extends Throwable> RetryStrategy.Retry mapError(Class<E> type, Function<? super E, ? extends Throwable> mapper) {
        Objects.requireNonNull(type, "Exception type cannot be null");
        Objects.requireNonNull(mapper, "Mapper function cannot be null");
        Function<Throwable, Throwable> matchingError = this.errorMapper.andThen(e -> {
            if (type.isAssignableFrom(e.getClass())) {
                return (Throwable)mapper.apply((Object)e);
            }
            return e;
        });
        return new RetryImpl(this.backoff, this.maxAttempts, this.errorMapper.andThen(matchingError), this.retryPredicate, this.errorListener, this.onBeforeRetryListener, this.onAfterRetryListener, this.onRetryableErrorListener);
    }

    @Override
    public RetryStrategy.Retry onError(BiConsumer<ErrorInfo, Throwable> errorListener) {
        return new RetryImpl(this.backoff, this.maxAttempts, this.errorMapper, this.retryPredicate, errorListener, this.onBeforeRetryListener, this.onAfterRetryListener, this.onRetryableErrorListener);
    }

    @Override
    public RetryStrategy.Retry onError(Consumer<Throwable> errorListener) {
        return this.onError((ErrorInfo __, Throwable throwable) -> errorListener.accept((Throwable)throwable));
    }

    @Override
    public RetryStrategy.Retry onRetryableError(Consumer<Throwable> retryableErrorListener) {
        return this.onRetryableError((RetryableErrorInfo __, Throwable throwable) -> retryableErrorListener.accept((Throwable)throwable));
    }

    @Override
    public RetryStrategy.Retry onRetryableError(BiConsumer<RetryableErrorInfo, Throwable> retryableErrorListener) {
        return new RetryImpl(this.backoff, this.maxAttempts, this.errorMapper, this.retryPredicate, this.errorListener, this.onBeforeRetryListener, this.onAfterRetryListener, retryableErrorListener);
    }

    @Override
    public RetryStrategy.Retry onBeforeRetry(BiConsumer<BeforeRetryInfo, Throwable> onBeforeRetryListener) {
        return new RetryImpl(this.backoff, this.maxAttempts, this.errorMapper, this.retryPredicate, this.errorListener, onBeforeRetryListener, this.onAfterRetryListener, this.onRetryableErrorListener);
    }

    @Override
    public RetryStrategy.Retry onBeforeRetry(Consumer<Throwable> onBeforeRetryListener) {
        return this.onBeforeRetry((BeforeRetryInfo __, Throwable throwable) -> onBeforeRetryListener.accept((Throwable)throwable));
    }

    @Override
    public RetryStrategy.Retry onAfterRetry(BiConsumer<AfterRetryInfo, Throwable> onAfterRetryListener) {
        return new RetryImpl(this.backoff, this.maxAttempts, this.errorMapper, this.retryPredicate, this.errorListener, this.onBeforeRetryListener, onAfterRetryListener, this.onRetryableErrorListener);
    }

    @Override
    public RetryStrategy.Retry onAfterRetry(Consumer<Throwable> onAfterRetryListener) {
        return this.onAfterRetry((AfterRetryInfo __, Throwable throwable) -> onAfterRetryListener.accept((Throwable)throwable));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetryImpl)) {
            return false;
        }
        RetryImpl that = (RetryImpl)o;
        return Objects.equals(this.backoff, that.backoff) && Objects.equals(this.maxAttempts, that.maxAttempts) && Objects.equals(this.retryPredicate, that.retryPredicate) && Objects.equals(this.errorListener, that.errorListener) && Objects.equals(this.onBeforeRetryListener, that.onBeforeRetryListener) && Objects.equals(this.onAfterRetryListener, that.onAfterRetryListener) && Objects.equals(this.onRetryableErrorListener, that.onRetryableErrorListener) && Objects.equals(this.errorMapper, that.errorMapper);
    }

    public int hashCode() {
        return Objects.hash(this.backoff, this.maxAttempts, this.retryPredicate, this.errorListener, this.onBeforeRetryListener, this.onAfterRetryListener, this.onRetryableErrorListener, this.errorMapper);
    }

    public String toString() {
        return new StringJoiner(", ", RetryImpl.class.getSimpleName() + "[", "]").add("backoff=" + this.backoff).add("maxAttempts=" + this.maxAttempts).add("retryPredicate=" + this.retryPredicate).add("errorListener=" + this.errorListener).add("onBeforeRetryListener=" + this.onBeforeRetryListener).add("onAfterRetryListener=" + this.onAfterRetryListener).add("onRetryableErrorListener=" + this.onRetryableErrorListener).add("errorMapper=" + this.errorMapper).toString();
    }
}

