/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.retry.internal;

import java.time.Duration;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.occurrent.retry.AfterRetryInfo;
import org.occurrent.retry.Backoff;
import org.occurrent.retry.MaxAttempts;
import org.occurrent.retry.RetryInfo;
import org.occurrent.retry.RetryStrategy;
import org.occurrent.retry.internal.AfterRetryInfoImpl;
import org.occurrent.retry.internal.BeforeRetryInfoImpl;
import org.occurrent.retry.internal.ErrorInfoImpl;
import org.occurrent.retry.internal.RetryImpl;
import org.occurrent.retry.internal.RetryInfoImpl;
import org.occurrent.retry.internal.RetryableErrorInfoImpl;
import org.occurrent.retry.internal.SafeExceptionRethrower;

public class RetryExecution {
    public static <T1> Supplier<T1> executeWithRetry(Supplier<T1> supplier, Predicate<Throwable> shutdownPredicate, RetryStrategy retryStrategy) {
        return () -> RetryExecution.executeWithRetry(arg_0 -> RetryExecution.lambda$executeWithRetry$0((Supplier)supplier, arg_0), shutdownPredicate, retryStrategy).apply(null);
    }

    public static <T1> Function<RetryInfo, T1> executeWithRetry(Function<RetryInfo, T1> function, Predicate<Throwable> shutdownPredicate, RetryStrategy retryStrategy) {
        if (retryStrategy instanceof RetryStrategy.DontRetry) {
            return function;
        }
        RetryImpl retry = RetryExecution.applyShutdownPredicate(shutdownPredicate, retryStrategy);
        return RetryExecution.executeWithRetry(function, retry, RetryExecution.convertToDelayStream(retry.backoff), 1, null, Duration.ZERO);
    }

    public static Runnable executeWithRetry(Runnable runnable, Predicate<Throwable> shutdownPredicate, RetryStrategy retryStrategy) {
        if (retryStrategy instanceof RetryStrategy.DontRetry) {
            return runnable;
        }
        RetryImpl retry = RetryExecution.applyShutdownPredicate(shutdownPredicate, retryStrategy);
        return RetryExecution.executeWithRetry(runnable, retry, RetryExecution.convertToDelayStream(retry.backoff));
    }

    public static <T1> Consumer<T1> executeWithRetry(Consumer<T1> fn, Predicate<Throwable> shutdownPredicate, RetryStrategy retryStrategy) {
        if (retryStrategy instanceof RetryStrategy.DontRetry) {
            return fn;
        }
        RetryImpl retry = RetryExecution.applyShutdownPredicate(shutdownPredicate, retryStrategy);
        return RetryExecution.executeWithRetry(fn, retry, RetryExecution.convertToDelayStream(retry.backoff));
    }

    private static RetryImpl applyShutdownPredicate(Predicate<Throwable> shutdownPredicate, RetryStrategy retryStrategy) {
        RetryImpl retry = (RetryImpl)retryStrategy;
        return retry.retryIf((Predicate)shutdownPredicate.and(retry.retryPredicate));
    }

    private static Runnable executeWithRetry(Runnable runnable, RetryImpl retry, Iterator<Long> delay) {
        Consumer<Void> runnableConsumer = __ -> runnable.run();
        return () -> RetryExecution.executeWithRetry(runnableConsumer, retry, delay).accept(null);
    }

    private static <T1> Consumer<T1> executeWithRetry(Consumer<T1> fn, RetryImpl retry, Iterator<Long> delay) {
        return t1 -> RetryExecution.executeWithRetry(retryInfo -> {
            fn.accept(t1);
            return null;
        }, retry, delay, 1, null, Duration.ZERO).apply(null);
    }

    private static <T1> Function<RetryInfo, T1> executeWithRetry(Function<RetryInfo, T1> fn, RetryImpl retry, Iterator<Long> delay, int attempt, Throwable lastError, Duration previousBackoff) {
        return RetryInfo2 -> {
            boolean currentAttemptIsARetryAttempt;
            RetryInfoImpl nextRetryInfo = RetryExecution.evolveRetryInfo(retry, delay, attempt);
            RetryInfoImpl retryInfoWithPreviousBackoff = nextRetryInfo.withBackoff(previousBackoff);
            boolean bl = currentAttemptIsARetryAttempt = lastError != null;
            if (currentAttemptIsARetryAttempt) {
                retry.onBeforeRetryListener.accept(new BeforeRetryInfoImpl(retryInfoWithPreviousBackoff), lastError);
            }
            try {
                Object result = fn.apply(retryInfoWithPreviousBackoff);
                if (currentAttemptIsARetryAttempt) {
                    retry.onAfterRetryListener.accept(new AfterRetryInfoImpl(retryInfoWithPreviousBackoff, new AfterRetryInfo.ResultOfRetryAttempt.Success(), null), lastError);
                }
                return result;
            }
            catch (Throwable e) {
                Duration currentBackoff = nextRetryInfo.getBackoff();
                boolean shouldRetryAgain = !RetryExecution.isExhausted(attempt, retry.maxAttempts) && retry.retryPredicate.test(e);
                retry.errorListener.accept(new ErrorInfoImpl(retryInfoWithPreviousBackoff, shouldRetryAgain ? currentBackoff : null, shouldRetryAgain), e);
                if (shouldRetryAgain) {
                    retry.onRetryableErrorListener.accept(new RetryableErrorInfoImpl(retryInfoWithPreviousBackoff, currentBackoff), e);
                    if (currentAttemptIsARetryAttempt) {
                        retry.onAfterRetryListener.accept(new AfterRetryInfoImpl(retryInfoWithPreviousBackoff, new AfterRetryInfo.ResultOfRetryAttempt.Failed(e), currentBackoff), lastError);
                    }
                    try {
                        long backoffMillis = nextRetryInfo.getBackoff().toMillis();
                        if (backoffMillis > 0L) {
                            Thread.sleep(backoffMillis);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(e);
                    }
                    return RetryExecution.executeWithRetry(fn, retry, delay, attempt + 1, e, currentBackoff).apply(nextRetryInfo);
                }
                if (currentAttemptIsARetryAttempt) {
                    retry.onAfterRetryListener.accept(new AfterRetryInfoImpl(retryInfoWithPreviousBackoff, new AfterRetryInfo.ResultOfRetryAttempt.Failed(e), null), lastError);
                }
                return SafeExceptionRethrower.safeRethrow(retry.errorMapper.apply(e));
            }
        };
    }

    private static RetryInfoImpl evolveRetryInfo(RetryImpl retry, Iterator<Long> delay, int attempt) {
        Long backoffMillis = delay.next();
        Duration backoffDuration = backoffMillis == 0L ? Duration.ZERO : Duration.ofMillis(backoffMillis);
        return new RetryInfoImpl(attempt, attempt - 1, retry.maxAttempts, backoffDuration);
    }

    private static boolean isExhausted(int attempt, MaxAttempts maxAttempts) {
        if (maxAttempts instanceof MaxAttempts.Infinite) {
            return false;
        }
        return attempt >= ((MaxAttempts.Limit)maxAttempts).limit();
    }

    private static Iterator<Long> convertToDelayStream(Backoff backoff) {
        Stream<Long> delay;
        if (backoff instanceof Backoff.None) {
            delay = Stream.iterate(0L, __ -> 0L);
        } else if (backoff instanceof Backoff.Fixed) {
            long millis = ((Backoff.Fixed)backoff).millis;
            delay = Stream.iterate(millis, __ -> millis);
        } else if (backoff instanceof Backoff.Exponential) {
            Backoff.Exponential strategy = (Backoff.Exponential)backoff;
            long initialMillis = strategy.initial.toMillis();
            long maxMillis = strategy.max.toMillis();
            double multiplier = strategy.multiplier;
            delay = Stream.iterate(initialMillis, current -> Math.min(maxMillis, Math.round((double)current.longValue() * multiplier)));
        } else {
            throw new IllegalStateException("Invalid retry strategy: " + backoff.getClass().getName());
        }
        return delay.iterator();
    }

    private static /* synthetic */ Object lambda$executeWithRetry$0(Supplier supplier, RetryInfo __) {
        return supplier.get();
    }
}

