/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.retry;

import java.time.Duration;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.occurrent.retry.AfterRetryInfo;
import org.occurrent.retry.Backoff;
import org.occurrent.retry.BeforeRetryInfo;
import org.occurrent.retry.ErrorInfo;
import org.occurrent.retry.RetryInfo;
import org.occurrent.retry.RetryableErrorInfo;
import org.occurrent.retry.internal.RetryExecution;
import org.occurrent.retry.internal.RetryImpl;

public interface RetryStrategy {
    public static Retry retry() {
        return new RetryImpl();
    }

    public static DontRetry none() {
        return DontRetry.INSTANCE;
    }

    public static Retry exponentialBackoff(Duration initial, Duration max, double multiplier) {
        return RetryStrategy.retry().backoff(Backoff.exponential(initial, max, multiplier));
    }

    public static Retry fixed(Duration duration) {
        return RetryStrategy.retry().backoff(Backoff.fixed(duration));
    }

    public static Retry fixed(long millis) {
        return RetryStrategy.retry().backoff(Backoff.fixed(millis));
    }

    default public <T> T execute(Function<RetryInfo, T> function) {
        Objects.requireNonNull(function, Supplier.class.getSimpleName() + " cannot be null");
        return RetryExecution.executeWithRetry(function, __ -> true, this).apply(null);
    }

    default public <T> T execute(Supplier<T> supplier) {
        Objects.requireNonNull(supplier, Supplier.class.getSimpleName() + " cannot be null");
        return RetryExecution.executeWithRetry(supplier, __ -> true, this).get();
    }

    default public void execute(Runnable runnable) {
        Objects.requireNonNull(runnable, Runnable.class.getSimpleName() + " cannot be null");
        RetryExecution.executeWithRetry(runnable, __ -> true, this).run();
    }

    public static final class DontRetry
    implements RetryStrategy {
        private static final DontRetry INSTANCE = new DontRetry();

        private DontRetry() {
        }

        public String toString() {
            return DontRetry.class.getSimpleName();
        }
    }

    public static interface Retry
    extends RetryStrategy {
        public Retry backoff(Backoff var1);

        public Retry infiniteAttempts();

        public Retry maxAttempts(int var1);

        public Retry retryIf(Predicate<Throwable> var1);

        public Retry mapRetryPredicate(Function<Predicate<Throwable>, Predicate<Throwable>> var1);

        public Retry mapError(Function<Throwable, Throwable> var1);

        public <E extends Throwable> Retry mapError(Class<E> var1, Function<? super E, ? extends Throwable> var2);

        public Retry onError(BiConsumer<ErrorInfo, Throwable> var1);

        public Retry onError(Consumer<Throwable> var1);

        public Retry onRetryableError(Consumer<Throwable> var1);

        public Retry onRetryableError(BiConsumer<RetryableErrorInfo, Throwable> var1);

        public Retry onBeforeRetry(BiConsumer<BeforeRetryInfo, Throwable> var1);

        public Retry onBeforeRetry(Consumer<Throwable> var1);

        public Retry onAfterRetry(BiConsumer<AfterRetryInfo, Throwable> var1);

        public Retry onAfterRetry(Consumer<Throwable> var1);
    }
}

