/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.retry;

import java.time.Duration;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Backoff {
    public static Backoff none() {
        return new None();
    }

    public static Backoff fixed(long millis) {
        return new Fixed(millis);
    }

    public static Backoff fixed(Duration duration) {
        Objects.requireNonNull(duration, "Duration cannot be null");
        return new Fixed(duration.toMillis());
    }

    public static Backoff exponential(Duration initial, Duration max, double multiplier) {
        return new Exponential(initial, max, multiplier);
    }

    public static final class None
    implements Backoff {
        private None() {
        }
    }

    public static final class Fixed
    implements Backoff {
        public final long millis;

        private Fixed(long millis) {
            if (millis <= 0L) {
                throw new IllegalArgumentException("Millis cannot be less than zero");
            }
            this.millis = millis;
        }
    }

    public static final class Exponential
    implements Backoff {
        public final Duration initial;
        public final Duration max;
        public final double multiplier;

        private Exponential(Duration initial, Duration max, double multiplier) {
            Objects.requireNonNull(initial, "Initial duration cannot be null");
            Objects.requireNonNull(max, "Max duration cannot be null");
            if (multiplier <= 0.0) {
                throw new IllegalArgumentException("multiplier cannot be less than zero");
            }
            this.initial = initial;
            this.max = max;
            this.multiplier = multiplier;
        }
    }
}

