/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.retry;

import java.time.Duration;
import java.util.Optional;
import org.occurrent.retry.RetryInfo;

public interface AfterRetryInfo
extends RetryInfo {
    default public boolean wasSuccessfulRetryAttempt() {
        return this.getResultOfRetryAttempt() instanceof ResultOfRetryAttempt.Success;
    }

    default public boolean wasFailedRetryAttempt() {
        return this.getResultOfRetryAttempt() instanceof ResultOfRetryAttempt.Failed;
    }

    default public Optional<Throwable> getFailedRetryAttemptException() {
        if (this.wasSuccessfulRetryAttempt()) {
            return Optional.empty();
        }
        return Optional.of(((ResultOfRetryAttempt.Failed)this.getResultOfRetryAttempt()).error());
    }

    public Optional<Duration> getBackoffBeforeNextRetryAttempt();

    public ResultOfRetryAttempt getResultOfRetryAttempt();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ResultOfRetryAttempt {

        public record Failed(Throwable error) implements ResultOfRetryAttempt
        {
        }

        public record Success() implements ResultOfRetryAttempt
        {
        }
    }
}

