/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.eventstore.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SortBy {
    public static Unsorted unsorted() {
        return new Unsorted();
    }

    public static Natural natural(SortDirection direction) {
        return new NaturalImpl(direction);
    }

    public static SingleField time(SortDirection direction) {
        return SortBy.field("time", direction);
    }

    public static ComposableSortStep ascending(String field1, String ... fields) {
        return SortBy.combine(field1, SortDirection.ASCENDING, fields);
    }

    public static ComposableSortStep descending(String field1, String ... fields) {
        return SortBy.combine(field1, SortDirection.DESCENDING, fields);
    }

    public static SingleField streamVersion(SortDirection direction) {
        return SortBy.field("streamversion", direction);
    }

    public static SingleField field(String fieldName, SortDirection direction) {
        return new SingleFieldImpl(fieldName, direction);
    }

    private static MultipleSortSteps combine(String field1, SortDirection direction, String[] fields) {
        Objects.requireNonNull(field1, "field1 cannot be null");
        MultipleSortStepsImpl initialSortSteps = new MultipleSortStepsImpl(Collections.singletonList(SortBy.field(field1, direction)));
        MultipleSortSteps stepsToUse = fields != null && fields.length >= 1 ? Stream.of(fields).map(f -> SortBy.field(f, direction)).map(ComposableSortStep.class::cast).reduce(ComposableSortStep::then).map(initialSortSteps::thenMerge).orElseThrow(() -> new IllegalArgumentException("Internal error: Failed to ")) : initialSortSteps;
        return stepsToUse;
    }

    public static final class Unsorted
    implements SortBy {
    }

    public static final class NaturalImpl
    implements Natural {
        public final SortDirection direction;

        private NaturalImpl(SortDirection direction) {
            Objects.requireNonNull(direction, SortDirection.class.getSimpleName() + " cannot be null");
            this.direction = direction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NaturalImpl)) {
                return false;
            }
            NaturalImpl natural = (NaturalImpl)o;
            return this.direction == natural.direction;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.direction});
        }

        public String toString() {
            return new StringJoiner(", ", NaturalImpl.class.getSimpleName() + "[", "]").add("direction=" + this.direction).toString();
        }
    }

    public static enum SortDirection {
        ASCENDING,
        DESCENDING;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface SingleField
    extends ComposableSortStep {
        default public SortBy thenNatural(SortDirection direction) {
            return this.then(new NaturalImpl(direction));
        }

        @Override
        default public MultipleSortStepsImpl then(ComposableSortStep next) {
            return this.then((SortBy)next);
        }

        private MultipleSortStepsImpl then(SortBy other) {
            List<SortBy> list = Arrays.asList(this, other);
            return new MultipleSortStepsImpl(list);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface MultipleSortSteps
    extends ComposableSortStep {
        default public SortBy thenNatural(SortDirection direction) {
            return this.thenMerge(new NaturalImpl(direction));
        }

        @Override
        default public MultipleSortSteps then(ComposableSortStep next) {
            return this.thenMerge(next);
        }

        public MultipleSortSteps thenMerge(SortBy var1);
    }

    public static final class SingleFieldImpl
    implements SingleField {
        public final String fieldName;
        public final SortDirection direction;

        private SingleFieldImpl(String fieldName, SortDirection direction) {
            Objects.requireNonNull(fieldName, "Field name cannot be null");
            Objects.requireNonNull(direction, SortDirection.class.getSimpleName() + " cannot be null");
            this.fieldName = fieldName;
            this.direction = direction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SingleFieldImpl)) {
                return false;
            }
            SingleFieldImpl that = (SingleFieldImpl)o;
            return Objects.equals(this.fieldName, that.fieldName) && this.direction == that.direction;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.fieldName, this.direction});
        }

        public String toString() {
            return new StringJoiner(", ", SingleFieldImpl.class.getSimpleName() + "[", "]").add("fieldName='" + this.fieldName + "'").add("direction=" + this.direction).toString();
        }
    }

    public static final class MultipleSortStepsImpl
    implements MultipleSortSteps {
        public List<SortBy> steps;

        private MultipleSortStepsImpl(List<SortBy> steps) {
            Objects.requireNonNull(steps, "Steps cannot be null");
            if (steps.stream().anyMatch(Objects::isNull)) {
                throw new IllegalArgumentException("Steps cannot contain null step");
            }
            this.steps = Collections.unmodifiableList(steps);
        }

        @Override
        public MultipleSortSteps thenMerge(SortBy next) {
            Objects.requireNonNull(next, ComposableSortStep.class.getSimpleName() + " cannot be null");
            ArrayList<SortBy> newSteps = new ArrayList<SortBy>(this.steps);
            if (next instanceof MultipleSortStepsImpl) {
                newSteps.addAll(((MultipleSortStepsImpl)next).steps);
            } else {
                newSteps.add(next);
            }
            return new MultipleSortStepsImpl(newSteps);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MultipleSortStepsImpl)) {
                return false;
            }
            MultipleSortStepsImpl that = (MultipleSortStepsImpl)o;
            return Objects.equals(this.steps, that.steps);
        }

        public int hashCode() {
            return Objects.hash(this.steps);
        }

        public String toString() {
            return new StringJoiner(", ", MultipleSortStepsImpl.class.getSimpleName() + "[", "]").add("steps=" + this.steps).toString();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ComposableSortStep
    extends SortBy {
        default public MultipleSortSteps then(String fieldName, SortDirection direction) {
            return this.then(SortBy.field(fieldName, direction));
        }

        default public MultipleSortSteps thenStreamVersion(SortDirection direction) {
            return this.then(SortBy.field("streamversion", direction));
        }

        default public MultipleSortSteps thenTime(SortDirection direction) {
            return this.then(SortBy.field("streamversion", direction));
        }

        public MultipleSortSteps then(ComposableSortStep var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Natural
    extends SortBy {
    }
}

