/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.application.service.blocking.generic;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.occurrent.application.converter.CloudEventConverter;
import org.occurrent.application.service.blocking.ApplicationService;
import org.occurrent.eventstore.api.WriteConditionNotFulfilledException;
import org.occurrent.eventstore.api.WriteResult;
import org.occurrent.eventstore.api.blocking.EventStore;
import org.occurrent.eventstore.api.blocking.EventStream;
import org.occurrent.retry.RetryStrategy;

public class GenericApplicationService<T>
implements ApplicationService<T> {
    private final EventStore eventStore;
    private final CloudEventConverter<T> cloudEventConverter;
    private final RetryStrategy retryStrategy;

    public GenericApplicationService(EventStore eventStore, CloudEventConverter<T> cloudEventConverter) {
        this(eventStore, cloudEventConverter, (RetryStrategy)GenericApplicationService.defaultRetryStrategy());
    }

    public GenericApplicationService(EventStore eventStore, CloudEventConverter<T> cloudEventConverter, RetryStrategy retryStrategy) {
        if (eventStore == null) {
            throw new IllegalArgumentException(EventStore.class.getSimpleName() + " cannot be null");
        }
        if (cloudEventConverter == null) {
            throw new IllegalArgumentException(CloudEventConverter.class.getSimpleName() + " cannot be null");
        }
        if (retryStrategy == null) {
            throw new IllegalArgumentException(RetryStrategy.class.getSimpleName() + " cannot be null");
        }
        this.eventStore = eventStore;
        this.cloudEventConverter = cloudEventConverter;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public WriteResult execute(String streamId, Function<Stream<T>, Stream<T>> functionThatCallsDomainModel, Consumer<Stream<T>> sideEffect) {
        Objects.requireNonNull(streamId, "Stream id cannot be null");
        Objects.requireNonNull(functionThatCallsDomainModel, "Function that calls domain model cannot be null");
        record Tuple<T1, T2>(T1 v1, T2 v2) {
        }
        Tuple result = (Tuple)this.retryStrategy.execute(() -> {
            EventStream eventStream = this.eventStore.read(streamId);
            Stream eventsInStream = this.cloudEventConverter.toDomainEvents(eventStream.events());
            Stream newDomainEvents = GenericApplicationService.emptyStreamIfNull((Stream)functionThatCallsDomainModel.apply(eventsInStream));
            List newEventsAsList = sideEffect == null ? null : newDomainEvents.collect(Collectors.toList());
            Stream newEvents = this.cloudEventConverter.toCloudEvents(sideEffect == null ? newDomainEvents : newEventsAsList.stream());
            WriteResult writeResult = this.eventStore.write(streamId, eventStream.version(), newEvents);
            return new Tuple(writeResult, newEventsAsList);
        });
        if (sideEffect != null) {
            sideEffect.accept(((List)result.v2).stream());
        }
        return (WriteResult)result.v1;
    }

    private static <T> Stream<T> emptyStreamIfNull(Stream<T> stream) {
        return stream == null ? Stream.empty() : stream;
    }

    public static RetryStrategy.Retry defaultRetryStrategy() {
        return RetryStrategy.exponentialBackoff((Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(2L), (double)2.0).maxAttempts(5).retryIf(WriteConditionNotFulfilledException.class::isInstance);
    }
}

