/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.application.service.blocking;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface PolicySideEffect<T>
extends Consumer<Stream<T>> {
    public static <T, E extends T> PolicySideEffect<T> executePolicy(Class<E> eventType, Consumer<E> policy) {
        Objects.requireNonNull(eventType, "Event type cannot be null");
        Objects.requireNonNull(policy, "Policy cannot be null");
        return stream -> stream.filter(e -> eventType.isAssignableFrom(e.getClass())).map(eventType::cast).forEach(policy);
    }

    default public <E extends T> PolicySideEffect<T> andThenExecuteAnotherPolicy(Class<E> eventType, Consumer<E> policy) {
        return stream -> {
            List list = stream.collect(Collectors.toList());
            this.accept(list.stream());
            PolicySideEffect secondPolicy = PolicySideEffect.executePolicy(eventType, policy);
            secondPolicy.accept(list.stream());
        };
    }
}

