/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonas.service.manager;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.objectweb.jonas.common.JProp;
import org.objectweb.jonas.common.Log;
import org.objectweb.jonas.naming.context.ComponentContext;
import org.objectweb.jonas.service.Service;
import org.objectweb.jonas.service.ServiceException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ServiceManager {
    static final String SERVICES_PROP_NAME = "jonas.services";
    static final String PREFIX_SERVICE_PROP_NAME = "jonas.service";
    private static Logger logger = null;
    private static ServiceManager unique = null;
    private JProp props = null;
    private static LinkedList<Service> services = null;
    private Map<String, Service> servicesByName = null;
    private Map<Service, Context> contextsByService = null;

    private ServiceManager() {
        logger = Log.getLogger((String)"org.objectweb.jonas.server");
        this.props = JProp.getInstance();
        this.readServices();
    }

    public static ServiceManager getInstance() {
        if (unique == null) {
            unique = new ServiceManager();
        }
        return unique;
    }

    public Service getService(String name) throws ServiceException {
        if (this.servicesByName == null) {
            throw new ServiceException("No service has been initialized yet");
        }
        Service s = this.servicesByName.get(name);
        if (s == null) {
            throw new ServiceException("Unknown service '" + name + "'");
        }
        return s;
    }

    public Service getEjbService() throws ServiceException {
        return this.getService("ejb");
    }

    public Service getEarService() throws ServiceException {
        return this.getService("ear");
    }

    public Service getRarService() throws ServiceException {
        return this.getService("resource");
    }

    public Service getWebContainerService() throws ServiceException {
        return this.getService("web");
    }

    public Service getWebServicesService() throws ServiceException {
        return this.getService("ws");
    }

    public Service getMailService() throws ServiceException {
        return this.getService("mail");
    }

    public Service getDataBaseService() throws ServiceException {
        return this.getService("dbm");
    }

    public Service getTransactionService() throws ServiceException {
        return this.getService("jtm");
    }

    public Service getJmsService() throws ServiceException {
        return this.getService("jms");
    }

    public Service getSecurityService() throws ServiceException {
        return this.getService("security");
    }

    public Service getJmxService() throws ServiceException {
        return this.getService("jmx");
    }

    public Service getDiscoveryService() throws ServiceException {
        return this.getService("discovery");
    }

    public Service getRegistryService() throws ServiceException {
        return this.getService("registry");
    }

    public Service getResourceService() throws ServiceException {
        return this.getService("resource");
    }

    public void startRegistry() throws ServiceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        Service reg = this.getRegistryService();
        try {
            reg.init(this.contextsByService.get(reg));
            reg.start();
            logger.log(BasicLevel.INFO, (Object)"registry service started");
        }
        catch (ServiceException e) {
            throw new ServiceException("Cannot init/start registry" + (Object)((Object)e));
        }
    }

    public void startJmx(String idMBeanServer) throws ServiceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        Service jmxService = this.getJmxService();
        Context paramCtx = this.contextsByService.get(jmxService);
        if (idMBeanServer != null) {
            try {
                paramCtx.bind("idMBeanServer", (Object)idMBeanServer);
            }
            catch (NamingException ne) {
                throw new ServiceException("Cannot bind idMBeanServer = '" + idMBeanServer + "' for JMX service.", (Throwable)ne);
            }
        }
        jmxService.init(paramCtx);
        jmxService.start();
        logger.log(BasicLevel.INFO, (Object)"jmx service started");
    }

    public void startServices() throws ServiceException {
        Context ctx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        Service depMonitorService = this.createServiceFrom("depmonitor");
        services.addLast(depMonitorService);
        try {
            ctx = this.createServiceContextFor("depmonitor");
        }
        catch (NamingException e) {
            throw new ServiceException("Cannot create context for a service", (Throwable)e);
        }
        this.contextsByService.put(depMonitorService, ctx);
        this.servicesByName.put("depmonitor", depMonitorService);
        Context serviceContext = null;
        Service[] services = this.getServices();
        for (int i = 2; i < services.length; ++i) {
            Service service = services[i];
            try {
                serviceContext = this.contextsByService.get(service);
                service.init(serviceContext);
                service.start();
                logger.log(BasicLevel.INFO, (Object)(service.getName() + " service started"));
                continue;
            }
            catch (ServiceException e) {
                throw new ServiceException("Cannot init/start service '" + service.getName() + "': " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public Service[] getServices() throws ServiceException {
        Service[] ss = new Service[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            ss[i] = services.get(i);
        }
        return ss;
    }

    public String[] getServiceNames() {
        int i;
        String[] serviceNames;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        if ((serviceNames = this.props.getValueAsArray(SERVICES_PROP_NAME)) == null) {
            return null;
        }
        if (serviceNames[0].equals("registry") && serviceNames[1].equals("jmx")) {
            return serviceNames;
        }
        ArrayList<String> services = new ArrayList<String>();
        services.add(0, "registry");
        services.add(1, "jmx");
        int nbServices = 2;
        for (i = 0; i < serviceNames.length; ++i) {
            if (serviceNames[i].equals("registry") || serviceNames[i].equals("jmx")) continue;
            services.add(serviceNames[i]);
            ++nbServices;
        }
        serviceNames = new String[nbServices];
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Created new array of String of size " + services.size()));
        }
        for (i = 0; i < nbServices; ++i) {
            serviceNames[i] = (String)services.get(i);
        }
        return serviceNames;
    }

    protected void readServices() throws ServiceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        services = new LinkedList();
        this.contextsByService = new HashMap<Service, Context>();
        this.servicesByName = new Hashtable<String, Service>();
        String[] serviceNames = this.getServiceNames();
        if (serviceNames == null) {
            throw new ServiceException("Property 'jonas.services' is missing in 'jonas' properties file");
        }
        for (int i = 0; i < serviceNames.length; ++i) {
            String serviceName = serviceNames[i];
            Service serviceObj = this.createServiceFrom(serviceName);
            if (serviceObj == null) continue;
            try {
                Context ctx = this.createServiceContextFor(serviceName);
                services.add(serviceObj);
                this.contextsByService.put(serviceObj, ctx);
                this.servicesByName.put(serviceName, serviceObj);
                continue;
            }
            catch (NamingException e) {
                throw new ServiceException("cannot create the context name of the service '" + serviceName + "'", (Throwable)e);
            }
        }
    }

    protected Service createServiceFrom(String serviceName) throws ServiceException {
        String prefixPropName;
        String serviceClassName;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)serviceName);
        }
        if ((serviceClassName = this.props.getValue((prefixPropName = "jonas.service." + serviceName) + ".class")) == null) {
            throw new ServiceException("Property '" + prefixPropName + ".class' missing in '" + "jonas" + "' properties file");
        }
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            Class<?> serviceClass = classLoader.loadClass(serviceClassName);
            Service service = (Service)serviceClass.newInstance();
            service.setName(serviceName);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("class used: " + serviceClassName));
            }
            return service;
        }
        catch (NoClassDefFoundError ncdfe) {
            logger.log(BasicLevel.WARN, (Object)("WARNING : The service '" + serviceName + "' is disabled because a class for this service is missing." + " Check your services in jonas.properties file and your environment variables. Missing class : '" + ncdfe.getMessage() + "'"), (Throwable)ncdfe);
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            logger.log(BasicLevel.WARN, (Object)("WARNING : The service '" + serviceName + "' is disabled because a class for this service is missing." + " Check your services in jonas.properties file and your environment variables. Missing class : '" + cnfe.getMessage() + "'"), (Throwable)cnfe);
            return null;
        }
        catch (Exception e) {
            throw new ServiceException("Error when creating the service '" + serviceName + "'", (Throwable)e);
        }
    }

    protected Context createServiceContextFor(String serviceName) throws NamingException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)serviceName);
        }
        String prefixPropName = "jonas.service." + serviceName;
        ComponentContext ctx = new ComponentContext(serviceName);
        Enumeration<?> e = this.props.getEnv().propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            if (!propName.startsWith(prefixPropName + ".")) continue;
            ctx.rebind(propName, (Object)this.props.getValue(propName));
            ctx.rebind(propName.substring((prefixPropName + ".").length()), (Object)this.props.getValue(propName));
        }
        ctx.rebind("jonas.name", (Object)this.props.getValue("jonas.name"));
        ctx.rebind("domain.name", (Object)this.props.getValue("domain.name"));
        if (serviceName.equals("jmx")) {
            String prop = this.props.getValue("host.name");
            if (prop != null) {
                ctx.rebind("host.name", (Object)prop);
            }
            if ((prop = this.props.getValue("jmxconnector.port")) != null) {
                ctx.rebind("jmxconnector.port", (Object)prop);
            }
        }
        return ctx;
    }

    public void stopServices() throws ServiceException {
        String msgError = new String();
        String sepError = "";
        Service[] services = this.getServices();
        for (int i = services.length - 1; i >= 0; --i) {
            Service service = services[i];
            if (!service.isStarted()) continue;
            try {
                service.stop();
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)(service.getName() + " service stopped"));
                continue;
            }
            catch (ServiceException e) {
                msgError = msgError.concat(sepError + "Cannot stop the service '" + service.getName() + "': " + (Object)((Object)e));
                sepError = "\n";
            }
        }
        if (msgError.length() != 0) {
            throw new ServiceException(msgError);
        }
    }
}

