/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.seata.aop.trans;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.StringUtils;
import io.seata.spring.annotation.GlobalTransactional;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.TransactionalTemplate;
import io.seata.tm.api.transaction.NoRollbackRule;
import io.seata.tm.api.transaction.RollbackRule;
import io.seata.tm.api.transaction.TransactionInfo;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.nutz.aop.InterceptorChain;
import org.nutz.aop.MethodInterceptor;

public class SeataTransInterceptor
implements MethodInterceptor {
    private static final FailureHandler DEFAULT_FAIL_HANDLER = new DefaultFailureHandlerImpl();
    private final TransactionalTemplate transactionalTemplate = new TransactionalTemplate();
    private final FailureHandler failureHandler;
    private GlobalTransactional globalTrxAnno;
    private String name;

    public SeataTransInterceptor(FailureHandler failureHandler, GlobalTransactional globalTrxAnno, Method method) {
        if (null == failureHandler) {
            failureHandler = DEFAULT_FAIL_HANDLER;
        }
        this.failureHandler = failureHandler;
        this.globalTrxAnno = globalTrxAnno;
        String name = globalTrxAnno.name();
        this.name = !StringUtils.isNullOrEmpty((String)name) ? name : SeataTransInterceptor.formatMethod(method);
    }

    public void filter(final InterceptorChain chain) throws Throwable {
        try {
            this.transactionalTemplate.execute(new TransactionalExecutor(){

                public Object execute() throws Throwable {
                    return chain.doChain();
                }

                public String name() {
                    return SeataTransInterceptor.this.name;
                }

                public TransactionInfo getTransactionInfo() {
                    TransactionInfo transactionInfo = new TransactionInfo();
                    transactionInfo.setTimeOut(SeataTransInterceptor.this.globalTrxAnno.timeoutMills());
                    transactionInfo.setName(this.name());
                    LinkedHashSet<Object> rollbackRules = new LinkedHashSet<Object>();
                    for (Class clazz : SeataTransInterceptor.this.globalTrxAnno.rollbackFor()) {
                        rollbackRules.add(new RollbackRule(clazz));
                    }
                    for (String string : SeataTransInterceptor.this.globalTrxAnno.rollbackForClassName()) {
                        rollbackRules.add(new RollbackRule(string));
                    }
                    for (Class clazz : SeataTransInterceptor.this.globalTrxAnno.noRollbackFor()) {
                        rollbackRules.add(new NoRollbackRule(clazz));
                    }
                    for (String string : SeataTransInterceptor.this.globalTrxAnno.noRollbackForClassName()) {
                        rollbackRules.add(new NoRollbackRule(string));
                    }
                    transactionInfo.setRollbackRules(rollbackRules);
                    return transactionInfo;
                }
            });
        }
        catch (TransactionalExecutor.ExecutionException e) {
            TransactionalExecutor.Code code = e.getCode();
            switch (code) {
                case RollbackDone: {
                    throw e.getOriginalException();
                }
                case BeginFailure: {
                    this.failureHandler.onBeginFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
                case CommitFailure: {
                    this.failureHandler.onCommitFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
                case RollbackFailure: {
                    this.failureHandler.onRollbackFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
            }
            throw new ShouldNeverHappenException("Unknown TransactionalExecutor.Code: " + code);
        }
    }

    public static String formatMethod(Method method) {
        String paramTypes = Arrays.stream(method.getParameterTypes()).map(Class::getName).reduce((p1, p2) -> String.format("%s, %s", p1, p2)).orElse("");
        return method.getName() + "(" + paramTypes + ")";
    }
}

