/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.zdoc.msword;

import java.io.Closeable;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.TextAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Disks;
import org.nutz.lang.util.NutMap;
import org.nutz.lang.util.Tag;
import org.nutz.plugins.zdoc.NutD;
import org.nutz.plugins.zdoc.NutDSet;
import org.nutz.plugins.zdoc.NutDSetRender;
import org.nutz.plugins.zdoc.NutDoc;
import org.nutz.plugins.zdoc.msword.MsWordImageInfo;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STStyleType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;

public abstract class AbstractMsWordDSetRender
implements NutDSetRender {
    private XWPFDocument wdDoc;
    private XWPFNumbering numbering;
    private CTAbstractNum anb;
    private XWPFStyles styles;
    private int maxImageWidth;
    private int maxImageHeight;
    private List<Integer> level_seqs = new ArrayList<Integer>(10);

    public AbstractMsWordDSetRender() {
        this.wdDoc = new XWPFDocument();
        this.styles = this.wdDoc.createStyles();
        this.numbering = this.wdDoc.createNumbering();
        InputStream ins = Streams.fileIn((String)"org/nutz/plugins/zdoc/msword/numbering.xml");
        try {
            try {
                this.anb = CTAbstractNum.Factory.parse((InputStream)ins);
            }
            catch (Exception e) {
                throw Lang.wrapThrow((Throwable)e);
            }
        }
        finally {
            Streams.safeClose((Closeable)ins);
        }
        this.maxImageWidth = 420;
        this.maxImageHeight = 860;
        this.addCustomHeadingStyle("H1", 1, 36, "4288BC");
        this.addCustomHeadingStyle("H2", 2, 28, "4288BC");
        this.addCustomHeadingStyle("H3", 3, 24, "4288BC");
        this.addCustomHeadingStyle("H4", 4, 20, "000000");
        this.addCustomHeadingStyle("H5", 5, 18, "000000");
        this.addCustomHeadingStyle("H6", 6, 16, "000000");
    }

    void addCustomHeadingStyle(String strStyleId, int headingLevel, int pointSize, String hexColor) {
        CTStyle ctStyle = CTStyle.Factory.newInstance();
        ctStyle.setStyleId(strStyleId);
        CTString styleName = CTString.Factory.newInstance();
        styleName.setVal(strStyleId);
        ctStyle.setName(styleName);
        CTDecimalNumber indentNumber = CTDecimalNumber.Factory.newInstance();
        indentNumber.setVal(BigInteger.valueOf(headingLevel));
        ctStyle.setUiPriority(indentNumber);
        CTOnOff onoffnull = CTOnOff.Factory.newInstance();
        ctStyle.setUnhideWhenUsed(onoffnull);
        ctStyle.setQFormat(onoffnull);
        CTPPr ppr = CTPPr.Factory.newInstance();
        ppr.setOutlineLvl(indentNumber);
        ctStyle.setPPr(ppr);
        XWPFStyle style = new XWPFStyle(ctStyle);
        CTHpsMeasure size = CTHpsMeasure.Factory.newInstance();
        size.setVal(new BigInteger(String.valueOf(pointSize)));
        CTHpsMeasure size2 = CTHpsMeasure.Factory.newInstance();
        size2.setVal(new BigInteger(String.valueOf(pointSize)));
        CTFonts fonts = CTFonts.Factory.newInstance();
        fonts.setAscii("Loma");
        CTRPr rpr = CTRPr.Factory.newInstance();
        rpr.setRFonts(fonts);
        rpr.setSz(size);
        rpr.setSzCs(size2);
        CTColor color = CTColor.Factory.newInstance();
        color.setVal((Object)AbstractMsWordDSetRender.hexToBytes(hexColor));
        rpr.setColor(color);
        style.getCTStyle().setRPr(rpr);
        style.setType(STStyleType.PARAGRAPH);
        this.styles.addStyle(style);
    }

    public static byte[] hexToBytes(String hexString) {
        HexBinaryAdapter adapter = new HexBinaryAdapter();
        byte[] bytes = adapter.unmarshal(hexString);
        return bytes;
    }

    @Override
    public void render(NutDSet ds, String target) {
        this.checkPrimerObj(ds);
        this.checkTarget(target);
        this.__do_render(ds, 1);
        this.writeToTarget(this.wdDoc);
    }

    private void __do_render(NutDSet ds, int level) {
        for (NutD d : ds.getChildren()) {
            XWPFParagraph h = this.__create_heading(level);
            this.__join_run_text(h, d.getTitle(d.getName()));
            if (d.isSet()) {
                this.__do_render((NutDSet)d, level + 1);
                continue;
            }
            if (d.isDoc()) {
                NutDoc doc = (NutDoc)d;
                NutMap c = new NutMap().attach((Map)doc.getMeta());
                c.put((Object)"main", (Object)doc.getRootTag().toInnerHtml(false));
                c.put((Object)"tags", (Object)this.__gen_meta_list(doc.getTags()));
                c.put((Object)"authors", (Object)this.__gen_meta_list(doc.getAuthors()));
                this.__do_render_doc(doc, level);
                continue;
            }
            throw Lang.impossible();
        }
    }

    private XWPFParagraph __create_heading(int level) {
        XWPFParagraph h = this.wdDoc.createParagraph();
        h.setStyle("H" + level);
        XWPFRun run = h.createRun();
        return h;
    }

    private String __assign_heading_nb(int level) {
        int i = this.level_seqs.size();
        while (i < level) {
            this.level_seqs.add(0);
            ++i;
        }
        if (this.level_seqs.size() > level) {
            this.level_seqs = this.level_seqs.subList(0, level);
        }
        int il = level - 1;
        int re = this.level_seqs.get(il);
        this.level_seqs.set(il, re + 1);
        return Lang.concat((Object)".", this.level_seqs).toString();
    }

    private void __do_render_doc(NutDoc doc, int level) {
        Tag tag = doc.getRootTag();
        for (Tag sub : tag.getChildTags()) {
            this.__do_render_tag(doc, sub, level);
        }
    }

    private void __do_render_tag(NutDoc doc, Tag tag, int level) {
        int hL = tag.getHeadingLevel();
        if (hL > 0) {
            XWPFParagraph h = this.__create_heading(hL + level);
            this.__join_paragraph(doc, h, tag);
        } else if (tag.isList()) {
            this.__join_list(doc, tag, 0);
        } else {
            XWPFParagraph pa = this.wdDoc.createParagraph();
            this.__join_paragraph(doc, pa, tag);
        }
    }

    private void __join_list(NutDoc doc, Tag tag, int level) {
        XWPFNum num = this.restartNumbering();
        XWPFParagraph pLi = null;
        for (Tag li : tag.getChildTags()) {
            pLi = this.wdDoc.createParagraph();
            pLi.setVerticalAlignment(TextAlignment.CENTER);
            pLi.setNumID(num.getCTNum().getNumId());
            pLi.getCTP().getPPr().getNumPr().addNewIlvl().setVal(BigInteger.valueOf(level));
            for (Tag sub : li.getChildTags()) {
                if (sub.isList()) {
                    this.__join_list(doc, sub, level + 1);
                    continue;
                }
                this.__join_ele(doc, pLi, sub);
            }
        }
    }

    private XWPFNum restartNumbering() {
        XWPFAbstractNum abs = new XWPFAbstractNum(this.anb, this.numbering);
        CTAbstractNum an2 = abs.getAbstractNum();
        an2.setAbstractNumId(BigInteger.ONE);
        this.numbering.addAbstractNum(abs);
        BigInteger numId = this.numbering.addNum(an2.getAbstractNumId());
        XWPFNum num = this.numbering.getNum(numId);
        CTNumLvl lvlOverride = num.getCTNum().addNewLvlOverride();
        lvlOverride.setIlvl(BigInteger.ZERO);
        CTDecimalNumber number = lvlOverride.addNewStartOverride();
        number.setVal(BigInteger.ONE);
        return num;
    }

    private void __join_paragraph(NutDoc doc, XWPFParagraph p, Tag tag) {
        for (Tag ele : tag.getChildTags()) {
            this.__join_ele(doc, p, ele);
        }
    }

    private void __join_ele(NutDoc doc, XWPFParagraph p, Tag ele) {
        if (ele.isTextNode()) {
            this.__join_run_text(p, ele.getNodeValue());
        } else if (ele.is("A")) {
            String href = ele.attr("href");
            if (!Strings.isBlank((CharSequence)href)) {
                CTHyperlink cLink = p.getCTP().addNewHyperlink();
                cLink.setAnchor(href);
                CTText ctText = CTText.Factory.newInstance();
                ctText.setStringValue(ele.getText());
                CTR ctr = CTR.Factory.newInstance();
                ctr.setTArray(new CTText[]{ctText});
                CTFonts fonts = CTFonts.Factory.newInstance();
                fonts.setAscii("Calibri Light");
                CTRPr rpr = ctr.addNewRPr();
                CTColor colour = CTColor.Factory.newInstance();
                colour.setVal((Object)"0000FF");
                rpr.setColor(colour);
                CTRPr rpr1 = ctr.addNewRPr();
                rpr1.addNewU().setVal(STUnderline.SINGLE);
                cLink.setRArray(new CTR[]{ctr});
            } else {
                this.__join_run_text(p, ele.getTextContent());
            }
        } else if (ele.is("^(B|I|U|DEL|CODE)$")) {
            XWPFRun run = p.createRun();
            this.__join_inline_ele(run, ele);
        } else if (ele.is("IMG")) {
            this.__join_image(doc, p, ele);
        } else if (ele.is("BR")) {
            XWPFRun run = p.createRun();
            run.addCarriageReturn();
        } else {
            this.__join_run_text(p, ele.getTextContent());
        }
    }

    private void __join_image(NutDoc doc, XWPFParagraph p, Tag ele) {
        String src = ele.attr("src");
        if (!Strings.isBlank((CharSequence)src)) {
            String aph = Disks.appendPath((String[])new String[]{doc.getParent().getPath(), src});
            aph = Disks.getCanonicalPath((String)aph);
            MsWordImageInfo mwii = this.readPictureInfo(aph, true);
            if (mwii.width > this.maxImageWidth || mwii.height > this.maxImageHeight) {
                float h2;
                float w2;
                float w = mwii.width;
                float h = mwii.height;
                float s = w / h;
                float max_w = this.maxImageWidth;
                float max_h = this.maxImageHeight;
                float max_s = max_w / max_h;
                if (s >= max_s) {
                    w2 = max_w;
                    h2 = w2 / s;
                } else {
                    h2 = max_h;
                    w2 = h2 * s;
                }
                mwii.width = Math.round(w2);
                mwii.height = Math.round(h2);
            }
            XWPFRun run = p.createRun();
            try {
                try {
                    run.addPicture(mwii.ins, mwii.pictureType, mwii.fileName, Units.toEMU((double)mwii.width), Units.toEMU((double)mwii.height));
                }
                catch (Exception e) {
                    throw Lang.wrapThrow((Throwable)e);
                }
            }
            finally {
                Streams.safeClose((Closeable)mwii.ins);
            }
        }
    }

    private void __join_inline_ele(XWPFRun run, Tag ele) {
        if (ele.isTextNode()) {
            run.setText(ele.getTextContent());
            return;
        }
        if (ele.is("B")) {
            run.setBold(true);
        } else if (ele.is("I")) {
            run.setItalic(true);
        } else if (ele.is("U")) {
            run.setUnderline(UnderlinePatterns.SINGLE);
        } else if (ele.is("DEL")) {
            run.setStrikeThrough(true);
        }
        for (Tag sub : ele.getChildTags()) {
            this.__join_inline_ele(run, sub);
        }
    }

    private XWPFRun __join_run_text(XWPFParagraph p, String text) {
        XWPFRun run = p.createRun();
        run.setText(text);
        return run;
    }

    private String __gen_meta_list(List<String> list) {
        return Strings.join((String)", ", list);
    }

    protected abstract MsWordImageInfo readPictureInfo(String var1, boolean var2);

    protected abstract void writeToTarget(XWPFDocument var1);

    protected abstract void checkTarget(String var1);

    protected abstract void checkPrimerObj(NutDSet var1);
}

