/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.zdoc.markdown;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.zdoc.NutD;
import org.nutz.plugins.zdoc.NutDSet;
import org.nutz.plugins.zdoc.NutDoc;
import org.nutz.plugins.zdoc.markdown.AbstractMarkdownDSetParser;

public class LocalMarkdownDSetParser
extends AbstractMarkdownDSetParser {
    private static final Log log = Logs.get();

    @Override
    protected void checkPath(NutDSet home, String path) {
        File dHome = Files.findFile((String)path);
        if (dHome == null) {
            throw Lang.makeThrow((String)"e.zdoc.noexist", (Object[])new Object[]{path});
        }
        if (!dHome.isDirectory()) {
            throw Lang.makeThrow((String)"e.zdoc.shouldBeDir", (Object[])new Object[]{path});
        }
        home.setPrimerObj(dHome);
    }

    @Override
    protected NutMap loadConfig(NutDSet home, String path, String configPath) {
        File dHome = (File)home.getPrimerObj();
        NutMap conf = new NutMap();
        File fConf = Files.getFile((File)dHome, (String)Strings.sBlank((Object)configPath, (String)"zdoc.conf"));
        if (fConf.exists()) {
            BufferedInputStream ins = Streams.buff((InputStream)Streams.fileIn((File)fConf));
            PropertiesProxy pp = new PropertiesProxy((InputStream)ins);
            conf.putAll((Map)pp);
        }
        return conf;
    }

    @Override
    protected void loadTreeByRecur(NutDSet home) {
        this.__load_recur(home);
    }

    private int __load_recur(NutDSet ds) {
        File dir = (File)ds.getPrimerObj();
        File[] fs = dir.listFiles();
        int c_doc_nb = 0;
        File[] fileArray = fs;
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            String fnm;
            File f = fileArray[n2];
            if (!f.isHidden() && !(fnm = f.getName()).startsWith("_")) {
                if (f.isDirectory()) {
                    NutDSet dsub = ds.createSet(fnm);
                    dsub.setPrimerObj(f);
                    c_doc_nb += this.__load_recur(dsub);
                } else if (fnm.endsWith(".md") || fnm.endsWith(".markdown")) {
                    NutDoc doc = ds.createDoc(fnm);
                    doc.setPrimerObj(f);
                    doc.setPrimerContent(Files.read((File)f));
                    ++c_doc_nb;
                }
            }
            ++n2;
        }
        if (c_doc_nb == 0 && !ds.isRoot()) {
            ds.remove();
        }
        return c_doc_nb;
    }

    @Override
    protected void loadTreeByPaths(NutDSet home, String paths) {
        File dHome = (File)home.getPrimerObj();
        String[] lines = Strings.splitIgnoreBlank((String)paths, (String)"\r?\n");
        if (lines != null) {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String[] ss = Strings.splitIgnoreBlank((String)line, (String)":");
                String ph = ss[0];
                File f = Files.getFile((File)dHome, (String)ph);
                if (!f.exists()) {
                    log.warnf("NutD noexists '%s'", new Object[]{ph});
                } else {
                    NutD d;
                    if (f.isFile()) {
                        NutDoc doc = home.createDocByPath(ph, true);
                        doc.setPrimerContent(Files.read((File)f));
                        doc.setDateTime(f.lastModified());
                        d = doc;
                    } else if (f.isDirectory()) {
                        d = home.createSetByPath(ph, true);
                    } else {
                        throw Lang.impossible();
                    }
                    d.setPrimerObj(f);
                    if (ss.length > 1) {
                        d.setTitle(ss[1]);
                    }
                }
                ++n2;
            }
        }
    }
}

