/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.zdoc;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.plugins.zdoc.NutD;
import org.nutz.plugins.zdoc.NutDoc;

public class NutDSet
extends NutD {
    private Map<String, NutD> map = new LinkedHashMap<String, NutD>();
    private List<NutDSet> subs = new LinkedList<NutDSet>();

    public NutDSet(String name) {
        super(name);
    }

    @Override
    public boolean isDoc() {
        return false;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    public NutD get(String path) {
        String[] nms = Strings.splitIgnoreBlank((String)path, (String)"[/\\\\]");
        return this.__get(nms, 0);
    }

    public Collection<NutD> getChildren() {
        return this.map.values();
    }

    public NutD removeChild(String name) {
        NutD d = this.map.remove(name);
        if (d != null && d instanceof NutDSet) {
            this.subs.remove(d);
        }
        return d;
    }

    private NutD __get(String[] nms, int off) {
        if (off < 0 || off >= nms.length) {
            return null;
        }
        String nm = nms[off];
        NutD d = this.map.get(nm);
        if (d != null) {
            if (off < nms.length - 1) {
                return this.__get(nms, off + 1);
            }
            return this;
        }
        return null;
    }

    public NutDoc createDoc(String name) {
        if (this.map.containsKey(name)) {
            throw Lang.makeThrow((String)"e.zdoc.exists : %s/%s", (Object[])new Object[]{this.getPath(), name});
        }
        NutDoc d = new NutDoc(name);
        d.setParent(this);
        this.map.put(name, d);
        return d;
    }

    public NutDoc createDocIfNoExists(String name) {
        NutD d = this.map.get(name);
        if (d == null) {
            d = new NutDoc(name);
            d.setParent(this);
            this.map.put(name, d);
            return (NutDoc)d;
        }
        if (d instanceof NutDoc) {
            return (NutDoc)d;
        }
        throw Lang.makeThrow((String)"e.zdoc.nodoc : %s/%s", (Object[])new Object[]{this.getPath(), name});
    }

    public NutDoc createDocByPath(String path, boolean quiet) {
        String[] nms = Strings.splitIgnoreBlank((String)path, (String)"[/\\\\]");
        NutDSet ds = this;
        int lastIndex = nms.length - 1;
        int i = 0;
        while (i < lastIndex) {
            ds = ds.createSetIfNoExists(nms[i]);
            ++i;
        }
        if (quiet) {
            return ds.createDocIfNoExists(nms[lastIndex]);
        }
        return ds.createDoc(nms[lastIndex]);
    }

    public NutDSet createSet(String name) {
        if (this.map.containsKey(name)) {
            throw Lang.makeThrow((String)"e.zdoc.exists : '%s' already in '%s'", (Object[])new Object[]{name, this.getPath()});
        }
        NutDSet d = new NutDSet(name);
        d.setParent(this);
        this.map.put(name, d);
        this.subs.add(d);
        return d;
    }

    public NutDSet createSetIfNoExists(String name) {
        NutD d = this.map.get(name);
        if (d == null) {
            NutDSet ds = new NutDSet(name);
            ds.setParent(this);
            this.map.put(name, ds);
            this.subs.add(ds);
            return ds;
        }
        if (d instanceof NutDSet) {
            return (NutDSet)d;
        }
        throw Lang.makeThrow((String)"e.zdoc.noset : %s/%s", (Object[])new Object[]{this.getPath(), name});
    }

    public NutDSet createSetByPath(String path, boolean quiet) {
        String[] nms = Strings.splitIgnoreBlank((String)path, (String)"[/\\\\]");
        NutDSet ds = this;
        int lastIndex = nms.length - 1;
        int i = 0;
        while (i < lastIndex) {
            ds = ds.createSetIfNoExists(nms[i]);
            ++i;
        }
        if (quiet) {
            return ds.createSetIfNoExists(nms[lastIndex]);
        }
        return ds.createSet(nms[lastIndex]);
    }
}

