/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.cache.dao.impl.provider;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.nutz.plugins.cache.dao.CacheResult;
import org.nutz.plugins.cache.dao.impl.provider.AbstractDaoCacheProvider;

public class EhcacheDaoCacheProvider
extends AbstractDaoCacheProvider {
    private byte[] lock = new byte[0];
    protected CacheManager cacheManager;

    @Override
    public Object get(String cacheName, String key) {
        Element ele = this.getCache(cacheName, true).get((Serializable)((Object)key));
        if (ele == null) {
            return CacheResult.NOT_FOUNT;
        }
        return this.getSerializer().back(ele.getObjectValue());
    }

    @Override
    public boolean put(String cacheName, String key, Object obj) {
        Object data = this.getSerializer().from(obj);
        this.getCache(cacheName, true).put(new Element((Object)key, data));
        return true;
    }

    @Override
    public void clear(String cacheName) {
        Cache cache = this.getCache(cacheName, false);
        if (cache != null) {
            cache.removeAll();
        }
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Cache getCache(String name, boolean create) {
        Cache cache = this.cacheManager.getCache(name);
        if (cache != null) return cache;
        if (!create) {
            return null;
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            cache = this.cacheManager.getCache(name);
            if (cache != null) return cache;
            this.cacheManager.addCache(name);
            return this.cacheManager.getCache(name);
        }
    }
}

