/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.nettice.core.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;

public class HttpRenderUtil {
    private static String CONTENT_TYPE = "Content-Type";
    private static String CONTENT_LENGTH = "Conteng-Length";

    public static FullHttpResponse renderJSON(String json) {
        return HttpRenderUtil.render(json, "text/x-json;charset=UTF-8");
    }

    public static FullHttpResponse renderText(String text) {
        return HttpRenderUtil.render(text, "text/plain;charset=UTF-8");
    }

    public static FullHttpResponse renderXML(String xml) {
        return HttpRenderUtil.render(xml, "text/xml;charset=UTF-8");
    }

    public static FullHttpResponse renderHTML(String html) {
        return HttpRenderUtil.render(html, "text/html;charset=UTF-8");
    }

    public static FullHttpResponse getErroResponse() {
        return HttpRenderUtil.render("Server error", "text/plain;charset=UTF-8");
    }

    public static FullHttpResponse getNotFoundResponse() {
        return HttpRenderUtil.render("Can not find specified action for name", "text/plain;charset=UTF-8");
    }

    public static FullHttpResponse render(String text, String contentType) {
        if (text == null) {
            text = "";
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])text.getBytes());
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, byteBuf);
        response.headers().add(CONTENT_TYPE, (Object)contentType);
        response.headers().add(CONTENT_LENGTH, (Object)String.valueOf(byteBuf.readableBytes()));
        return response;
    }
}

