/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.nettice.core.ret;

import io.netty.handler.codec.http.FullHttpResponse;
import org.nutz.integration.nettice.core.Return;
import org.nutz.integration.nettice.core.ret.RenderType;
import org.nutz.integration.nettice.core.utils.HttpRenderUtil;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class Render
implements Return {
    private static final Log logger = Logs.get();
    private String data;
    public RenderType renderType;

    public Render(RenderType renderType, String data) {
        this.data = data;
        this.renderType = renderType;
    }

    @Override
    public FullHttpResponse process() throws Exception {
        FullHttpResponse response;
        switch (this.renderType) {
            case JSON: {
                response = HttpRenderUtil.renderJSON(this.data);
                break;
            }
            case TEXT: {
                response = HttpRenderUtil.renderText(this.data);
                break;
            }
            case XML: {
                response = HttpRenderUtil.renderXML(this.data);
                break;
            }
            case HTML: {
                response = HttpRenderUtil.renderHTML(this.data);
                break;
            }
            default: {
                response = HttpRenderUtil.getErroResponse();
                logger.error((Object)"unkown render type");
            }
        }
        return response;
    }
}

