/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.nettice.core.config;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RouterConfig {
    private List<String> actionPackages = new ArrayList<String>();

    public static RouterConfig parse(String filePath) throws Exception {
        File file = Files.findFile((String)filePath);
        if (Lang.isEmpty((Object)file)) {
            throw new IllegalArgumentException("config file [" + filePath + "] not exists");
        }
        return RouterConfig.parse(Streams.fileIn((File)file));
    }

    private static RouterConfig parse(InputStream ins) throws Exception {
        RouterConfig config = new RouterConfig();
        Document document = Lang.xmls().parse(ins);
        NodeList list = document.getElementsByTagName("action-package");
        RouterConfig.parseActionPackages(config.actionPackages, list);
        return config;
    }

    private static void parseActionPackages(List<String> actionPackages, NodeList actionPackage) {
        int i = 0;
        while (i < actionPackage.getLength()) {
            Element actionackage = (Element)actionPackage.item(i);
            NodeList pkg = actionackage.getElementsByTagName("package");
            int number = pkg.getLength();
            int num = 0;
            while (num < number) {
                actionPackages.add(Strings.trim((CharSequence)pkg.item(num).getTextContent()));
                ++num;
            }
            ++i;
        }
    }

    public List<String> getActionPacages() {
        return this.actionPackages;
    }
}

