/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.nettice.core;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.integration.nettice.core.BaseAction;
import org.nutz.integration.nettice.core.config.ActionWrapper;
import org.nutz.integration.nettice.core.config.RouterConfig;
import org.nutz.integration.nettice.core.exception.DuplicateActionException;
import org.nutz.integration.nettice.core.invocation.ActionInvocation;
import org.nutz.integration.nettice.core.invocation.ActionProxy;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.resource.Scans;

public class RouterContext {
    private static final Log log = Logs.get();
    private Map<String, ActionWrapper> actions = new HashMap<String, ActionWrapper>();
    private String suffix = ".action";

    public RouterContext(String configFilePath, String suffix) throws Exception {
        RouterConfig config = RouterConfig.parse(configFilePath);
        this.suffix = "." + suffix;
        this.initActionMap(config);
    }

    public RouterContext(String configFilePath) throws Exception {
        RouterConfig config = RouterConfig.parse(configFilePath);
        this.initActionMap(config);
    }

    private void initActionMap(RouterConfig config) {
        List<String> packages = config.getActionPacages();
        for (String packagee : packages) {
            List clazzs = Scans.me().scanPackage(packagee);
            for (Class clazz : clazzs) {
                try {
                    String[] classUrl;
                    int n;
                    if (!BaseAction.class.isAssignableFrom(clazz)) continue;
                    BaseAction baseAction = (BaseAction)Mirror.me((Class)clazz).born(new Object[0]);
                    At atClass = clazz.getAnnotation(At.class);
                    if (Lang.isEmpty((Object)atClass)) {
                        Method[] methodArray = clazz.getDeclaredMethods();
                        n = methodArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Method method = methodArray[n2];
                            this.registerAction("", baseAction, method);
                            ++n2;
                        }
                        continue;
                    }
                    String[] stringArray = classUrl = atClass.value();
                    int n3 = classUrl.length;
                    n = 0;
                    while (n < n3) {
                        String atUrl = stringArray[n];
                        Method[] methodArray = clazz.getDeclaredMethods();
                        int n4 = methodArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            Method method = methodArray[n5];
                            this.registerAction(atUrl, baseAction, method);
                            ++n5;
                        }
                        ++n;
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
    }

    private void registerAction(String clzAction, BaseAction baseAction, Method method) {
        if (method.getModifiers() == 1) {
            boolean isRight;
            At at = method.getAnnotation(At.class);
            boolean bl = isRight = !Lang.isEmpty((Object)at) || Strings.isNotBlank((CharSequence)clzAction);
            if (isRight) {
                if (Lang.isEmpty((Object)at)) {
                    this.registerAt(clzAction, method, baseAction);
                } else {
                    Object[] actions = at.value();
                    if (Lang.isEmptyArray((Object[])actions)) {
                        this.registerAt(clzAction, method, baseAction);
                    } else {
                        Object[] objectArray = actions;
                        int n = actions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object action = objectArray[n2];
                            this.registerAt(String.valueOf(clzAction) + (String)action, method, baseAction);
                            ++n2;
                        }
                    }
                }
            }
        }
    }

    private void registerAt(String action, Method method, BaseAction baseAction) {
        String actionPath = String.valueOf(action) + method.getName() + this.suffix;
        if (this.actions.get(actionPath) != null) {
            throw new DuplicateActionException(this.actions.get((Object)actionPath).method, method, actionPath);
        }
        ActionWrapper actionWrapper = new ActionWrapper(baseAction, method, actionPath);
        if (log.isDebugEnabled()) {
            log.debugf("load action %s", new Object[]{actionPath});
        }
        this.actions.put(actionPath, actionWrapper);
    }

    public ActionWrapper getActionWrapper(String path) {
        return this.actions.get(path);
    }

    public ActionProxy getActionProxy(ActionWrapper actionWrapper) throws Exception {
        ActionProxy proxy = new ActionProxy();
        ActionInvocation invocation = new ActionInvocation();
        invocation.init(proxy);
        proxy.setActionObject(actionWrapper.actionObject);
        proxy.setMethod(actionWrapper.method);
        proxy.setMethodName(actionWrapper.method.getName());
        proxy.setInvocation(invocation);
        return proxy;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

