/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.nettice.core;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.integration.nettice.core.DataHolder;
import org.nutz.integration.nettice.core.Return;
import org.nutz.integration.nettice.core.convertor.PriTypeConverter;
import org.nutz.integration.nettice.core.convertor.PrimitiveType;
import org.nutz.integration.nettice.core.exception.ActionInvocationException;
import org.nutz.integration.nettice.core.exception.ValidationException;
import org.nutz.integration.nettice.core.utils.GenericsUtil;
import org.nutz.json.Json;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.GET;
import org.nutz.mvc.annotation.POST;
import org.nutz.mvc.annotation.Param;

public class BaseAction {
    protected final Log logger = Logs.get();

    public Return processRequest(Method method, String methodName) throws Exception {
        if (method == null) {
            throw new NoSuchMethodException("Can not find specified method: " + methodName);
        }
        return this.exec(method);
    }

    private Return exec(Method method) throws Exception {
        GET getAnnotation = method.getAnnotation(GET.class);
        POST postAnnotation = method.getAnnotation(POST.class);
        if (getAnnotation != null && postAnnotation != null) {
            throw new IllegalStateException("Both get annotation and post annotation are used, only one can be used at an action");
        }
        Class<?>[] type = method.getParameterTypes();
        Annotation[][] annotationArray = method.getParameterAnnotations();
        Object[] paramTarget = new Object[type.length];
        Map<String, List<String>> paramMap = this.getParamMap();
        int i = 0;
        while (i < type.length) {
            Class<?> typeClasz = type[i];
            Annotation[] annotation = annotationArray[i];
            if (annotation == null || annotation.length == 0) {
                throw new Exception("Must specify a @Read annotation for every parameter in method: " + method.getName());
            }
            Param read = (Param)annotation[0];
            try {
                Object paramValue;
                paramTarget[i] = paramValue = this.getParamValue(paramMap, typeClasz, read, method, i);
            }
            catch (Throwable e) {
                throw this.getInvokeException(method, paramTarget, new IllegalArgumentException("\u53c2\u6570\u4e0d\u5408\u6cd5:" + read.value(), e));
            }
            ++i;
        }
        try {
            return (Return)method.invoke((Object)this, paramTarget);
        }
        catch (InvocationTargetException e) {
            throw this.getInvokeException(method, paramTarget, e.getCause());
        }
        catch (IllegalArgumentException e) {
            throw this.getInvokeException(method, paramTarget, e);
        }
    }

    private Object getParamValue(Map<String, List<String>> paramMap, Class<?> type, Param read, Method method, int index) throws InstantiationException, IllegalAccessException {
        List<Object> value = null;
        String key = read.value();
        String defaultValue = read.df();
        if (key != null && key.length() > 0) {
            if (Map.class.isAssignableFrom(type)) {
                if (index > 0) {
                    throw new ValidationException("Must have only one Map type parameter");
                }
                List<Class> types = GenericsUtil.getMethodGenericParameterTypes(method, index);
                if (types.size() == 2 && (types.get(0) != String.class || types.get(1) != String.class)) {
                    throw new ValidationException("Map type parameter must both be String, Occuring Point: " + method.toGenericString());
                }
                HashMap<String, String> valueMap = new HashMap<String, String>();
                for (String paramKey : paramMap.keySet()) {
                    List<String> valueList = paramMap.get(paramKey);
                    valueMap.put(paramKey, valueList.get(0));
                }
                value = valueMap;
            } else {
                List<String> params = paramMap.get(key);
                if (params != null) {
                    if (PrimitiveType.isPriType(type)) {
                        value = PriTypeConverter.getInstance().convertValue(params.get(0), type);
                    } else if (type.isArray()) {
                        Object[] objArray = params.toArray();
                        String[] strArray = this.objArray2StrArray(objArray);
                        value = PriTypeConverter.getInstance().convertValue(strArray, type);
                    } else if (List.class.isAssignableFrom(type)) {
                        List list = null;
                        List<Class> types = GenericsUtil.getMethodGenericParameterTypes(method, index);
                        Class listType = types.size() == 1 ? types.get(0) : String.class;
                        list = List.class == type ? new ArrayList() : (List)type.newInstance();
                        int i = 0;
                        while (i < params.size()) {
                            if (params.get(i).length() > 0) {
                                list.add(PriTypeConverter.getInstance().convertValue(params.get(i), listType));
                            }
                            ++i;
                        }
                        value = list;
                    }
                } else if (defaultValue != null && PrimitiveType.isPriType(type)) {
                    value = PriTypeConverter.getInstance().convertValue(defaultValue, type);
                }
            }
        }
        return value;
    }

    private String[] objArray2StrArray(Object[] objArray) {
        int length = objArray.length;
        String[] strArray = new String[length];
        int i = 0;
        while (i < length) {
            strArray[i] = String.valueOf(objArray[i]);
            ++i;
        }
        return strArray;
    }

    private Map<String, List<String>> getParamMap() {
        Map<String, List<String>> paramMap = new HashMap<String, List<String>>();
        Object msg = DataHolder.getRequest();
        HttpRequest request = (HttpRequest)msg;
        HttpMethod method = request.method();
        if (method.equals((Object)HttpMethod.GET)) {
            String uri = request.uri();
            QueryStringDecoder queryDecoder = new QueryStringDecoder(uri, Charset.forName("UTF-8"));
            paramMap = queryDecoder.parameters();
        } else if (method.equals((Object)HttpMethod.POST)) {
            FullHttpRequest fullRequest = (FullHttpRequest)msg;
            paramMap = this.getPostParamMap(fullRequest);
        }
        return paramMap;
    }

    private Map<String, List<String>> getPostParamMap(FullHttpRequest fullRequest) {
        Map<String, List<String>> paramMap = new HashMap<String, List<String>>();
        HttpHeaders headers = fullRequest.headers();
        String contentType = this.getContentType(headers);
        if ("application/json".equals(contentType)) {
            String jsonStr = fullRequest.content().toString(Charset.forName("UTF-8"));
            NutMap obj = (NutMap)Json.fromJson(NutMap.class, (CharSequence)jsonStr);
            for (Map.Entry entry : obj.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Class<?> valueType = value.getClass();
                List<Object> valueList = null;
                valueList = paramMap.containsKey(key) ? paramMap.get(key) : new ArrayList();
                if (PrimitiveType.isPriType(valueType)) {
                    valueList.add(value.toString());
                    paramMap.put(key, valueList);
                    continue;
                }
                if (valueType.isArray()) {
                    int length = Array.getLength(value);
                    int i = 0;
                    while (i < length) {
                        String arrayItem = String.valueOf(Array.get(value, i));
                        valueList.add(arrayItem);
                        ++i;
                    }
                    paramMap.put(key, valueList);
                    continue;
                }
                if (List.class.isAssignableFrom(valueType)) {
                    paramMap.put(key, (List)value);
                    continue;
                }
                if (!Map.class.isAssignableFrom(valueType)) continue;
                Map tempMap = (Map)value;
                for (String tempKey : tempMap.keySet()) {
                    ArrayList<String> tempList = new ArrayList<String>();
                    tempList.add((String)tempMap.get(tempKey));
                    paramMap.put(tempKey, tempList);
                }
            }
            return paramMap;
        }
        if ("application/x-www-form-urlencoded".equals(contentType)) {
            String jsonStr = fullRequest.content().toString(Charset.forName("UTF-8"));
            QueryStringDecoder queryDecoder = new QueryStringDecoder(jsonStr, false);
            paramMap = queryDecoder.parameters();
        }
        return paramMap;
    }

    private String getContentType(HttpHeaders headers) {
        String contentType = headers.get("Content-Type").toString();
        String[] list = contentType.split(";");
        return list[0];
    }

    private ActionInvocationException getInvokeException(Method method, Object[] paramTarget, Throwable ex) {
        String msg = "action method=" + method.getName() + ", params=" + Arrays.toString(paramTarget);
        return new ActionInvocationException(method.getName(), paramTarget, msg, ex);
    }
}

